/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.performance.CollectionReplaceableByEnumCollectionVisitor;
import com.siyeh.ig.performance.ReplaceExpressionWithTextFix;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MapReplaceableByEnumMapInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("map.replaceable.by.enum.map.display.name", new Object[0]);
        if (string == null) {
            MapReplaceableByEnumMapInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("map.replaceable.by.enum.map.problem.descriptor", new Object[0]);
        if (string == null) {
            MapReplaceableByEnumMapInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MapReplaceableByEnumMapVisitor();
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        if (infos.length != 1) {
            return null;
        }
        PsiLocalVariable localVariable = (PsiLocalVariable)infos[0];
        PsiType[] parameters2 = CollectionReplaceableByEnumCollectionVisitor.extractParameterType(localVariable, 2);
        if (parameters2 == null) {
            return null;
        }
        PsiType enumParameter = parameters2[0];
        String parameterListText = Arrays.stream(parameters2).map(PsiType::getCanonicalText).collect(Collectors.joining(",", "<", ">"));
        PsiClass probablyEnum = PsiUtil.resolveClassInClassTypeOnly((PsiType)enumParameter);
        if (probablyEnum == null || !probablyEnum.isEnum()) {
            return null;
        }
        String text2 = "new java.util.EnumMap" + parameterListText + "(" + enumParameter.getCanonicalText() + ".class)";
        return new ReplaceExpressionWithTextFix(text2, CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{"EnumMap"}));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/performance/MapReplaceableByEnumMapInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class MapReplaceableByEnumMapVisitor
    extends CollectionReplaceableByEnumCollectionVisitor {
        private MapReplaceableByEnumMapVisitor() {
        }

        @Override
        @NotNull
        protected List<String> getUnreplaceableCollectionNames() {
            List<String> list = Arrays.asList("java.util.concurrent.ConcurrentHashMap", "java.util.concurrent.ConcurrentSkipListMap", "java.util.LinkedHashMap");
            if (list == null) {
                MapReplaceableByEnumMapVisitor.$$$reportNull$$$0(0);
            }
            return list;
        }

        @Override
        @NotNull
        protected List<String> getReplaceableCollectionNames() {
            List<String> list = Collections.singletonList("java.util.HashMap");
            if (list == null) {
                MapReplaceableByEnumMapVisitor.$$$reportNull$$$0(1);
            }
            return list;
        }

        @Override
        @NotNull
        protected String getReplacementCollectionName() {
            if ("java.util.EnumMap" == null) {
                MapReplaceableByEnumMapVisitor.$$$reportNull$$$0(2);
            }
            return "java.util.EnumMap";
        }

        @Override
        @NotNull
        protected String getBaseCollectionName() {
            if ("java.util.Map" == null) {
                MapReplaceableByEnumMapVisitor.$$$reportNull$$$0(3);
            }
            return "java.util.Map";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/siyeh/ig/performance/MapReplaceableByEnumMapInspection$MapReplaceableByEnumMapVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUnreplaceableCollectionNames";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReplaceableCollectionNames";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReplacementCollectionName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBaseCollectionName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

