/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class WaitWhileHoldingTwoLocksInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("wait.while.holding.two.locks.display.name", new Object[0]);
        if (string == null) {
            WaitWhileHoldingTwoLocksInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("wait.while.holding.two.locks.problem.descriptor", new Object[0]);
        if (string == null) {
            WaitWhileHoldingTwoLocksInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new WaitWhileHoldingTwoLocksVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/threading/WaitWhileHoldingTwoLocksInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class WaitWhileHoldingTwoLocksVisitor
    extends BaseInspectionVisitor {
        private WaitWhileHoldingTwoLocksVisitor() {
        }

        public void visitMethod(PsiMethod method) {
            this.checkErrorsIn((PsiElement)method);
        }

        public void visitClassInitializer(PsiClassInitializer initializer) {
            this.checkErrorsIn((PsiElement)initializer);
        }

        private void checkErrorsIn(PsiElement context) {
            context.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){
                private int m_numLocksHeld;

                public void visitClass(PsiClass aClass) {
                }

                public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
                    PsiType parameterType;
                    if (expression2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    super.visitMethodCallExpression(expression2);
                    if (this.m_numLocksHeld < 2) {
                        return;
                    }
                    PsiReferenceExpression methodExpression = expression2.getMethodExpression();
                    String methodName = methodExpression.getReferenceName();
                    if (!"wait".equals(methodName)) {
                        return;
                    }
                    PsiMethod method = expression2.resolveMethod();
                    if (method == null) {
                        return;
                    }
                    PsiParameterList parameterList = method.getParameterList();
                    int numParams = parameterList.getParametersCount();
                    if (numParams > 2) {
                        return;
                    }
                    PsiParameter[] parameters2 = parameterList.getParameters();
                    if (numParams > 0 && !(parameterType = parameters2[0].getType()).equals(PsiType.LONG)) {
                        return;
                    }
                    if (numParams > 1 && !(parameterType = parameters2[1].getType()).equals(PsiType.INT)) {
                        return;
                    }
                    this.registerMethodCallError(expression2, new Object[0]);
                }

                public void visitMethod(@NotNull PsiMethod method) {
                    if (method == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (method.hasModifierProperty("synchronized")) {
                        ++this.m_numLocksHeld;
                    }
                    super.visitMethod(method);
                }

                public void visitSynchronizedStatement(@NotNull PsiSynchronizedStatement synchronizedStatement) {
                    if (synchronizedStatement == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    ++this.m_numLocksHeld;
                    super.visitSynchronizedStatement(synchronizedStatement);
                }

                protected void elementFinished(@NotNull PsiElement element) {
                    if (element == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    super.elementFinished(element);
                    if (element instanceof PsiMethod && ((PsiMethod)element).hasModifierProperty("synchronized") || element instanceof PsiSynchronizedStatement) {
                        --this.m_numLocksHeld;
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "expression";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "method";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "synchronizedStatement";
                            break;
                        }
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "element";
                            break;
                        }
                    }
                    objectArray2[1] = "com/siyeh/ig/threading/WaitWhileHoldingTwoLocksInspection$WaitWhileHoldingTwoLocksVisitor$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitMethodCallExpression";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitMethod";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitSynchronizedStatement";
                            break;
                        }
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[2] = "elementFinished";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
    }
}

