/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.AnnotationInvocationHandler;
import com.intellij.codeInsight.ExternalAnnotationsManager;
import com.intellij.codeInsight.InferredAnnotationsManager;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiConstantEvaluationHelper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.BitUtil;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnnotationUtil {
    public static final String NULLABLE = "org.jetbrains.annotations.Nullable";
    public static final String NOT_NULL = "org.jetbrains.annotations.NotNull";
    public static final String NON_NLS = "org.jetbrains.annotations.NonNls";
    public static final String NLS = "org.jetbrains.annotations.Nls";
    public static final String PROPERTY_KEY = "org.jetbrains.annotations.PropertyKey";
    public static final String PROPERTY_KEY_RESOURCE_BUNDLE_PARAMETER = "resourceBundle";
    public static final String TEST_ONLY = "org.jetbrains.annotations.TestOnly";
    public static final String LANGUAGE = "org.intellij.lang.annotations.Language";
    public static final int CHECK_HIERARCHY = 1;
    public static final int CHECK_EXTERNAL = 2;
    public static final int CHECK_INFERRED = 4;
    public static final int CHECK_TYPE = 8;
    private static final String[] SIMPLE_NAMES = new String[]{"NotNull", "Nullable", "NonNls", "PropertyKey", "TestOnly", "Language", "Identifier", "Pattern", "PrintFormat", "RegExp", "Subst"};

    @Nullable
    public static PsiAnnotation findAnnotation(@Nullable PsiModifierListOwner listOwner, String ... annotationNames) {
        if (annotationNames == null) {
            AnnotationUtil.$$$reportNull$$$0(0);
        }
        return AnnotationUtil.findAnnotation(listOwner, false, annotationNames);
    }

    @Nullable
    public static PsiAnnotation findAnnotation(@Nullable PsiModifierListOwner listOwner, boolean skipExternal, String ... annotationNames) {
        if (annotationNames == null) {
            AnnotationUtil.$$$reportNull$$$0(1);
        }
        if (annotationNames.length == 0) {
            return null;
        }
        HashSet set = annotationNames.length == 1 ? Collections.singleton(annotationNames[0]) : ContainerUtil.newHashSet((Object[])annotationNames);
        return AnnotationUtil.findAnnotation(listOwner, set, skipExternal);
    }

    @Nullable
    public static PsiAnnotation findAnnotation(@Nullable PsiModifierListOwner listOwner, @NotNull Set<String> annotationNames) {
        if (annotationNames == null) {
            AnnotationUtil.$$$reportNull$$$0(2);
        }
        return AnnotationUtil.findAnnotation(listOwner, annotationNames);
    }

    @Nullable
    public static PsiAnnotation findAnnotation(@Nullable PsiModifierListOwner listOwner, @NotNull Collection<String> annotationNames) {
        if (annotationNames == null) {
            AnnotationUtil.$$$reportNull$$$0(3);
        }
        return AnnotationUtil.findAnnotation(listOwner, annotationNames, false);
    }

    @Nullable
    public static PsiAnnotation findAnnotation(@Nullable PsiModifierListOwner listOwner, @NotNull Collection<String> annotationNames, boolean skipExternal) {
        if (annotationNames == null) {
            AnnotationUtil.$$$reportNull$$$0(4);
        }
        if (listOwner == null) {
            return null;
        }
        PsiAnnotation annotation = AnnotationUtil.findOwnAnnotation(listOwner, annotationNames);
        if (annotation != null) {
            return annotation;
        }
        return skipExternal ? null : AnnotationUtil.findNonCodeAnnotation(listOwner, annotationNames);
    }

    private static PsiAnnotation findOwnAnnotation(@NotNull PsiModifierListOwner listOwner, @NotNull Collection<String> annotationNames) {
        PsiModifierList list;
        if (listOwner == null) {
            AnnotationUtil.$$$reportNull$$$0(5);
        }
        if (annotationNames == null) {
            AnnotationUtil.$$$reportNull$$$0(6);
        }
        if ((list = listOwner.getModifierList()) == null) {
            return null;
        }
        for (PsiAnnotation annotation : list.getAnnotations()) {
            if (!annotationNames.contains(annotation.getQualifiedName())) continue;
            return annotation;
        }
        return null;
    }

    private static PsiAnnotation findNonCodeAnnotation(@NotNull PsiModifierListOwner listOwner, @NotNull Collection<String> annotationNames) {
        if (listOwner == null) {
            AnnotationUtil.$$$reportNull$$$0(7);
        }
        if (annotationNames == null) {
            AnnotationUtil.$$$reportNull$$$0(8);
        }
        if (listOwner instanceof PsiLocalVariable) {
            return null;
        }
        Map map = (Map)CachedValuesManager.getCachedValue((PsiElement)listOwner, () -> {
            if (listOwner == null) {
                AnnotationUtil.$$$reportNull$$$0(71);
            }
            ConcurrentMap value = ConcurrentFactoryMap.createMap(annotationNames1 -> {
                if (listOwner == null) {
                    AnnotationUtil.$$$reportNull$$$0(72);
                }
                PsiUtilCore.ensureValid((PsiElement)listOwner);
                Project project = listOwner.getProject();
                ExternalAnnotationsManager annotationsManager = ExternalAnnotationsManager.getInstance(project);
                for (String annotationName : annotationNames1) {
                    PsiAnnotation annotation = annotationsManager.findExternalAnnotation(listOwner, annotationName);
                    if (annotation == null) continue;
                    return annotation;
                }
                InferredAnnotationsManager inferredAnnotationsManager = InferredAnnotationsManager.getInstance(project);
                for (String annotationName : annotationNames1) {
                    PsiAnnotation annotation = inferredAnnotationsManager.findInferredAnnotation(listOwner, annotationName);
                    if (annotation == null) continue;
                    return annotation;
                }
                return null;
            });
            return CachedValueProvider.Result.create((Object)value, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
        return (PsiAnnotation)map.get(annotationNames);
    }

    @NotNull
    public static PsiAnnotation[] findAnnotations(@Nullable PsiModifierListOwner modifierListOwner, @NotNull Collection<String> annotationNames) {
        if (annotationNames == null) {
            AnnotationUtil.$$$reportNull$$$0(9);
        }
        if (modifierListOwner == null) {
            if (PsiAnnotation.EMPTY_ARRAY == null) {
                AnnotationUtil.$$$reportNull$$$0(10);
            }
            return PsiAnnotation.EMPTY_ARRAY;
        }
        PsiModifierList modifierList = modifierListOwner.getModifierList();
        if (modifierList == null) {
            if (PsiAnnotation.EMPTY_ARRAY == null) {
                AnnotationUtil.$$$reportNull$$$0(11);
            }
            return PsiAnnotation.EMPTY_ARRAY;
        }
        PsiAnnotation[] annotations = modifierList.getAnnotations();
        ArrayList<PsiAnnotation> result = null;
        for (PsiAnnotation psiAnnotation : annotations) {
            if (!annotationNames.contains(psiAnnotation.getQualifiedName())) continue;
            if (result == null) {
                result = new ArrayList<PsiAnnotation>();
            }
            result.add(psiAnnotation);
        }
        PsiAnnotation[] psiAnnotationArray = result == null ? PsiAnnotation.EMPTY_ARRAY : result.toArray(PsiAnnotation.EMPTY_ARRAY);
        if (psiAnnotationArray == null) {
            AnnotationUtil.$$$reportNull$$$0(12);
        }
        return psiAnnotationArray;
    }

    @NotNull
    public static <T extends PsiModifierListOwner> List<T> getSuperAnnotationOwners(@NotNull T element) {
        if (element == null) {
            AnnotationUtil.$$$reportNull$$$0(13);
        }
        List list = (List)CachedValuesManager.getCachedValue(element, () -> {
            List<Object> list;
            if (element == null) {
                AnnotationUtil.$$$reportNull$$$0(70);
            }
            LinkedHashSet result = ContainerUtil.newLinkedHashSet();
            if (element instanceof PsiMethod) {
                AnnotationUtil.collectSuperMethods(result, ((PsiMethod)element).getHierarchicalMethodSignature(), element, JavaPsiFacade.getInstance(element.getProject()).getResolveHelper());
            } else if (element instanceof PsiClass) {
                InheritanceUtil.processSupers((PsiClass)element, false, (Processor<? super PsiClass>)Processors.cancelableCollectProcessor((Collection)result));
            } else if (element instanceof PsiParameter) {
                AnnotationUtil.collectSuperParameters(result, (PsiParameter)element);
            }
            if (result.isEmpty()) {
                list = Collections.emptyList();
            } else {
                PsiModifierListOwner[] array = result.toArray(new PsiModifierListOwner[0]);
                list = Arrays.asList(array);
            }
            return CachedValueProvider.Result.create(list, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
        if (list == null) {
            AnnotationUtil.$$$reportNull$$$0(14);
        }
        return list;
    }

    @Nullable
    public static PsiAnnotation findAnnotationInHierarchy(@NotNull PsiModifierListOwner listOwner, @NotNull Set<String> annotationNames) {
        PsiAnnotation directAnnotation;
        if (listOwner == null) {
            AnnotationUtil.$$$reportNull$$$0(15);
        }
        if (annotationNames == null) {
            AnnotationUtil.$$$reportNull$$$0(16);
        }
        if ((directAnnotation = AnnotationUtil.findAnnotation(listOwner, annotationNames)) != null) {
            return directAnnotation;
        }
        for (PsiModifierListOwner superOwner : AnnotationUtil.getSuperAnnotationOwners(listOwner)) {
            PsiAnnotation annotation = AnnotationUtil.findAnnotation(superOwner, annotationNames);
            if (annotation == null) continue;
            return annotation;
        }
        return null;
    }

    private static void collectSuperParameters(@NotNull Set<? super PsiModifierListOwner> result, @NotNull PsiParameter parameter) {
        block7: {
            PsiElement scope;
            Consumer forEachSuperMethod;
            block6: {
                PsiElement parent;
                if (result == null) {
                    AnnotationUtil.$$$reportNull$$$0(17);
                }
                if (parameter == null) {
                    AnnotationUtil.$$$reportNull$$$0(18);
                }
                if (!((parent = parameter.getParent()) instanceof PsiParameterList)) {
                    return;
                }
                int index = ((PsiParameterList)parent).getParameterIndex(parameter);
                forEachSuperMethod = method -> {
                    PsiParameter[] superParameters;
                    if (result == null) {
                        AnnotationUtil.$$$reportNull$$$0(69);
                    }
                    if (index < (superParameters = method.getParameterList().getParameters()).length) {
                        result.add(superParameters[index]);
                    }
                };
                scope = parent.getParent();
                if (!(scope instanceof PsiLambdaExpression)) break block6;
                PsiMethod method2 = LambdaUtil.getFunctionalInterfaceMethod(((PsiLambdaExpression)scope).getFunctionalInterfaceType());
                if (method2 == null) break block7;
                forEachSuperMethod.consume((Object)method2);
                for (PsiMethod superMethod : AnnotationUtil.getSuperAnnotationOwners(method2)) {
                    forEachSuperMethod.consume((Object)superMethod);
                }
                break block7;
            }
            if (scope instanceof PsiMethod) {
                for (PsiMethod superMethod : AnnotationUtil.getSuperAnnotationOwners((PsiMethod)scope)) {
                    forEachSuperMethod.consume((Object)superMethod);
                }
            }
        }
    }

    private static void collectSuperMethods(@NotNull Set<? super PsiModifierListOwner> result, @NotNull HierarchicalMethodSignature signature, @NotNull PsiElement place, @NotNull PsiResolveHelper resolveHelper) {
        if (result == null) {
            AnnotationUtil.$$$reportNull$$$0(19);
        }
        if (signature == null) {
            AnnotationUtil.$$$reportNull$$$0(20);
        }
        if (place == null) {
            AnnotationUtil.$$$reportNull$$$0(21);
        }
        if (resolveHelper == null) {
            AnnotationUtil.$$$reportNull$$$0(22);
        }
        for (HierarchicalMethodSignature superSignature : signature.getSuperSignatures()) {
            PsiMethod superMethod = superSignature.getMethod();
            if (!resolveHelper.isAccessible(superMethod, place, null) || !result.add(superMethod)) continue;
            AnnotationUtil.collectSuperMethods(result, superSignature, place, resolveHelper);
        }
    }

    public static boolean isAnnotated(@NotNull PsiModifierListOwner listOwner, @NotNull Collection<String> annotations, @Flags int flags) {
        if (listOwner == null) {
            AnnotationUtil.$$$reportNull$$$0(23);
        }
        if (annotations == null) {
            AnnotationUtil.$$$reportNull$$$0(24);
        }
        return annotations.stream().anyMatch(annotation -> {
            if (listOwner == null) {
                AnnotationUtil.$$$reportNull$$$0(68);
            }
            return AnnotationUtil.isAnnotated(listOwner, annotation, flags, null);
        });
    }

    public static boolean isAnnotated(@NotNull PsiModifierListOwner listOwner, @NotNull String annotationFqn, @Flags int flags) {
        if (listOwner == null) {
            AnnotationUtil.$$$reportNull$$$0(25);
        }
        if (annotationFqn == null) {
            AnnotationUtil.$$$reportNull$$$0(26);
        }
        return AnnotationUtil.isAnnotated(listOwner, annotationFqn, flags, null);
    }

    private static boolean isAnnotated(@NotNull PsiModifierListOwner listOwner, @NotNull String annotationFQN, @Flags int flags, @Nullable Set<? super PsiMember> processed) {
        block18: {
            block19: {
                Project project;
                if (listOwner == null) {
                    AnnotationUtil.$$$reportNull$$$0(27);
                }
                if (annotationFQN == null) {
                    AnnotationUtil.$$$reportNull$$$0(28);
                }
                if (!listOwner.isValid()) {
                    return false;
                }
                PsiModifierList modifierList = listOwner.getModifierList();
                if (modifierList == null) {
                    return false;
                }
                PsiAnnotation annotation = modifierList.findAnnotation(annotationFQN);
                if (annotation != null) {
                    return true;
                }
                if (BitUtil.isSet((int)flags, (int)8)) {
                    PsiType type = null;
                    if (listOwner instanceof PsiMethod) {
                        type = ((PsiMethod)listOwner).getReturnType();
                    } else if (listOwner instanceof PsiVariable) {
                        type = ((PsiVariable)listOwner).getType();
                    }
                    if (type != null && type.hasAnnotation(annotationFQN)) {
                        return true;
                    }
                }
                if (BitUtil.isSet((int)flags, (int)2) && ExternalAnnotationsManager.getInstance(project = listOwner.getProject()).findExternalAnnotation(listOwner, annotationFQN) != null) {
                    return true;
                }
                if (BitUtil.isSet((int)flags, (int)4) && InferredAnnotationsManager.getInstance(project = listOwner.getProject()).findInferredAnnotation(listOwner, annotationFQN) != null) {
                    return true;
                }
                if (!BitUtil.isSet((int)flags, (int)1)) break block18;
                if (!(listOwner instanceof PsiMethod)) break block19;
                PsiMethod method = (PsiMethod)listOwner;
                if (processed == null) {
                    processed = new THashSet();
                }
                if (!processed.add((PsiMember)method)) {
                    return false;
                }
                for (PsiMethod superMethod : method.findSuperMethods()) {
                    if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)superMethod, annotationFQN, flags, (Set<? super PsiMember>)processed)) continue;
                    return true;
                }
                break block18;
            }
            if (!(listOwner instanceof PsiClass)) break block18;
            PsiClass clazz = (PsiClass)listOwner;
            if (processed == null) {
                processed = new THashSet();
            }
            if (!processed.add(clazz)) {
                return false;
            }
            for (PsiClass superClass : clazz.getSupers()) {
                if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)superClass, annotationFQN, flags, (Set<? super PsiMember>)processed)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isAnnotatingApplicable(@NotNull PsiElement elt) {
        if (elt == null) {
            AnnotationUtil.$$$reportNull$$$0(29);
        }
        return AnnotationUtil.isAnnotatingApplicable(elt, NullableNotNullManager.getInstance(elt.getProject()).getDefaultNullable());
    }

    public static boolean isAnnotatingApplicable(@NotNull PsiElement elt, @NotNull String annotationFQN) {
        if (elt == null) {
            AnnotationUtil.$$$reportNull$$$0(30);
        }
        if (annotationFQN == null) {
            AnnotationUtil.$$$reportNull$$$0(31);
        }
        Project project = elt.getProject();
        return PsiUtil.isLanguageLevel5OrHigher(elt) && JavaPsiFacade.getInstance(project).findClass(annotationFQN, elt.getResolveScope()) != null;
    }

    @Contract(value="null,_ -> false")
    public static boolean checkAnnotatedUsingPatterns(@Nullable PsiModifierListOwner owner, @NotNull Collection<String> annotations) {
        PsiModifierList modList;
        if (annotations == null) {
            AnnotationUtil.$$$reportNull$$$0(32);
        }
        if (owner == null || (modList = owner.getModifierList()) == null) {
            return false;
        }
        ArrayList<String> fqns = null;
        for (String fqn : annotations) {
            boolean isPattern = fqn.endsWith("*");
            if (!isPattern && AnnotationUtil.isAnnotated(owner, fqn, 0)) {
                return true;
            }
            if (!isPattern) continue;
            if (fqns == null) {
                PsiAnnotation[] ownAnnotations;
                fqns = new ArrayList<String>();
                for (PsiAnnotation anno : ownAnnotations = modList.getAnnotations()) {
                    String qName = anno.getQualifiedName();
                    if (qName == null) continue;
                    fqns.add(qName);
                }
                if (fqns.isEmpty()) {
                    return false;
                }
            }
            fqn = fqn.substring(0, fqn.length() - 2);
            for (String annoFQN : fqns) {
                if (!annoFQN.startsWith(fqn)) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public static PsiMethod getAnnotationMethod(@NotNull PsiNameValuePair pair) {
        if (pair == null) {
            AnnotationUtil.$$$reportNull$$$0(33);
        }
        PsiAnnotation annotation = (PsiAnnotation)PsiTreeUtil.getParentOfType((PsiElement)pair.getParent(), PsiAnnotation.class);
        assert (annotation != null);
        String fqn = annotation.getQualifiedName();
        if (fqn == null) {
            return null;
        }
        PsiClass psiClass = JavaPsiFacade.getInstance(pair.getProject()).findClass(fqn, pair.getResolveScope());
        if (psiClass != null && psiClass.isAnnotationType()) {
            String name = pair.getName();
            return (PsiMethod)ArrayUtil.getFirstElement((Object[])psiClass.findMethodsByName(name != null ? name : "value", false));
        }
        return null;
    }

    @NotNull
    public static PsiAnnotation[] getAllAnnotations(@NotNull PsiModifierListOwner owner, boolean inHierarchy, @Nullable Set<? super PsiModifierListOwner> visited) {
        if (owner == null) {
            AnnotationUtil.$$$reportNull$$$0(34);
        }
        PsiAnnotation[] psiAnnotationArray = AnnotationUtil.getAllAnnotations(owner, inHierarchy, visited, true);
        if (psiAnnotationArray == null) {
            AnnotationUtil.$$$reportNull$$$0(35);
        }
        return psiAnnotationArray;
    }

    @NotNull
    public static PsiAnnotation[] getAllAnnotations(@NotNull PsiModifierListOwner owner, boolean inHierarchy, @Nullable Set<? super PsiModifierListOwner> visited, boolean withInferred) {
        Project project;
        Object[] externalAnnotations;
        if (owner == null) {
            AnnotationUtil.$$$reportNull$$$0(36);
        }
        PsiModifierList list = owner.getModifierList();
        Object[] annotations = PsiAnnotation.EMPTY_ARRAY;
        if (list != null) {
            annotations = list.getAnnotations();
        }
        if ((externalAnnotations = ExternalAnnotationsManager.getInstance(project = owner.getProject()).findExternalAnnotations(owner)) != null) {
            annotations = (PsiAnnotation[])ArrayUtil.mergeArrays((Object[])annotations, (Object[])externalAnnotations, PsiAnnotation.ARRAY_FACTORY);
        }
        if (withInferred) {
            Object[] inferredAnnotations = InferredAnnotationsManager.getInstance(project).findInferredAnnotations(owner);
            annotations = (PsiAnnotation[])ArrayUtil.mergeArrays((Object[])annotations, (Object[])inferredAnnotations, PsiAnnotation.ARRAY_FACTORY);
        }
        if (inHierarchy) {
            PsiParameter parameter;
            PsiElement scope;
            if (owner instanceof PsiClass) {
                for (PsiClass superClass : ((PsiClass)owner).getSupers()) {
                    if (visited == null) {
                        visited = new THashSet();
                    }
                    if (!visited.add((PsiModifierListOwner)superClass)) continue;
                    annotations = (PsiAnnotation[])ArrayUtil.mergeArrays((Object[])annotations, (Object[])AnnotationUtil.getAllAnnotations(superClass, true, (Set<? super PsiModifierListOwner>)visited, withInferred));
                }
            } else if (owner instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)owner;
                PsiClass aClass = method.getContainingClass();
                if (aClass != null) {
                    HierarchicalMethodSignature methodSignature = method.getHierarchicalMethodSignature();
                    List<HierarchicalMethodSignature> superSignatures = methodSignature.getSuperSignatures();
                    PsiResolveHelper resolveHelper = PsiResolveHelper.SERVICE.getInstance(aClass.getProject());
                    for (HierarchicalMethodSignature superSignature : superSignatures) {
                        PsiMethod superMethod = superSignature.getMethod();
                        if (visited == null) {
                            visited = new THashSet();
                        }
                        if (!visited.add(superMethod) || !resolveHelper.isAccessible(superMethod, owner, null)) continue;
                        annotations = (PsiAnnotation[])ArrayUtil.mergeArrays((Object[])annotations, (Object[])AnnotationUtil.getAllAnnotations(superMethod, true, (Set<? super PsiModifierListOwner>)visited, withInferred));
                    }
                }
            } else if (owner instanceof PsiParameter && (scope = (parameter = (PsiParameter)owner).getDeclarationScope()) instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)scope;
                PsiClass aClass = method.getContainingClass();
                PsiElement parent = parameter.getParent();
                if (aClass != null && parent instanceof PsiParameterList) {
                    int index = ((PsiParameterList)parent).getParameterIndex(parameter);
                    HierarchicalMethodSignature methodSignature = method.getHierarchicalMethodSignature();
                    List<HierarchicalMethodSignature> superSignatures = methodSignature.getSuperSignatures();
                    PsiResolveHelper resolveHelper = PsiResolveHelper.SERVICE.getInstance(aClass.getProject());
                    for (HierarchicalMethodSignature superSignature : superSignatures) {
                        PsiParameter[] superParameters;
                        PsiMethod superMethod = superSignature.getMethod();
                        if (visited == null) {
                            visited = new THashSet();
                        }
                        if (!visited.add(superMethod) || !resolveHelper.isAccessible(superMethod, owner, null) || index >= (superParameters = superMethod.getParameterList().getParameters()).length) continue;
                        annotations = (PsiAnnotation[])ArrayUtil.mergeArrays((Object[])annotations, (Object[])AnnotationUtil.getAllAnnotations(superParameters[index], true, (Set<? super PsiModifierListOwner>)visited, withInferred));
                    }
                }
            }
        }
        if (annotations == null) {
            AnnotationUtil.$$$reportNull$$$0(37);
        }
        return annotations;
    }

    public static boolean isInsideAnnotation(@NotNull PsiElement element) {
        if (element == null) {
            AnnotationUtil.$$$reportNull$$$0(38);
        }
        for (int level = 0; level < 4; ++level) {
            if (element instanceof PsiNameValuePair) {
                return true;
            }
            if ((element = element.getParent()) != null) continue;
            return false;
        }
        return false;
    }

    public static boolean isInferredAnnotation(@NotNull PsiAnnotation annotation) {
        if (annotation == null) {
            AnnotationUtil.$$$reportNull$$$0(39);
        }
        return InferredAnnotationsManager.getInstance(annotation.getProject()).isInferredAnnotation(annotation);
    }

    public static boolean isExternalAnnotation(@NotNull PsiAnnotation annotation) {
        if (annotation == null) {
            AnnotationUtil.$$$reportNull$$$0(40);
        }
        return ExternalAnnotationsManager.getInstance(annotation.getProject()).isExternalAnnotation(annotation);
    }

    @Nullable
    public static String getStringAttributeValue(@NotNull PsiAnnotation anno, @Nullable String attributeName) {
        PsiAnnotationMemberValue attrValue;
        if (anno == null) {
            AnnotationUtil.$$$reportNull$$$0(41);
        }
        return (attrValue = anno.findAttributeValue(attributeName)) == null ? null : AnnotationUtil.getStringAttributeValue(attrValue);
    }

    @Nullable
    public static Boolean getBooleanAttributeValue(@NotNull PsiAnnotation anno, @Nullable String attributeName) {
        if (anno == null) {
            AnnotationUtil.$$$reportNull$$$0(42);
        }
        PsiAnnotationMemberValue attrValue = anno.findAttributeValue(attributeName);
        Object constValue = JavaPsiFacade.getInstance(anno.getProject()).getConstantEvaluationHelper().computeConstantExpression(attrValue);
        return constValue instanceof Boolean ? (Boolean)constValue : null;
    }

    @Nullable
    public static Long getLongAttributeValue(@NotNull PsiAnnotation anno, @Nullable String attributeName) {
        if (anno == null) {
            AnnotationUtil.$$$reportNull$$$0(43);
        }
        PsiAnnotationMemberValue attrValue = anno.findAttributeValue(attributeName);
        Object constValue = JavaPsiFacade.getInstance(anno.getProject()).getConstantEvaluationHelper().computeConstantExpression(attrValue);
        return constValue instanceof Number ? Long.valueOf(((Number)constValue).longValue()) : null;
    }

    @Nullable
    public static String getDeclaredStringAttributeValue(@NotNull PsiAnnotation anno, @Nullable String attributeName) {
        PsiAnnotationMemberValue attrValue;
        if (anno == null) {
            AnnotationUtil.$$$reportNull$$$0(44);
        }
        return (attrValue = anno.findDeclaredAttributeValue(attributeName)) == null ? null : AnnotationUtil.getStringAttributeValue(attrValue);
    }

    @Nullable
    public static String getStringAttributeValue(@NotNull PsiAnnotationMemberValue attrValue) {
        PsiConstantEvaluationHelper evaluationHelper;
        Object constValue;
        if (attrValue == null) {
            AnnotationUtil.$$$reportNull$$$0(45);
        }
        return (constValue = (evaluationHelper = JavaPsiFacade.getInstance(attrValue.getProject()).getConstantEvaluationHelper()).computeConstantExpression(attrValue)) instanceof String ? (String)constValue : null;
    }

    @Nullable
    public static <T extends Annotation> T findAnnotationInHierarchy(@NotNull PsiModifierListOwner listOwner, @NotNull Class<T> annotationClass) {
        PsiAnnotation annotation;
        if (listOwner == null) {
            AnnotationUtil.$$$reportNull$$$0(46);
        }
        if (annotationClass == null) {
            AnnotationUtil.$$$reportNull$$$0(47);
        }
        if ((annotation = AnnotationUtil.findAnnotationInHierarchy(listOwner, Collections.singleton(annotationClass.getName()))) == null) {
            return null;
        }
        AnnotationInvocationHandler handler = new AnnotationInvocationHandler(annotationClass, annotation);
        Annotation t = (Annotation)Proxy.newProxyInstance(annotationClass.getClassLoader(), new Class[]{annotationClass}, (InvocationHandler)handler);
        return (T)t;
    }

    @Nullable
    public static PsiNameValuePair findDeclaredAttribute(@NotNull PsiAnnotation annotation, @Nullable(value="null means 'value'") String attributeName) {
        if (annotation == null) {
            AnnotationUtil.$$$reportNull$$$0(48);
        }
        if ("value".equals(attributeName)) {
            attributeName = null;
        }
        for (PsiNameValuePair attribute : annotation.getParameterList().getAttributes()) {
            String name = attribute.getName();
            if (!Comparing.equal((String)name, (String)attributeName) && (attributeName != null || !"value".equals(name))) continue;
            return attribute;
        }
        return null;
    }

    public static boolean equal(@Nullable PsiAnnotation a, @Nullable PsiAnnotation b) {
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return false;
        }
        String name = a.getQualifiedName();
        if (name == null || !name.equals(b.getQualifiedName())) {
            return false;
        }
        THashMap valueMap1 = new THashMap(2);
        THashMap valueMap2 = new THashMap(2);
        if (!AnnotationUtil.fillValueMap(a.getParameterList(), (Map<String, PsiAnnotationMemberValue>)valueMap1) || !AnnotationUtil.fillValueMap(b.getParameterList(), (Map<String, PsiAnnotationMemberValue>)valueMap2) || valueMap1.size() != valueMap2.size()) {
            return false;
        }
        for (Map.Entry entry : valueMap1.entrySet()) {
            if (AnnotationUtil.equal((PsiAnnotationMemberValue)entry.getValue(), (PsiAnnotationMemberValue)valueMap2.get(entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    private static boolean fillValueMap(@NotNull PsiAnnotationParameterList parameterList, @NotNull Map<String, PsiAnnotationMemberValue> valueMap) {
        PsiNameValuePair[] attributes1;
        if (parameterList == null) {
            AnnotationUtil.$$$reportNull$$$0(49);
        }
        if (valueMap == null) {
            AnnotationUtil.$$$reportNull$$$0(50);
        }
        for (PsiNameValuePair attribute : attributes1 = parameterList.getAttributes()) {
            PsiReference reference = attribute.getReference();
            if (reference == null) {
                return false;
            }
            PsiElement target = reference.resolve();
            if (!(target instanceof PsiAnnotationMethod)) {
                return false;
            }
            PsiAnnotationMethod annotationMethod = (PsiAnnotationMethod)target;
            PsiAnnotationMemberValue defaultValue = annotationMethod.getDefaultValue();
            PsiAnnotationMemberValue value = attribute.getValue();
            if (AnnotationUtil.equal(value, defaultValue)) continue;
            String name1 = attribute.getName();
            valueMap.put(name1 == null ? "value" : name1, value);
        }
        return true;
    }

    public static boolean equal(@Nullable PsiAnnotationMemberValue value1, @Nullable PsiAnnotationMemberValue value2) {
        if (value1 instanceof PsiArrayInitializerMemberValue && value2 instanceof PsiArrayInitializerMemberValue) {
            PsiAnnotationMemberValue[] initializers2;
            PsiAnnotationMemberValue[] initializers1 = ((PsiArrayInitializerMemberValue)value1).getInitializers();
            if (initializers1.length != (initializers2 = ((PsiArrayInitializerMemberValue)value2).getInitializers()).length) {
                return false;
            }
            for (int i = 0; i < initializers1.length; ++i) {
                if (AnnotationUtil.equal(initializers1[i], initializers2[i])) continue;
                return false;
            }
            return true;
        }
        if (value1 != null && value2 != null) {
            PsiConstantEvaluationHelper constantEvaluationHelper = JavaPsiFacade.getInstance(value1.getProject()).getConstantEvaluationHelper();
            Object const1 = constantEvaluationHelper.computeConstantExpression(value1);
            Object const2 = constantEvaluationHelper.computeConstantExpression(value2);
            return const1 != null && const1.equals(const2);
        }
        return false;
    }

    public static boolean equal(@NotNull PsiAnnotation[] annotations1, @NotNull PsiAnnotation[] annotations2) {
        if (annotations1 == null) {
            AnnotationUtil.$$$reportNull$$$0(51);
        }
        if (annotations2 == null) {
            AnnotationUtil.$$$reportNull$$$0(52);
        }
        Map<String, PsiAnnotation> map1 = AnnotationUtil.buildAnnotationMap(annotations1);
        Map<String, PsiAnnotation> map2 = AnnotationUtil.buildAnnotationMap(annotations2);
        if (map1.size() != map2.size()) {
            return false;
        }
        for (Map.Entry<String, PsiAnnotation> entry : map1.entrySet()) {
            if (AnnotationUtil.equal(entry.getValue(), map2.get(entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private static Map<String, PsiAnnotation> buildAnnotationMap(@NotNull PsiAnnotation[] annotations) {
        if (annotations == null) {
            AnnotationUtil.$$$reportNull$$$0(53);
        }
        HashMap<String, PsiAnnotation> map = new HashMap<String, PsiAnnotation>();
        for (PsiAnnotation annotation : annotations) {
            map.put(annotation.getQualifiedName(), annotation);
        }
        map.remove("java.lang.Override");
        map.remove("java.lang.SuppressWarnings");
        HashMap<String, PsiAnnotation> hashMap = map;
        if (hashMap == null) {
            AnnotationUtil.$$$reportNull$$$0(54);
        }
        return hashMap;
    }

    @Deprecated
    public static boolean isJetbrainsAnnotation(@NotNull String simpleName) {
        if (simpleName == null) {
            AnnotationUtil.$$$reportNull$$$0(55);
        }
        return ArrayUtil.find((Object[])SIMPLE_NAMES, (Object)simpleName) != -1;
    }

    @Deprecated
    public static boolean isAnnotated(@NotNull PsiModifierListOwner listOwner, @NotNull Collection<String> annotations) {
        if (listOwner == null) {
            AnnotationUtil.$$$reportNull$$$0(56);
        }
        if (annotations == null) {
            AnnotationUtil.$$$reportNull$$$0(57);
        }
        return AnnotationUtil.isAnnotated(listOwner, annotations, 8);
    }

    @Deprecated
    public static boolean isAnnotated(@NotNull PsiModifierListOwner listOwner, @NotNull Collection<String> annotations, boolean checkHierarchy) {
        if (listOwner == null) {
            AnnotationUtil.$$$reportNull$$$0(58);
        }
        if (annotations == null) {
            AnnotationUtil.$$$reportNull$$$0(59);
        }
        return AnnotationUtil.isAnnotated(listOwner, annotations, AnnotationUtil.flags(checkHierarchy, true, true));
    }

    @Deprecated
    public static boolean isAnnotated(@NotNull PsiModifierListOwner listOwner, @NotNull Collection<String> annotations, boolean checkHierarchy, boolean skipExternal) {
        if (listOwner == null) {
            AnnotationUtil.$$$reportNull$$$0(60);
        }
        if (annotations == null) {
            AnnotationUtil.$$$reportNull$$$0(61);
        }
        return AnnotationUtil.isAnnotated(listOwner, annotations, AnnotationUtil.flags(checkHierarchy, skipExternal, skipExternal));
    }

    @Deprecated
    public static boolean isAnnotated(@NotNull PsiModifierListOwner listOwner, @NotNull String annotationFQN, boolean checkHierarchy) {
        if (listOwner == null) {
            AnnotationUtil.$$$reportNull$$$0(62);
        }
        if (annotationFQN == null) {
            AnnotationUtil.$$$reportNull$$$0(63);
        }
        return AnnotationUtil.isAnnotated(listOwner, annotationFQN, AnnotationUtil.flags(checkHierarchy, true, true));
    }

    @Deprecated
    public static boolean isAnnotated(@NotNull PsiModifierListOwner listOwner, @NotNull String annotationFQN, boolean checkHierarchy, boolean skipExternal) {
        if (listOwner == null) {
            AnnotationUtil.$$$reportNull$$$0(64);
        }
        if (annotationFQN == null) {
            AnnotationUtil.$$$reportNull$$$0(65);
        }
        return AnnotationUtil.isAnnotated(listOwner, annotationFQN, AnnotationUtil.flags(checkHierarchy, skipExternal, skipExternal));
    }

    @Flags
    private static int flags(boolean checkHierarchy, boolean skipExternal, boolean skipInferred) {
        int flags = 8;
        if (checkHierarchy) {
            flags |= 1;
        }
        if (!skipExternal) {
            flags |= 2;
        }
        if (!skipInferred) {
            flags |= 4;
        }
        return flags;
    }

    @NotNull
    public static List<PsiAnnotationMemberValue> arrayAttributeValues(@Nullable PsiAnnotationMemberValue attributeValue) {
        if (attributeValue instanceof PsiArrayInitializerMemberValue) {
            List<PsiAnnotationMemberValue> list = Arrays.asList(((PsiArrayInitializerMemberValue)attributeValue).getInitializers());
            if (list == null) {
                AnnotationUtil.$$$reportNull$$$0(66);
            }
            return list;
        }
        List list = ContainerUtil.createMaybeSingletonList((Object)attributeValue);
        if (list == null) {
            AnnotationUtil.$$$reportNull$$$0(67);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 35: 
            case 37: 
            case 54: 
            case 66: 
            case 67: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 35: 
            case 37: 
            case 54: 
            case 66: 
            case 67: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationNames";
                break;
            }
            case 5: 
            case 7: 
            case 15: 
            case 23: 
            case 25: 
            case 27: 
            case 46: 
            case 56: 
            case 58: 
            case 60: 
            case 62: 
            case 64: 
            case 68: 
            case 71: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listOwner";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 35: 
            case 37: 
            case 54: 
            case 66: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/AnnotationUtil";
                break;
            }
            case 13: 
            case 38: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 17: 
            case 19: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveHelper";
                break;
            }
            case 24: 
            case 32: 
            case 53: 
            case 57: 
            case 59: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotations";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationFqn";
                break;
            }
            case 28: 
            case 31: 
            case 63: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationFQN";
                break;
            }
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elt";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pair";
                break;
            }
            case 34: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 39: 
            case 40: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anno";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrValue";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationClass";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterList";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueMap";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotations1";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotations2";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "simpleName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/AnnotationUtil";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "findAnnotations";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperAnnotationOwners";
                break;
            }
            case 35: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllAnnotations";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "buildAnnotationMap";
                break;
            }
            case 66: 
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "arrayAttributeValues";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findAnnotation";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findOwnAnnotation";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findNonCodeAnnotation";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findAnnotations";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 35: 
            case 37: 
            case 54: 
            case 66: 
            case 67: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getSuperAnnotationOwners";
                break;
            }
            case 15: 
            case 16: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "findAnnotationInHierarchy";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "collectSuperParameters";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "collectSuperMethods";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "isAnnotated";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "isAnnotatingApplicable";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "checkAnnotatedUsingPatterns";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotationMethod";
                break;
            }
            case 34: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getAllAnnotations";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "isInsideAnnotation";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "isInferredAnnotation";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "isExternalAnnotation";
                break;
            }
            case 41: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getStringAttributeValue";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getBooleanAttributeValue";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getLongAttributeValue";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getDeclaredStringAttributeValue";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "findDeclaredAttribute";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "fillValueMap";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "equal";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "buildAnnotationMap";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "isJetbrainsAnnotation";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "lambda$isAnnotated$4";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "lambda$collectSuperParameters$3";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getSuperAnnotationOwners$2";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findNonCodeAnnotation$1";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 35: 
            case 37: 
            case 54: 
            case 66: 
            case 67: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @Target(value={ElementType.PARAMETER, ElementType.METHOD})
    private static @interface Flags {
    }
}

