/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.patterns.uast;

import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.uast.UCallExpressionPattern;
import com.intellij.patterns.uast.UElementPattern;
import com.intellij.patterns.uast.UExpressionPattern;
import com.intellij.patterns.uast.ULiteralExpressionPattern;
import com.intellij.patterns.uast.UastPatterns;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UCallExpressionEx;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UastBinaryOperator;
import org.jetbrains.uast.UastCallKind;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000R\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0006\u0010\u0000\u001a\u00020\u0001\u001a$\u0010\u0002\u001a\b\u0012\u0004\u0012\u0002H\u00040\u0003\"\b\b\u0000\u0010\u0004*\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00040\u0007\u001a$\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00040\t\"\b\b\u0000\u0010\u0004*\u00020\n2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00040\u0007\u001a&\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002\u001a \u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00052\u000e\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00160\u0011H\u0002\u001a\u0006\u0010\u0017\u001a\u00020\u0018\u001a\u0006\u0010\u0019\u001a\u00020\u0018\u001a\u0010\u0010\u001a\u001a\f\u0012\u0004\u0012\u00020\n\u0012\u0002\b\u00030\u001b\u00a8\u0006\u001c"}, d2={"callExpression", "Lcom/intellij/patterns/uast/UCallExpressionPattern;", "capture", "Lcom/intellij/patterns/uast/UElementPattern$Capture;", "T", "Lorg/jetbrains/uast/UElement;", "clazz", "Ljava/lang/Class;", "expressionCapture", "Lcom/intellij/patterns/uast/UExpressionPattern$Capture;", "Lorg/jetbrains/uast/UExpression;", "isCallExpressionParameter", "", "argumentExpression", "parameterIndex", "", "callPattern", "Lcom/intellij/patterns/ElementPattern;", "Lorg/jetbrains/uast/UCallExpression;", "isPropertyAssignCall", "argument", "methodPattern", "Lcom/intellij/psi/PsiMethod;", "literalExpression", "Lcom/intellij/patterns/uast/ULiteralExpressionPattern;", "stringLiteralExpression", "uExpression", "Lcom/intellij/patterns/uast/UExpressionPattern;", "intellij.platform.uast"})
@JvmName(name="UastPatterns")
public final class UastPatterns {
    @NotNull
    public static final ULiteralExpressionPattern literalExpression() {
        return new ULiteralExpressionPattern();
    }

    @NotNull
    public static final ULiteralExpressionPattern stringLiteralExpression() {
        return (ULiteralExpressionPattern)((Object)UastPatterns.literalExpression().filter(stringLiteralExpression.1.INSTANCE));
    }

    @NotNull
    public static final UCallExpressionPattern callExpression() {
        return new UCallExpressionPattern();
    }

    @NotNull
    public static final UExpressionPattern<UExpression, ?> uExpression() {
        return UastPatterns.expressionCapture(UExpression.class);
    }

    @NotNull
    public static final <T extends UElement> UElementPattern.Capture<T> capture(@NotNull Class<T> clazz) {
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        return new UElementPattern.Capture<T>(clazz);
    }

    @NotNull
    public static final <T extends UExpression> UExpressionPattern.Capture<T> expressionCapture(@NotNull Class<T> clazz) {
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        return new UExpressionPattern.Capture<T>(clazz);
    }

    private static final boolean isCallExpressionParameter(UElement argumentExpression, int parameterIndex, ElementPattern<UCallExpression> callPattern) {
        UastCallKind uastCallKind;
        UCallExpression uCallExpression = UastUtils.getUCallExpression(argumentExpression.getUastParent());
        if (!(uCallExpression instanceof UCallExpressionEx)) {
            uCallExpression = null;
        }
        UCallExpressionEx uCallExpressionEx = (UCallExpressionEx)uCallExpression;
        if (uCallExpressionEx == null) {
            return false;
        }
        UCallExpressionEx call = uCallExpressionEx;
        UastCallKind it = uastCallKind = call.getKind();
        if (Intrinsics.areEqual((Object)it, (Object)UastCallKind.CONSTRUCTOR_CALL) ^ true && Intrinsics.areEqual((Object)it, (Object)UastCallKind.METHOD_CALL) ^ true) {
            return false;
        }
        return Intrinsics.areEqual((Object)call.getArgumentForParameter(parameterIndex), (Object)argumentExpression) && callPattern.accepts((Object)call);
    }

    private static final boolean isPropertyAssignCall(UElement argument, ElementPattern<? extends PsiMethod> methodPattern) {
        boolean bl;
        block9: {
            PsiReference[] references;
            PsiReference[] $receiver$iv;
            UExpression uExpression;
            UElement uElement = argument.getUastParent();
            if (!(uElement instanceof UBinaryExpression)) {
                uElement = null;
            }
            UBinaryExpression uBinaryExpression = (UBinaryExpression)uElement;
            if (uBinaryExpression == null) {
                return false;
            }
            UBinaryExpression uBinaryExpression2 = uBinaryExpression;
            if (Intrinsics.areEqual((Object)uBinaryExpression2.getOperator(), (Object)UastBinaryOperator.ASSIGN) ^ true) {
                return false;
            }
            UExpression leftOperand = uBinaryExpression2.getLeftOperand();
            UExpression uExpression2 = leftOperand;
            if (uExpression2 instanceof UQualifiedReferenceExpression) {
                uExpression = ((UQualifiedReferenceExpression)leftOperand).getSelector();
            } else if (uExpression2 instanceof UReferenceExpression) {
                uExpression = leftOperand;
            } else {
                return false;
            }
            UExpression uastReference = uExpression;
            PsiReference[] psiReferenceArray = uastReference.getSourcePsi();
            if (psiReferenceArray == null || (psiReferenceArray = psiReferenceArray.getReferences()) == null) {
                return false;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)psiReferenceArray, (String)"uastReference.sourcePsi?\u2026eferences ?: return false");
            for (PsiReference element$iv : $receiver$iv = (references = psiReferenceArray)) {
                PsiReference it = element$iv;
                if (!methodPattern.accepts((Object)it.resolve())) continue;
                bl = true;
                break block9;
            }
            bl = false;
        }
        return bl;
    }

    public static final /* synthetic */ boolean access$isCallExpressionParameter(@NotNull UElement argumentExpression, int parameterIndex, @NotNull ElementPattern callPattern) {
        return UastPatterns.isCallExpressionParameter(argumentExpression, parameterIndex, (ElementPattern<UCallExpression>)callPattern);
    }

    public static final /* synthetic */ boolean access$isPropertyAssignCall(@NotNull UElement argument, @NotNull ElementPattern methodPattern) {
        return UastPatterns.isPropertyAssignCall(argument, (ElementPattern<? extends PsiMethod>)methodPattern);
    }
}

