/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.fxml;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeConsumer;
import com.intellij.openapi.fileTypes.FileTypeFactory;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JavaFxFileTypeFactory
extends FileTypeFactory {
    @NonNls
    public static final String FXML_EXTENSION = "fxml";
    @NonNls
    static final String DOT_FXML_EXTENSION = ".fxml";

    public static boolean isFxml(@NotNull PsiFile file) {
        if (file == null) {
            JavaFxFileTypeFactory.$$$reportNull$$$0(0);
        }
        VirtualFile virtualFile = file.getViewProvider().getVirtualFile();
        return JavaFxFileTypeFactory.isFxml(virtualFile);
    }

    public static boolean isFxml(@NotNull VirtualFile virtualFile) {
        FileType fileType;
        if (virtualFile == null) {
            JavaFxFileTypeFactory.$$$reportNull$$$0(1);
        }
        if (FXML_EXTENSION.equals(virtualFile.getExtension()) && (fileType = virtualFile.getFileType()) == JavaFxFileTypeFactory.getFileType() && !fileType.isBinary()) {
            return virtualFile.getName().endsWith(DOT_FXML_EXTENSION);
        }
        return false;
    }

    @NotNull
    public static FileType getFileType() {
        FileType fileType = FileTypeManager.getInstance().getFileTypeByExtension(FXML_EXTENSION);
        if (fileType == null) {
            JavaFxFileTypeFactory.$$$reportNull$$$0(2);
        }
        return fileType;
    }

    public void createFileTypes(@NotNull FileTypeConsumer consumer) {
        if (consumer == null) {
            JavaFxFileTypeFactory.$$$reportNull$$$0(3);
        }
        FileType fileType = consumer.getStandardFileTypeByName("XML");
        assert (fileType != null);
        consumer.consume(fileType, FXML_EXTENSION);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/javaFX/fxml/JavaFxFileTypeFactory";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/javaFX/fxml/JavaFxFileTypeFactory";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isFxml";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createFileTypes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

