/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.actions;

import com.intellij.ide.IdeView;
import com.intellij.ide.actions.CreateElementActionBase;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiNameHelper;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.util.IncorrectOperationException;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

public abstract class AbstractCreateFormAction
extends CreateElementActionBase
implements DumbAware {
    public AbstractCreateFormAction(String text, String description, Icon icon) {
        super(text, description, icon);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            AbstractCreateFormAction.$$$reportNull$$$0(0);
        }
        super.update(e);
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        Presentation presentation = e.getPresentation();
        if (presentation.isEnabled()) {
            IdeView view = (IdeView)e.getData(LangDataKeys.IDE_VIEW);
            if (view != null) {
                PsiDirectory[] dirs;
                ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
                for (PsiDirectory dir : dirs = view.getDirectories()) {
                    if (!projectFileIndex.isUnderSourceRootOfType(dir.getVirtualFile(), JavaModuleSourceRootTypes.SOURCES) || JavaDirectoryService.getInstance().getPackage(dir) == null) continue;
                    return;
                }
            }
            presentation.setEnabled(false);
            presentation.setVisible(false);
        }
    }

    protected String createFormBody(@Nullable String fqn, @NonNls String formName, String layoutManager) throws IncorrectOperationException {
        String s;
        try {
            s = FileUtil.loadTextAndClose((InputStream)((Object)((Object)this)).getClass().getResourceAsStream(formName));
        }
        catch (IOException e) {
            throw new IncorrectOperationException(UIDesignerBundle.message("error.cannot.read", formName), (Throwable)e);
        }
        s = fqn != null ? StringUtil.replace((String)s, (String)"$CLASS$", (String)fqn) : StringUtil.replace((String)s, (String)"bind-to-class=\"$CLASS$\"", (String)"");
        s = StringUtil.replace((String)s, (String)"$LAYOUT$", (String)layoutManager);
        return StringUtil.convertLineSeparators((String)s);
    }

    protected String getActionName(PsiDirectory directory, String newName) {
        return UIDesignerBundle.message("progress.creating.class", JavaDirectoryService.getInstance().getPackage(directory).getQualifiedName(), newName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/uiDesigner/actions/AbstractCreateFormAction", "update"));
    }

    protected class JavaNameValidator
    extends CreateElementActionBase.MyInputValidator {
        private final Project myProject;

        public JavaNameValidator(Project project, PsiDirectory directory) {
            super((CreateElementActionBase)AbstractCreateFormAction.this, project, directory);
            this.myProject = project;
        }

        public boolean checkInput(String inputString) {
            return inputString.length() > 0 && PsiNameHelper.getInstance((Project)this.myProject).isQualifiedName(inputString);
        }
    }
}

