/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.designSurface;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.uiDesigner.FormEditingUtil;
import com.intellij.uiDesigner.designSurface.ComponentDragObject;
import com.intellij.uiDesigner.designSurface.ComponentDropLocation;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import com.intellij.uiDesigner.designSurface.NoDropLocation;
import com.intellij.uiDesigner.radComponents.RadComponent;
import com.intellij.uiDesigner.radComponents.RadContainer;
import com.intellij.uiDesigner.radComponents.RadRootContainer;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class GridInsertProcessor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.uiDesigner.designSurface.GridInsertProcessor");
    private final GuiEditor myEditor;

    public GridInsertProcessor(GuiEditor editor) {
        this.myEditor = editor;
    }

    @NotNull
    public static ComponentDropLocation getDropLocation(RadRootContainer rootContainer, Point aPoint) {
        RadContainer container = GridInsertProcessor.getDropTargetContainer(rootContainer, aPoint);
        if (container == null) {
            NoDropLocation noDropLocation = NoDropLocation.INSTANCE;
            if (noDropLocation == null) {
                GridInsertProcessor.$$$reportNull$$$0(0);
            }
            return noDropLocation;
        }
        Point targetPoint = SwingUtilities.convertPoint(rootContainer.getDelegee(), aPoint, container.getDelegee());
        ComponentDropLocation componentDropLocation = container.getDropLocation(targetPoint);
        if (componentDropLocation == null) {
            GridInsertProcessor.$$$reportNull$$$0(1);
        }
        return componentDropLocation;
    }

    public static RadContainer getDropTargetContainer(RadRootContainer rootContainer, Point aPoint) {
        RadComponent singleComponent;
        int EPSILON = 4;
        RadContainer container = FormEditingUtil.getRadContainerAt(rootContainer, aPoint.x, aPoint.y, EPSILON);
        if (container instanceof RadRootContainer && rootContainer.getComponentCount() == 1 && (singleComponent = rootContainer.getComponents()[0]) instanceof RadContainer) {
            Rectangle rc = singleComponent.getDelegee().getBounds();
            rc.grow(EPSILON * 2, EPSILON * 2);
            if (rc.contains(aPoint)) {
                container = (RadContainer)singleComponent;
                EPSILON *= 2;
            }
        }
        return container;
    }

    public ComponentDropLocation processDragEvent(Point pnt, ComponentDragObject dragObject) {
        ComponentDropLocation dropLocation = GridInsertProcessor.getDropLocation(this.myEditor.getRootContainer(), pnt);
        LOG.info("GridInsertProcessor.processDragEvent(): dropLocation " + dropLocation.toString());
        if (dropLocation.canDrop(dragObject)) {
            dropLocation.placeFeedback(this.myEditor.getActiveDecorationLayer(), dragObject);
        } else {
            this.myEditor.getActiveDecorationLayer().removeFeedback();
        }
        return dropLocation;
    }

    public Cursor processMouseMoveEvent(Point pnt, boolean copyOnDrop, ComponentDragObject dragObject) {
        ComponentDropLocation location = this.processDragEvent(pnt, dragObject);
        if (!location.canDrop(dragObject)) {
            return FormEditingUtil.getMoveNoDropCursor();
        }
        return copyOnDrop ? FormEditingUtil.getCopyDropCursor() : FormEditingUtil.getMoveDropCursor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/designSurface/GridInsertProcessor", "getDropLocation"));
    }
}

