/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.inspections;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.core.SupportCode;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import com.intellij.uiDesigner.inspections.AssignMnemonicFix;
import com.intellij.uiDesigner.inspections.BaseFormInspection;
import com.intellij.uiDesigner.inspections.EditorQuickFixProvider;
import com.intellij.uiDesigner.inspections.FormErrorCollector;
import com.intellij.uiDesigner.inspections.FormInspectionUtil;
import com.intellij.uiDesigner.lw.IComponent;
import com.intellij.uiDesigner.lw.IProperty;
import com.intellij.uiDesigner.quickFixes.QuickFix;
import com.intellij.uiDesigner.radComponents.RadComponent;
import javax.swing.AbstractButton;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;

public class MissingMnemonicInspection
extends BaseFormInspection {
    public MissingMnemonicInspection() {
        super("MissingMnemonic");
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = UIDesignerBundle.message("inspection.missing.mnemonics", new Object[0]);
        if (string == null) {
            MissingMnemonicInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected void checkComponentProperties(Module module, @NotNull IComponent component, FormErrorCollector collector) {
        String value;
        if (component == null) {
            MissingMnemonicInspection.$$$reportNull$$$0(1);
        }
        if ((value = FormInspectionUtil.getText(module, component)) == null) {
            return;
        }
        IProperty textProperty = FormInspectionUtil.findProperty(component, "text");
        SupportCode.TextWithMnemonic twm = SupportCode.parseText((String)value);
        if (twm.myMnemonicIndex < 0 && !twm.myText.isEmpty()) {
            IProperty labelForProperty;
            if (FormInspectionUtil.isComponentClass(module, component, AbstractButton.class)) {
                collector.addError(this.getID(), component, textProperty, UIDesignerBundle.message("inspection.missing.mnemonics.message", value), new MyEditorQuickFixProvider());
            } else if (FormInspectionUtil.isComponentClass(module, component, JLabel.class) && (labelForProperty = FormInspectionUtil.findProperty(component, "labelFor")) != null && !StringUtil.isEmpty((String)((String)labelForProperty.getPropertyValue(component)))) {
                collector.addError(this.getID(), component, textProperty, UIDesignerBundle.message("inspection.missing.mnemonics.message", value), new MyEditorQuickFixProvider());
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uiDesigner/inspections/MissingMnemonicInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uiDesigner/inspections/MissingMnemonicInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "checkComponentProperties";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyEditorQuickFixProvider
    implements EditorQuickFixProvider {
        private MyEditorQuickFixProvider() {
        }

        @Override
        @NotNull
        public QuickFix createQuickFix(GuiEditor editor, @NotNull RadComponent component) {
            if (component == null) {
                MyEditorQuickFixProvider.$$$reportNull$$$0(0);
            }
            AssignMnemonicFix assignMnemonicFix = new AssignMnemonicFix(editor, component, UIDesignerBundle.message("inspections.missing.mnemonic.quickfix", new Object[0]));
            if (assignMnemonicFix == null) {
                MyEditorQuickFixProvider.$$$reportNull$$$0(1);
            }
            return assignMnemonicFix;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/uiDesigner/inspections/MissingMnemonicInspection$MyEditorQuickFixProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/uiDesigner/inspections/MissingMnemonicInspection$MyEditorQuickFixProvider";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createQuickFix";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

