/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.core.internal.analysis;

import java.util.HashSet;
import java.util.Set;
import org.jacoco.asm.AnnotationVisitor;
import org.jacoco.asm.FieldVisitor;
import org.jacoco.core.analysis.IMethodCoverage;
import org.jacoco.core.internal.analysis.ClassCoverageImpl;
import org.jacoco.core.internal.analysis.MethodAnalyzer;
import org.jacoco.core.internal.analysis.StringPool;
import org.jacoco.core.internal.analysis.filter.Filters;
import org.jacoco.core.internal.analysis.filter.IFilterContext;
import org.jacoco.core.internal.flow.ClassProbesVisitor;
import org.jacoco.core.internal.flow.MethodProbesVisitor;
import org.jacoco.core.internal.instr.InstrSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassAnalyzer
extends ClassProbesVisitor
implements IFilterContext {
    private final ClassCoverageImpl coverage;
    private final boolean[] probes;
    private final StringPool stringPool;
    private final Set<String> classAnnotations = new HashSet<String>();

    public ClassAnalyzer(ClassCoverageImpl coverage, boolean[] probes, StringPool stringPool) {
        this.coverage = coverage;
        this.probes = probes;
        this.stringPool = stringPool;
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.coverage.setSignature(this.stringPool.get(signature));
        this.coverage.setSuperName(this.stringPool.get(superName));
        this.coverage.setInterfaces(this.stringPool.get(interfaces));
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        this.classAnnotations.add(desc);
        return super.visitAnnotation(desc, visible);
    }

    @Override
    public void visitSource(String source, String debug) {
        this.coverage.setSourceFileName(this.stringPool.get(source));
    }

    @Override
    public MethodProbesVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        InstrSupport.assertNotInstrumented(name, this.coverage.getName());
        return new MethodAnalyzer(this.stringPool.get(name), this.stringPool.get(desc), this.stringPool.get(signature), this.probes, Filters.ALL, this){

            public void visitEnd() {
                super.visitEnd();
                IMethodCoverage methodCoverage = this.getCoverage();
                if (methodCoverage.getInstructionCounter().getTotalCount() > 0) {
                    ClassAnalyzer.this.coverage.addMethod(methodCoverage);
                }
            }
        };
    }

    @Override
    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        InstrSupport.assertNotInstrumented(name, this.coverage.getName());
        return super.visitField(access, name, desc, signature, value);
    }

    @Override
    public void visitTotalProbeCount(int count) {
    }

    @Override
    public String getClassName() {
        return this.coverage.getName();
    }

    @Override
    public String getSuperClassName() {
        return this.coverage.getSuperName();
    }

    @Override
    public Set<String> getClassAnnotations() {
        return this.classAnnotations;
    }

    @Override
    public String getSourceFileName() {
        return this.coverage.getSourceFileName();
    }
}

