/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.options;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ChooseModulesDialog;
import com.intellij.util.ui.ItemRemovable;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.table.AbstractTableModel;
import org.jetbrains.annotations.NotNull;

public class ModuleOptionsTableModel
extends AbstractTableModel
implements ItemRemovable {
    private final List<Item> myItems = new ArrayList<Item>();

    @NotNull
    public Map<String, String> getModuleOptions() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Item item : this.myItems) {
            map.put(item.module.getName(), item.option);
        }
        HashMap<String, String> hashMap = map;
        if (hashMap == null) {
            ModuleOptionsTableModel.$$$reportNull$$$0(0);
        }
        return hashMap;
    }

    public void setModuleOptions(@NotNull Project project2, @NotNull Map<String, String> moduleOptions) {
        if (project2 == null) {
            ModuleOptionsTableModel.$$$reportNull$$$0(1);
        }
        if (moduleOptions == null) {
            ModuleOptionsTableModel.$$$reportNull$$$0(2);
        }
        this.myItems.clear();
        if (!moduleOptions.isEmpty()) {
            for (Module module2 : ModuleManager.getInstance((Project)project2).getModules()) {
                String options = moduleOptions.get(module2.getName());
                if (options == null) continue;
                this.myItems.add(new Item(module2, options));
            }
            this.sortItems();
        }
        this.fireTableDataChanged();
    }

    public int addModulesToModel(@NotNull Project project2, @NotNull Component parent) {
        if (project2 == null) {
            ModuleOptionsTableModel.$$$reportNull$$$0(3);
        }
        if (parent == null) {
            ModuleOptionsTableModel.$$$reportNull$$$0(4);
        }
        HashSet<Module> existing = new HashSet<Module>();
        for (Item item : this.myItems) {
            existing.add(item.module);
        }
        ArrayList<Module> candidates = new ArrayList<Module>();
        for (Module module2 : ModuleManager.getInstance((Project)project2).getModules()) {
            if (existing.contains(module2)) continue;
            candidates.add(module2);
        }
        if (!candidates.isEmpty()) {
            Collections.sort(candidates, Comparator.comparing(Module::getName));
            ChooseModulesDialog chooseModulesDialog = new ChooseModulesDialog(parent, candidates, "Choose module");
            chooseModulesDialog.show();
            List chosen = chooseModulesDialog.getChosenElements();
            if (!chosen.isEmpty()) {
                for (Module module2 : chosen) {
                    this.myItems.add(new Item(module2));
                }
                this.sortItems();
                this.fireTableDataChanged();
                for (int i = 0; i < this.myItems.size(); ++i) {
                    if (!this.myItems.get(i).module.equals(chosen.get(0))) continue;
                    return i;
                }
            }
        }
        return -1;
    }

    private void sortItems() {
        Collections.sort(this.myItems, Comparator.comparing(o -> ((Item)o).module.getName()));
    }

    @Override
    public int getRowCount() {
        return this.myItems.size();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex != 0;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Item item = this.myItems.get(rowIndex);
        return columnIndex == 0 ? item.module : item.option;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        Item item = this.myItems.get(rowIndex);
        item.option = ((String)aValue).trim();
        this.fireTableCellUpdated(rowIndex, columnIndex);
    }

    public void removeRow(int idx) {
        this.myItems.remove(idx);
        this.fireTableRowsDeleted(idx, idx);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/compiler/options/ModuleOptionsTableModel";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleOptions";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleOptions";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/compiler/options/ModuleOptionsTableModel";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setModuleOptions";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addModulesToModel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Item {
        private final Module module;
        private String option;

        Item(Module module2) {
            this(module2, "");
        }

        private Item(Module module2, String option) {
            this.module = module2;
            this.option = option;
        }
    }
}

