/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.settings.JavaDebuggerSettings;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.TabbedConfigurable;
import com.intellij.openapi.options.ex.SingleConfigurableEditor;
import com.intellij.openapi.project.Project;
import com.intellij.util.ui.JBUI;
import com.intellij.xdebugger.impl.ui.tree.actions.XDebuggerTreeActionBase;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class CustomizeContextViewAction
extends XDebuggerTreeActionBase {
    private static int ourLastSelectedTabIndex = 0;

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            CustomizeContextViewAction.$$$reportNull$$$0(0);
        }
        this.perform(null, "", e);
    }

    protected void perform(XValueNodeImpl node, @NotNull String nodeName, AnActionEvent e) {
        if (nodeName == null) {
            CustomizeContextViewAction.$$$reportNull$$$0(1);
        }
        Project project2 = e.getProject();
        final MyTabbedConfigurable configurable = new MyTabbedConfigurable();
        SingleConfigurableEditor editor = new SingleConfigurableEditor(project2, (Configurable)configurable){

            protected void doOKAction() {
                ourLastSelectedTabIndex = configurable.getSelectedIndex();
                super.doOKAction();
            }

            public void doCancelAction() {
                ourLastSelectedTabIndex = configurable.getSelectedIndex();
                super.doCancelAction();
            }
        };
        editor.show();
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            CustomizeContextViewAction.$$$reportNull$$$0(2);
        }
        e.getPresentation().setText(ActionsBundle.actionText((String)"Debugger.CustomizeContextView"));
        e.getPresentation().setEnabledAndVisible(DebuggerUtilsEx.isInJavaSession(e));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeName";
                break;
            }
        }
        objectArray2[1] = "com/intellij/debugger/actions/CustomizeContextViewAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "perform";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyTabbedConfigurable
    extends TabbedConfigurable {
        private MyTabbedConfigurable() {
        }

        @NotNull
        protected List<Configurable> createConfigurables() {
            List<Configurable> list = JavaDebuggerSettings.createDataViewsConfigurable();
            if (list == null) {
                MyTabbedConfigurable.$$$reportNull$$$0(0);
            }
            return list;
        }

        public void apply() throws ConfigurationException {
            super.apply();
            NodeRendererSettings.getInstance().fireRenderersChanged();
        }

        public String getDisplayName() {
            return DebuggerBundle.message((String)"title.customize.data.views", (Object[])new Object[0]);
        }

        public String getHelpTopic() {
            return "reference.debug.customize.data.view";
        }

        protected void createConfigurableTabs() {
            for (Configurable configurable : this.getConfigurables()) {
                JComponent component = configurable.createComponent();
                assert (component != null);
                component.setBorder((Border)JBUI.Borders.empty((int)8, (int)8));
                this.myTabbedPane.addTab(configurable.getDisplayName(), component);
            }
            this.myTabbedPane.setSelectedIndex(ourLastSelectedTabIndex);
        }

        int getSelectedIndex() {
            return this.myTabbedPane.getSelectedIndex();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/actions/CustomizeContextViewAction$MyTabbedConfigurable", "createConfigurables"));
        }
    }
}

