/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.ui;

import com.intellij.debugger.memory.ui.JavaReferenceInfo;
import com.intellij.xdebugger.memory.ui.ReferenceInfo;
import com.intellij.xdebugger.memory.ui.TypeInfo;
import com.sun.jdi.ReferenceType;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class JavaTypeInfo
implements TypeInfo {
    private final ReferenceType referenceType;

    public static List<TypeInfo> wrap(List<? extends ReferenceType> types) {
        return types.stream().map(JavaTypeInfo::new).collect(Collectors.toList());
    }

    public JavaTypeInfo(@NotNull ReferenceType referenceType) {
        if (referenceType == null) {
            JavaTypeInfo.$$$reportNull$$$0(0);
        }
        this.referenceType = referenceType;
    }

    @NotNull
    public String name() {
        String string = this.getReferenceType().name();
        if (string == null) {
            JavaTypeInfo.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public List<ReferenceInfo> getInstances(int limit) {
        List<ReferenceInfo> list = this.getReferenceType().instances(limit).stream().map(JavaReferenceInfo::new).collect(Collectors.toList());
        if (list == null) {
            JavaTypeInfo.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    public ReferenceType getReferenceType() {
        ReferenceType referenceType = this.referenceType;
        if (referenceType == null) {
            JavaTypeInfo.$$$reportNull$$$0(3);
        }
        return referenceType;
    }

    public boolean canGetInstanceInfo() {
        return this.referenceType.virtualMachine().canGetInstanceInfo();
    }

    public int hashCode() {
        return this.referenceType.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JavaTypeInfo)) {
            return false;
        }
        return ((JavaTypeInfo)obj).referenceType.equals(this.referenceType);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceType";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/memory/ui/JavaTypeInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/memory/ui/JavaTypeInfo";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "name";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstances";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

