/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.InstanceFilter;
import com.intellij.debugger.engine.JavaDebugProcess;
import com.intellij.debugger.engine.JavaStackFrame;
import com.intellij.debugger.ui.impl.watch.StackFrameDescriptorImpl;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.classFilter.ClassFilter;
import com.intellij.util.ArrayUtil;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointBase;
import com.sun.jdi.ObjectReference;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.breakpoints.properties.JavaBreakpointProperties;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\b \u0018\u0000 \u000e2\u00020\u0001:\u0006\t\n\u000b\f\r\u000eB\u0019\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0018\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000f"}, d2={"Lcom/intellij/debugger/ui/breakpoints/BreakpointIntentionAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "myBreakpoint", "Lcom/intellij/xdebugger/breakpoints/XBreakpoint;", "text", "", "(Lcom/intellij/xdebugger/breakpoints/XBreakpoint;Ljava/lang/String;)V", "getMyBreakpoint", "()Lcom/intellij/xdebugger/breakpoints/XBreakpoint;", "AddCallerFilter", "AddCallerNotFilter", "AddClassFilter", "AddClassNotFilter", "AddInstanceFilter", "Companion", "intellij.java.debugger.impl"})
public abstract class BreakpointIntentionAction
extends AnAction {
    @NotNull
    private final XBreakpoint<?> myBreakpoint;
    @JvmField
    @NotNull
    public static final Key<String> CALLER_KEY;
    @JvmField
    @NotNull
    public static final Key<String> THIS_TYPE_KEY;
    public static final Companion Companion;

    @NotNull
    protected final XBreakpoint<?> getMyBreakpoint() {
        return this.myBreakpoint;
    }

    public BreakpointIntentionAction(@NotNull XBreakpoint<?> myBreakpoint, @NotNull String text) {
        Intrinsics.checkParameterIsNotNull(myBreakpoint, (String)"myBreakpoint");
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        super(text);
        this.myBreakpoint = myBreakpoint;
    }

    static {
        Companion = new Companion(null);
        Key key = Key.create((String)"CALLER_KEY");
        Intrinsics.checkExpressionValueIsNotNull((Object)key, (String)"Key.create<String>(\"CALLER_KEY\")");
        CALLER_KEY = key;
        Key key2 = Key.create((String)"THIS_TYPE_KEY");
        Intrinsics.checkExpressionValueIsNotNull((Object)key2, (String)"Key.create<String>(\"THIS_TYPE_KEY\")");
        THIS_TYPE_KEY = key2;
    }

    @JvmStatic
    @NotNull
    public static final List<AnAction> getIntentions(@NotNull XBreakpoint<?> breakpoint, @Nullable XDebugSession currentSession) {
        return Companion.getIntentions(breakpoint, currentSession);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/debugger/ui/breakpoints/BreakpointIntentionAction$AddCallerNotFilter;", "Lcom/intellij/debugger/ui/breakpoints/BreakpointIntentionAction;", "breakpoint", "Lcom/intellij/xdebugger/breakpoints/XBreakpoint;", "myCaller", "", "(Lcom/intellij/xdebugger/breakpoints/XBreakpoint;Ljava/lang/String;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "intellij.java.debugger.impl"})
    public static final class AddCallerNotFilter
    extends BreakpointIntentionAction {
        private final String myCaller;

        /*
         * Unable to fully structure code
         */
        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            v0 = this.getMyBreakpoint().getProperties();
            if (v0 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.java.debugger.breakpoints.properties.JavaBreakpointProperties<*>");
            }
            $receiver = var2_2 = (JavaBreakpointProperties)v0;
            v1 = e.getPresentation();
            if (!$receiver.isCALLER_FILTERS_ENABLED()) ** GOTO lbl-1000
            v2 = $receiver.getCallerExclusionFilters();
            Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"callerExclusionFilters");
            if (!ArraysKt.contains((Object[])v2, (Object)new ClassFilter(this.myCaller))) lbl-1000:
            // 2 sources

            {
                v3 = true;
            } else {
                v3 = false;
            }
            v1.setEnabled(v3);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            JavaBreakpointProperties javaBreakpointProperties;
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            XBreakpointProperties xBreakpointProperties = this.getMyBreakpoint().getProperties();
            if (xBreakpointProperties == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.java.debugger.breakpoints.properties.JavaBreakpointProperties<*>");
            }
            JavaBreakpointProperties $receiver = javaBreakpointProperties = (JavaBreakpointProperties)xBreakpointProperties;
            $receiver.setCALLER_FILTERS_ENABLED(true);
            ClassFilter callerFilter = new ClassFilter(this.myCaller);
            $receiver.setCallerFilters((ClassFilter[])ArrayUtil.remove((Object[])$receiver.getCallerFilters(), (Object)callerFilter));
            Object[] objectArray = $receiver.getCallerExclusionFilters();
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"callerExclusionFilters");
            $receiver.setCallerExclusionFilters((ClassFilter[])Companion.appendIfNeeded(objectArray, callerFilter));
            XBreakpoint<?> xBreakpoint = this.getMyBreakpoint();
            if (xBreakpoint == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.xdebugger.impl.breakpoints.XBreakpointBase<*, *, *>");
            }
            ((XBreakpointBase)xBreakpoint).fireBreakpointChanged();
        }

        public AddCallerNotFilter(@NotNull XBreakpoint<?> breakpoint, @NotNull String myCaller) {
            Intrinsics.checkParameterIsNotNull(breakpoint, (String)"breakpoint");
            Intrinsics.checkParameterIsNotNull((Object)myCaller, (String)"myCaller");
            StringBuilder stringBuilder = new StringBuilder().append("Do not stop if called from: ");
            String string = StringUtil.substringBefore((String)myCaller, (String)"(");
            if (string == null) {
                string = myCaller;
            }
            super(breakpoint, stringBuilder.append(StringUtil.getShortName((String)string)).toString());
            this.myCaller = myCaller;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/debugger/ui/breakpoints/BreakpointIntentionAction$AddCallerFilter;", "Lcom/intellij/debugger/ui/breakpoints/BreakpointIntentionAction;", "breakpoint", "Lcom/intellij/xdebugger/breakpoints/XBreakpoint;", "myCaller", "", "(Lcom/intellij/xdebugger/breakpoints/XBreakpoint;Ljava/lang/String;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "intellij.java.debugger.impl"})
    public static final class AddCallerFilter
    extends BreakpointIntentionAction {
        private final String myCaller;

        /*
         * Unable to fully structure code
         */
        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            v0 = this.getMyBreakpoint().getProperties();
            if (v0 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.java.debugger.breakpoints.properties.JavaBreakpointProperties<*>");
            }
            $receiver = var2_2 = (JavaBreakpointProperties)v0;
            v1 = e.getPresentation();
            if (!$receiver.isCALLER_FILTERS_ENABLED()) ** GOTO lbl-1000
            v2 = $receiver.getCallerFilters();
            Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"callerFilters");
            if (!ArraysKt.contains((Object[])v2, (Object)new ClassFilter(this.myCaller))) lbl-1000:
            // 2 sources

            {
                v3 = true;
            } else {
                v3 = false;
            }
            v1.setEnabled(v3);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            JavaBreakpointProperties javaBreakpointProperties;
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            XBreakpointProperties xBreakpointProperties = this.getMyBreakpoint().getProperties();
            if (xBreakpointProperties == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.java.debugger.breakpoints.properties.JavaBreakpointProperties<*>");
            }
            JavaBreakpointProperties $receiver = javaBreakpointProperties = (JavaBreakpointProperties)xBreakpointProperties;
            $receiver.setCALLER_FILTERS_ENABLED(true);
            ClassFilter callerFilter = new ClassFilter(this.myCaller);
            Object[] objectArray = $receiver.getCallerFilters();
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"callerFilters");
            $receiver.setCallerFilters((ClassFilter[])Companion.appendIfNeeded(objectArray, callerFilter));
            $receiver.setCallerExclusionFilters((ClassFilter[])ArrayUtil.remove((Object[])$receiver.getCallerExclusionFilters(), (Object)callerFilter));
            XBreakpoint<?> xBreakpoint = this.getMyBreakpoint();
            if (xBreakpoint == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.xdebugger.impl.breakpoints.XBreakpointBase<*, *, *>");
            }
            ((XBreakpointBase)xBreakpoint).fireBreakpointChanged();
        }

        public AddCallerFilter(@NotNull XBreakpoint<?> breakpoint, @NotNull String myCaller) {
            Intrinsics.checkParameterIsNotNull(breakpoint, (String)"breakpoint");
            Intrinsics.checkParameterIsNotNull((Object)myCaller, (String)"myCaller");
            StringBuilder stringBuilder = new StringBuilder().append("Stop only if called from: ");
            String string = StringUtil.substringBefore((String)myCaller, (String)"(");
            if (string == null) {
                string = myCaller;
            }
            super(breakpoint, stringBuilder.append(StringUtil.getShortName((String)string)).toString());
            this.myCaller = myCaller;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/debugger/ui/breakpoints/BreakpointIntentionAction$AddInstanceFilter;", "Lcom/intellij/debugger/ui/breakpoints/BreakpointIntentionAction;", "breakpoint", "Lcom/intellij/xdebugger/breakpoints/XBreakpoint;", "myInstance", "", "(Lcom/intellij/xdebugger/breakpoints/XBreakpoint;J)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "intellij.java.debugger.impl"})
    public static final class AddInstanceFilter
    extends BreakpointIntentionAction {
        private final long myInstance;

        /*
         * Unable to fully structure code
         */
        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            v0 = this.getMyBreakpoint().getProperties();
            if (v0 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.java.debugger.breakpoints.properties.JavaBreakpointProperties<*>");
            }
            $receiver = var2_2 = (JavaBreakpointProperties)v0;
            v1 = e.getPresentation();
            if (!$receiver.isINSTANCE_FILTERS_ENABLED()) ** GOTO lbl-1000
            v2 = $receiver.getInstanceFilters();
            Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"instanceFilters");
            if (!ArraysKt.contains((Object[])v2, (Object)InstanceFilter.create(this.myInstance))) lbl-1000:
            // 2 sources

            {
                v3 = true;
            } else {
                v3 = false;
            }
            v1.setEnabled(v3);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            JavaBreakpointProperties javaBreakpointProperties;
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            XBreakpointProperties xBreakpointProperties = this.getMyBreakpoint().getProperties();
            if (xBreakpointProperties == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.java.debugger.breakpoints.properties.JavaBreakpointProperties<*>");
            }
            JavaBreakpointProperties $receiver = javaBreakpointProperties = (JavaBreakpointProperties)xBreakpointProperties;
            $receiver.setINSTANCE_FILTERS_ENABLED(true);
            Object[] objectArray = $receiver.getInstanceFilters();
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"instanceFilters");
            $receiver.setInstanceFilters((InstanceFilter[])Companion.appendIfNeeded(objectArray, InstanceFilter.create(this.myInstance)));
            XBreakpoint<?> xBreakpoint = this.getMyBreakpoint();
            if (xBreakpoint == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.xdebugger.impl.breakpoints.XBreakpointBase<*, *, *>");
            }
            ((XBreakpointBase)xBreakpoint).fireBreakpointChanged();
        }

        public AddInstanceFilter(@NotNull XBreakpoint<?> breakpoint, long myInstance) {
            Intrinsics.checkParameterIsNotNull(breakpoint, (String)"breakpoint");
            super(breakpoint, "Stop only in the current object");
            this.myInstance = myInstance;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/debugger/ui/breakpoints/BreakpointIntentionAction$AddClassFilter;", "Lcom/intellij/debugger/ui/breakpoints/BreakpointIntentionAction;", "breakpoint", "Lcom/intellij/xdebugger/breakpoints/XBreakpoint;", "myClass", "", "(Lcom/intellij/xdebugger/breakpoints/XBreakpoint;Ljava/lang/String;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "intellij.java.debugger.impl"})
    public static final class AddClassFilter
    extends BreakpointIntentionAction {
        private final String myClass;

        /*
         * Unable to fully structure code
         */
        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            v0 = this.getMyBreakpoint().getProperties();
            if (v0 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.java.debugger.breakpoints.properties.JavaBreakpointProperties<*>");
            }
            $receiver = var2_2 = (JavaBreakpointProperties)v0;
            v1 = e.getPresentation();
            if (!$receiver.isCLASS_FILTERS_ENABLED()) ** GOTO lbl-1000
            v2 = $receiver.getClassFilters();
            Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"classFilters");
            if (!ArraysKt.contains((Object[])v2, (Object)new ClassFilter(this.myClass))) lbl-1000:
            // 2 sources

            {
                v3 = true;
            } else {
                v3 = false;
            }
            v1.setEnabled(v3);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            JavaBreakpointProperties javaBreakpointProperties;
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            XBreakpointProperties xBreakpointProperties = this.getMyBreakpoint().getProperties();
            if (xBreakpointProperties == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.java.debugger.breakpoints.properties.JavaBreakpointProperties<*>");
            }
            JavaBreakpointProperties $receiver = javaBreakpointProperties = (JavaBreakpointProperties)xBreakpointProperties;
            $receiver.setCLASS_FILTERS_ENABLED(true);
            ClassFilter classFilter = new ClassFilter(this.myClass);
            Object[] objectArray = $receiver.getClassFilters();
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"classFilters");
            $receiver.setClassFilters((ClassFilter[])Companion.appendIfNeeded(objectArray, classFilter));
            $receiver.setClassExclusionFilters((ClassFilter[])ArrayUtil.remove((Object[])$receiver.getClassExclusionFilters(), (Object)classFilter));
            XBreakpoint<?> xBreakpoint = this.getMyBreakpoint();
            if (xBreakpoint == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.xdebugger.impl.breakpoints.XBreakpointBase<*, *, *>");
            }
            ((XBreakpointBase)xBreakpoint).fireBreakpointChanged();
        }

        public AddClassFilter(@NotNull XBreakpoint<?> breakpoint, @NotNull String myClass) {
            Intrinsics.checkParameterIsNotNull(breakpoint, (String)"breakpoint");
            Intrinsics.checkParameterIsNotNull((Object)myClass, (String)"myClass");
            super(breakpoint, "Stop only in the class: " + StringUtil.getShortName((String)myClass));
            this.myClass = myClass;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/debugger/ui/breakpoints/BreakpointIntentionAction$AddClassNotFilter;", "Lcom/intellij/debugger/ui/breakpoints/BreakpointIntentionAction;", "breakpoint", "Lcom/intellij/xdebugger/breakpoints/XBreakpoint;", "myClass", "", "(Lcom/intellij/xdebugger/breakpoints/XBreakpoint;Ljava/lang/String;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "intellij.java.debugger.impl"})
    public static final class AddClassNotFilter
    extends BreakpointIntentionAction {
        private final String myClass;

        /*
         * Unable to fully structure code
         */
        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            v0 = this.getMyBreakpoint().getProperties();
            if (v0 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.java.debugger.breakpoints.properties.JavaBreakpointProperties<*>");
            }
            $receiver = var2_2 = (JavaBreakpointProperties)v0;
            v1 = e.getPresentation();
            if (!$receiver.isCLASS_FILTERS_ENABLED()) ** GOTO lbl-1000
            v2 = $receiver.getClassExclusionFilters();
            Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"classExclusionFilters");
            if (!ArraysKt.contains((Object[])v2, (Object)new ClassFilter(this.myClass))) lbl-1000:
            // 2 sources

            {
                v3 = true;
            } else {
                v3 = false;
            }
            v1.setEnabled(v3);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            JavaBreakpointProperties javaBreakpointProperties;
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            XBreakpointProperties xBreakpointProperties = this.getMyBreakpoint().getProperties();
            if (xBreakpointProperties == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.java.debugger.breakpoints.properties.JavaBreakpointProperties<*>");
            }
            JavaBreakpointProperties $receiver = javaBreakpointProperties = (JavaBreakpointProperties)xBreakpointProperties;
            $receiver.setCLASS_FILTERS_ENABLED(true);
            ClassFilter classFilter = new ClassFilter(this.myClass);
            Object[] objectArray = $receiver.getClassExclusionFilters();
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"classExclusionFilters");
            $receiver.setClassExclusionFilters((ClassFilter[])Companion.appendIfNeeded(objectArray, classFilter));
            $receiver.setClassFilters((ClassFilter[])ArrayUtil.remove((Object[])$receiver.getClassFilters(), (Object)classFilter));
            XBreakpoint<?> xBreakpoint = this.getMyBreakpoint();
            if (xBreakpoint == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.xdebugger.impl.breakpoints.XBreakpointBase<*, *, *>");
            }
            ((XBreakpointBase)xBreakpoint).fireBreakpointChanged();
        }

        public AddClassNotFilter(@NotNull XBreakpoint<?> breakpoint, @NotNull String myClass) {
            Intrinsics.checkParameterIsNotNull(breakpoint, (String)"breakpoint");
            Intrinsics.checkParameterIsNotNull((Object)myClass, (String)"myClass");
            super(breakpoint, "Do not stop in the class: " + StringUtil.getShortName((String)myClass));
            this.myClass = myClass;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J/\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\n0\t\"\u0004\b\u0000\u0010\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\n0\t2\u0006\u0010\f\u001a\u0002H\nH\u0002\u00a2\u0006\u0002\u0010\rJ$\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0007R\u001e\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0007\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/debugger/ui/breakpoints/BreakpointIntentionAction$Companion;", "", "()V", "CALLER_KEY", "Lcom/intellij/openapi/util/Key;", "", "kotlin.jvm.PlatformType", "THIS_TYPE_KEY", "appendIfNeeded", "", "T", "array", "element", "([Ljava/lang/Object;Ljava/lang/Object;)[Ljava/lang/Object;", "getIntentions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "breakpoint", "Lcom/intellij/xdebugger/breakpoints/XBreakpoint;", "currentSession", "Lcom/intellij/xdebugger/XDebugSession;", "intellij.java.debugger.impl"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final List<AnAction> getIntentions(@NotNull XBreakpoint<?> breakpoint, @Nullable XDebugSession currentSession) {
            XDebugProcess process2;
            Intrinsics.checkParameterIsNotNull(breakpoint, (String)"breakpoint");
            XDebugSession xDebugSession = currentSession;
            Object object = process2 = xDebugSession != null ? xDebugSession.getDebugProcess() : null;
            if (process2 instanceof JavaDebugProcess) {
                ArrayList<BreakpointIntentionAction> res = new ArrayList<BreakpointIntentionAction>();
                XStackFrame currentStackFrame = currentSession.getCurrentStackFrame();
                if (currentStackFrame instanceof JavaStackFrame) {
                    StackFrameDescriptorImpl stackFrameDescriptorImpl = ((JavaStackFrame)currentStackFrame).getDescriptor();
                    Intrinsics.checkExpressionValueIsNotNull((Object)stackFrameDescriptorImpl, (String)"currentStackFrame.descriptor");
                    StackFrameDescriptorImpl frameDescriptor = stackFrameDescriptorImpl;
                    String string = frameDescriptor.getUserData(THIS_TYPE_KEY);
                    if (string != null) {
                        String string2;
                        String it;
                        String string3 = it = (string2 = string);
                        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"it");
                        res.add(new AddClassFilter(breakpoint, string3));
                        res.add(new AddClassNotFilter(breakpoint, it));
                    }
                    ObjectReference objectReference = frameDescriptor.getThisObject();
                    if (objectReference != null) {
                        long l;
                        long it = l = objectReference.uniqueID();
                        res.add(new AddInstanceFilter(breakpoint, it));
                    }
                    if (Registry.is((String)"debugger.breakpoints.caller.filter")) {
                        String string4 = frameDescriptor.getUserData(CALLER_KEY);
                        if (string4 != null) {
                            String string5;
                            String it;
                            String string6 = it = (string5 = string4);
                            Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"it");
                            res.add(new AddCallerFilter(breakpoint, string6));
                            res.add(new AddCallerNotFilter(breakpoint, it));
                        }
                    }
                }
                return res;
            }
            return CollectionsKt.emptyList();
        }

        private final <T> T[] appendIfNeeded(T[] array, T element) {
            Object[] objectArray;
            if (ArraysKt.contains((Object[])array, element)) {
                objectArray = array;
            } else {
                Object[] objectArray2 = ArrayUtil.append((Object[])array, element);
                objectArray = objectArray2;
                Intrinsics.checkExpressionValueIsNotNull((Object)objectArray2, (String)"ArrayUtil.append(array, element)");
            }
            return objectArray;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

