/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.BreakpointIntentionAction;
import com.intellij.debugger.ui.breakpoints.BreakpointManager;
import com.intellij.debugger.ui.breakpoints.JavaBreakpointType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointCustomPropertiesPanel;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.JavaDebuggerEditorsProvider;
import org.jetbrains.java.debugger.breakpoints.JavaBreakpointFiltersPanel;
import org.jetbrains.java.debugger.breakpoints.properties.JavaBreakpointProperties;

public abstract class JavaBreakpointTypeBase<T extends JavaBreakpointProperties>
extends XBreakpointType<XBreakpoint<T>, T>
implements JavaBreakpointType<T> {
    protected JavaBreakpointTypeBase(@NonNls @NotNull String id, @Nls @NotNull String title) {
        if (id == null) {
            JavaBreakpointTypeBase.$$$reportNull$$$0(0);
        }
        if (title == null) {
            JavaBreakpointTypeBase.$$$reportNull$$$0(1);
        }
        super(id, title, true);
    }

    public final boolean isAddBreakpointButtonVisible() {
        return true;
    }

    @NotNull
    public final XBreakpointCustomPropertiesPanel<XBreakpoint<T>> createCustomRightPropertiesPanel(@NotNull Project project2) {
        if (project2 == null) {
            JavaBreakpointTypeBase.$$$reportNull$$$0(2);
        }
        JavaBreakpointFiltersPanel javaBreakpointFiltersPanel = new JavaBreakpointFiltersPanel(project2);
        if (javaBreakpointFiltersPanel == null) {
            JavaBreakpointTypeBase.$$$reportNull$$$0(3);
        }
        return javaBreakpointFiltersPanel;
    }

    @NotNull
    public final XDebuggerEditorsProvider getEditorsProvider(@NotNull XBreakpoint<T> breakpoint, @NotNull Project project2) {
        if (breakpoint == null) {
            JavaBreakpointTypeBase.$$$reportNull$$$0(4);
        }
        if (project2 == null) {
            JavaBreakpointTypeBase.$$$reportNull$$$0(5);
        }
        JavaDebuggerEditorsProvider javaDebuggerEditorsProvider = new JavaDebuggerEditorsProvider();
        if (javaDebuggerEditorsProvider == null) {
            JavaBreakpointTypeBase.$$$reportNull$$$0(6);
        }
        return javaDebuggerEditorsProvider;
    }

    @Nullable
    public XSourcePosition getSourcePosition(@NotNull XBreakpoint<T> breakpoint) {
        PsiClass aClass;
        Breakpoint javaBreakpoint;
        if (breakpoint == null) {
            JavaBreakpointTypeBase.$$$reportNull$$$0(7);
        }
        if ((javaBreakpoint = BreakpointManager.getJavaBreakpoint(breakpoint)) != null && (aClass = javaBreakpoint.getPsiClass()) != null) {
            return (XSourcePosition)ReadAction.compute(() -> XDebuggerUtil.getInstance().createPositionByElement((PsiElement)aClass));
        }
        return null;
    }

    public List<? extends AnAction> getAdditionalPopupMenuActions(@NotNull XBreakpoint<T> breakpoint, @Nullable XDebugSession currentSession) {
        if (breakpoint == null) {
            JavaBreakpointTypeBase.$$$reportNull$$$0(8);
        }
        return BreakpointIntentionAction.getIntentions(breakpoint, currentSession);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/ui/breakpoints/JavaBreakpointTypeBase";
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakpoint";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/ui/breakpoints/JavaBreakpointTypeBase";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createCustomRightPropertiesPanel";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorsProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createCustomRightPropertiesPanel";
                break;
            }
            case 3: 
            case 6: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getEditorsProvider";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getSourcePosition";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalPopupMenuActions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

