/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.overhead;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.overhead.OverheadProducer;
import com.intellij.debugger.ui.overhead.OverheadTimings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.pom.Navigatable;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TableUtil;
import com.intellij.ui.table.TableView;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.function.Function;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SortOrder;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OverheadView
extends BorderLayoutPanel
implements Disposable,
DataProvider {
    @NotNull
    private final DebugProcessImpl myProcess;
    static final EnabledColumnInfo ENABLED_COLUMN = new EnabledColumnInfo();
    static final NameColumnInfo NAME_COLUMN = new NameColumnInfo();
    private final TableView<OverheadProducer> myTable;
    private final ListTableModel<OverheadProducer> myModel;
    private final MergingUpdateQueue myUpdateQueue;
    private Runnable myBouncer;

    public OverheadView(final @NotNull DebugProcessImpl process2) {
        if (process2 == null) {
            OverheadView.$$$reportNull$$$0(0);
        }
        this.myProcess = process2;
        this.myModel = new ListTableModel(new ColumnInfo[]{ENABLED_COLUMN, NAME_COLUMN, new TimingColumnInfo("Hits", s -> OverheadTimings.getHits(this.myProcess, s)), new TimingColumnInfo("Time (ms)", s -> OverheadTimings.getTime(this.myProcess, s))}, new ArrayList<OverheadProducer>(OverheadTimings.getProducers(process2)), 3, SortOrder.DESCENDING);
        this.myModel.setSortable(true);
        this.myTable = new TableView(this.myModel);
        this.addToCenter(ScrollPaneFactory.createScrollPane(this.myTable));
        TableUtil.setupCheckboxColumn((TableColumn)this.myTable.getColumnModel().getColumn(0));
        this.myUpdateQueue = new MergingUpdateQueue("OverheadView", 500, true, null, (Disposable)this);
        this.myUpdateQueue.setPassThrough(false);
        OverheadTimings.addListener(new OverheadTimings.OverheadTimingsListener(){

            @Override
            public void timingAdded(final OverheadProducer o) {
                OverheadView.this.myUpdateQueue.queue(new Update(o){

                    public void run() {
                        int idx = OverheadView.this.myModel.indexOf((Object)o);
                        if (idx != -1) {
                            OverheadView.this.myModel.fireTableRowsUpdated(idx, idx);
                            return;
                        }
                        OverheadView.this.myModel.setItems(new ArrayList<OverheadProducer>(OverheadTimings.getProducers(process2)));
                    }
                });
            }

            @Override
            public void excessiveOverheadDetected() {
                if (OverheadView.this.myBouncer != null) {
                    DebuggerUIUtil.invokeLater((Runnable)OverheadView.this.myBouncer);
                }
            }
        }, process2);
        new DumbAwareAction("Toggle"){

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                e.getPresentation().setEnabled(OverheadView.this.myTable.getSelectedRowCount() == 1);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(1);
                }
                OverheadView.this.myTable.getSelection().forEach(c -> c.setEnabled(!c.isEnabled()));
                OverheadView.this.myTable.repaint();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/debugger/ui/overhead/OverheadView$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(32, 0)), this.myTable);
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent e) {
                OverheadView.this.getSelectedNavigatables().findFirst().ifPresent(b -> b.navigate(true));
                return true;
            }
        }.installOn(this.myTable);
    }

    private StreamEx<Navigatable> getSelectedNavigatables() {
        return StreamEx.of((Collection)this.myTable.getSelection()).select(Breakpoint.class).map(Breakpoint::getXBreakpoint).nonNull().map(XBreakpoint::getNavigatable).nonNull();
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        Navigatable[] navigatables;
        if (dataId == null) {
            OverheadView.$$$reportNull$$$0(1);
        }
        if (CommonDataKeys.NAVIGATABLE_ARRAY.is(dataId) && (navigatables = (Navigatable[])this.getSelectedNavigatables().toArray(Navigatable.class)).length > 0) {
            return navigatables;
        }
        return null;
    }

    public void dispose() {
    }

    public void setBouncer(Runnable bouncer) {
        this.myBouncer = bouncer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
        }
        objectArray2[1] = "com/intellij/debugger/ui/overhead/OverheadView";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getData";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class TimingColumnInfo
    extends ColumnInfo<OverheadProducer, OverheadProducer> {
        private final Function<OverheadProducer, Long> myGetter;

        TimingColumnInfo(@NotNull String name2, Function<OverheadProducer, Long> getter) {
            if (name2 == null) {
                TimingColumnInfo.$$$reportNull$$$0(0);
            }
            super(name2);
            this.myGetter = getter;
        }

        @Nullable
        public OverheadProducer valueOf(OverheadProducer aspects) {
            return aspects;
        }

        public Class<?> getColumnClass() {
            return OverheadProducer.class;
        }

        @Nullable
        public TableCellRenderer getRenderer(OverheadProducer producer) {
            return new ColoredTableCellRenderer(){

                protected void customizeCellRenderer(JTable table, @Nullable Object value, boolean selected, boolean hasFocus, int row, int column) {
                    if (value instanceof OverheadProducer) {
                        OverheadProducer overheadProducer = (OverheadProducer)value;
                        Long val = (Long)myGetter.apply(overheadProducer);
                        this.append(val != null ? String.valueOf(val) : "", overheadProducer.isEnabled() ? SimpleTextAttributes.SIMPLE_CELL_ATTRIBUTES : SimpleTextAttributes.GRAYED_ATTRIBUTES);
                    }
                }
            };
        }

        @Nullable
        public Comparator<OverheadProducer> getComparator() {
            return Comparator.comparing(c -> {
                Long value = this.myGetter.apply((OverheadProducer)c);
                return value != null ? value : Long.MAX_VALUE;
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/debugger/ui/overhead/OverheadView$TimingColumnInfo", "<init>"));
        }
    }

    private static class NameColumnInfo
    extends ColumnInfo<OverheadProducer, OverheadProducer> {
        NameColumnInfo() {
            super("Name");
        }

        @Nullable
        public OverheadProducer valueOf(OverheadProducer aspects) {
            return aspects;
        }

        public Class<?> getColumnClass() {
            return OverheadProducer.class;
        }

        @Nullable
        public TableCellRenderer getRenderer(OverheadProducer producer) {
            return new ColoredTableCellRenderer(){

                protected void customizeCellRenderer(JTable table, @Nullable Object value, boolean selected, boolean hasFocus, int row, int column) {
                    if (value instanceof OverheadProducer) {
                        OverheadProducer overheadProducer = (OverheadProducer)value;
                        if (!overheadProducer.isEnabled()) {
                            SimpleColoredComponent component = new SimpleColoredComponent();
                            overheadProducer.customizeRenderer(component);
                            component.iterator().forEachRemaining(f -> this.append((String)f, SimpleTextAttributes.GRAYED_ATTRIBUTES));
                            this.setIcon(component.getIcon());
                        } else {
                            overheadProducer.customizeRenderer((SimpleColoredComponent)this);
                        }
                    }
                    this.setTransparentIconBackground(true);
                }
            };
        }
    }

    private static class EnabledColumnInfo
    extends ColumnInfo<OverheadProducer, Boolean> {
        EnabledColumnInfo() {
            super("");
        }

        public Class<?> getColumnClass() {
            return Boolean.class;
        }

        @Nullable
        public Boolean valueOf(OverheadProducer item) {
            return item.isEnabled();
        }

        public boolean isCellEditable(OverheadProducer item) {
            return true;
        }

        public void setValue(OverheadProducer item, Boolean value) {
            item.setEnabled(value);
        }
    }
}

