/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.actions;

import com.intellij.designer.DesignerBundle;
import com.intellij.designer.clipboard.SimpleTransferable;
import com.intellij.designer.designSurface.DesignerEditorPanel;
import com.intellij.designer.designSurface.EditableArea;
import com.intellij.designer.designSurface.tools.ComponentPasteFactory;
import com.intellij.designer.designSurface.tools.PasteTool;
import com.intellij.designer.model.IComponentCopyProvider;
import com.intellij.designer.model.IComponentDeletionParticipant;
import com.intellij.designer.model.IGroupDeleteComponent;
import com.intellij.designer.model.RadComponent;
import com.intellij.ide.CopyProvider;
import com.intellij.ide.CutProvider;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.PasteProvider;
import com.intellij.ide.dnd.FileCopyPasteUtil;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.uiDesigner.SerializedComponentData;
import com.intellij.util.ThrowableRunnable;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommonEditActionsProvider
implements DeleteProvider,
CopyProvider,
PasteProvider,
CutProvider {
    private static final DataFlavor DATA_FLAVOR = FileCopyPasteUtil.createJvmDataFlavor(SerializedComponentData.class);
    public static boolean isDeleting;
    private final DesignerEditorPanel myDesigner;

    public CommonEditActionsProvider(DesignerEditorPanel designer) {
        this.myDesigner = designer;
    }

    protected EditableArea getArea(DataContext dataContext) {
        EditableArea area = (EditableArea)EditableArea.DATA_KEY.getData(dataContext);
        return area == null ? this.myDesigner.getSurfaceArea() : area;
    }

    public boolean canDeleteElement(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            CommonEditActionsProvider.$$$reportNull$$$0(0);
        }
        if (this.myDesigner.getInplaceEditingLayer().isEditing()) {
            return false;
        }
        List<RadComponent> selection = this.getArea(dataContext).getSelection();
        if (selection.isEmpty()) {
            return false;
        }
        for (RadComponent component : selection) {
            if (component.canDelete()) continue;
            return false;
        }
        return true;
    }

    public void deleteElement(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            CommonEditActionsProvider.$$$reportNull$$$0(1);
        }
        this.myDesigner.getToolProvider().execute((ThrowableRunnable<Exception>)((ThrowableRunnable)() -> {
            EditableArea area;
            List<RadComponent> selection;
            if (dataContext == null) {
                CommonEditActionsProvider.$$$reportNull$$$0(12);
            }
            if ((selection = (area = this.getArea(dataContext)).getSelection()).isEmpty()) {
                return;
            }
            this.myDesigner.getToolProvider().loadDefaultTool();
            List<RadComponent> components = RadComponent.getPureSelection(selection);
            CommonEditActionsProvider.updateSelectionBeforeDelete(area, components.get(0), selection);
            CommonEditActionsProvider.handleDeletion(components);
        }), DesignerBundle.message("command.delete.selection", new Object[0]), true);
    }

    private static void handleDeletion(@NotNull List<RadComponent> components) throws Exception {
        if (components == null) {
            CommonEditActionsProvider.$$$reportNull$$$0(2);
        }
        Map<RadComponent, List<RadComponent>> siblingLists = RadComponent.groupSiblings(components);
        for (Map.Entry<RadComponent, List<RadComponent>> entry : siblingLists.entrySet()) {
            IComponentDeletionParticipant handler;
            RadComponent parent = entry.getKey();
            List<RadComponent> children = entry.getValue();
            boolean finished = false;
            if (parent instanceof IComponentDeletionParticipant) {
                handler = (IComponentDeletionParticipant)((Object)parent);
                finished = handler.deleteChildren(parent, children);
            } else if (parent != null && parent.getLayout() instanceof IComponentDeletionParticipant) {
                handler = (IComponentDeletionParticipant)((Object)parent.getLayout());
                finished = handler.deleteChildren(parent, children);
            }
            if (finished) continue;
            CommonEditActionsProvider.deleteComponents(children);
        }
    }

    private static void deleteComponents(List<RadComponent> components) throws Exception {
        if (components.get(0) instanceof IGroupDeleteComponent) {
            ((IGroupDeleteComponent)((Object)components.get(0))).delete(components);
        } else {
            for (RadComponent component : components) {
                component.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateSelectionBeforeDelete(EditableArea area, RadComponent component, List<RadComponent> excludes) {
        try {
            isDeleting = true;
            RadComponent newSelection = CommonEditActionsProvider.getNewSelection(component, excludes);
            if (newSelection == null) {
                area.deselectAll();
            } else {
                area.select(newSelection);
            }
        }
        finally {
            isDeleting = false;
        }
    }

    @Nullable
    private static RadComponent getNewSelection(RadComponent component, List<RadComponent> excludes) {
        RadComponent parent = component.getParent();
        if (parent == null) {
            return null;
        }
        List<RadComponent> children = parent.getChildren();
        int size = children.size();
        for (int i = children.indexOf((Object)component) + 1; i < size; ++i) {
            RadComponent next = children.get(i);
            if (excludes.contains((Object)next)) continue;
            return next;
        }
        return parent;
    }

    public boolean isCopyVisible(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            CommonEditActionsProvider.$$$reportNull$$$0(3);
        }
        return true;
    }

    public boolean isCopyEnabled(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            CommonEditActionsProvider.$$$reportNull$$$0(4);
        }
        if (this.myDesigner.getInplaceEditingLayer().isEditing()) {
            return false;
        }
        List<RadComponent> selection = this.getArea(dataContext).getSelection();
        if (selection.isEmpty()) {
            return false;
        }
        RadComponent rootComponent = this.myDesigner.getRootComponent();
        if (rootComponent instanceof IComponentCopyProvider) {
            IComponentCopyProvider copyProvider = (IComponentCopyProvider)((Object)rootComponent);
            return copyProvider.isCopyEnabled(selection);
        }
        return true;
    }

    public void performCopy(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            CommonEditActionsProvider.$$$reportNull$$$0(5);
        }
        this.doCopy(dataContext);
    }

    private boolean doCopy(DataContext dataContext) {
        try {
            Element root = new Element("designer");
            root.setAttribute("target", this.myDesigner.getPlatformTarget());
            List<RadComponent> components = RadComponent.getPureSelection(this.getArea(dataContext).getSelection());
            RadComponent rootComponent = this.myDesigner.getRootComponent();
            if (rootComponent instanceof IComponentCopyProvider) {
                IComponentCopyProvider copyProvider = (IComponentCopyProvider)((Object)rootComponent);
                copyProvider.copyTo(root, components);
            } else {
                for (RadComponent component : components) {
                    component.copyTo(root);
                }
            }
            SerializedComponentData data = new SerializedComponentData(new XMLOutputter().outputString(root));
            CopyPasteManager.getInstance().setContents((Transferable)new SimpleTransferable(data, DATA_FLAVOR));
            return true;
        }
        catch (Throwable e) {
            this.myDesigner.showError("Copy error", e);
            return false;
        }
    }

    public boolean isPastePossible(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            CommonEditActionsProvider.$$$reportNull$$$0(6);
        }
        return this.isPasteEnabled(dataContext);
    }

    public boolean isPasteEnabled(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            CommonEditActionsProvider.$$$reportNull$$$0(7);
        }
        return !this.myDesigner.getInplaceEditingLayer().isEditing() && this.getSerializedComponentData() != null;
    }

    @Nullable
    private String getSerializedComponentData() {
        try {
            SerializedComponentData data;
            String xmlComponents;
            Object transferData = CopyPasteManager.getInstance().getContents(DATA_FLAVOR);
            if (transferData instanceof SerializedComponentData && (xmlComponents = (data = (SerializedComponentData)transferData).getSerializedComponents()).startsWith("<designer target=\"" + this.myDesigner.getPlatformTarget() + "\">")) {
                return xmlComponents;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public void performPaste(@NotNull DataContext dataContext) {
        ComponentPasteFactory factory;
        if (dataContext == null) {
            CommonEditActionsProvider.$$$reportNull$$$0(8);
        }
        if ((factory = this.myDesigner.createPasteFactory(this.getSerializedComponentData())) != null) {
            this.myDesigner.getToolProvider().setActiveTool(new PasteTool(true, factory));
        }
    }

    public boolean isCutVisible(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            CommonEditActionsProvider.$$$reportNull$$$0(9);
        }
        return true;
    }

    public boolean isCutEnabled(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            CommonEditActionsProvider.$$$reportNull$$$0(10);
        }
        return this.isCopyEnabled(dataContext) && this.canDeleteElement(dataContext);
    }

    public void performCut(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            CommonEditActionsProvider.$$$reportNull$$$0(11);
        }
        if (this.doCopy(dataContext)) {
            this.deleteElement(dataContext);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
        }
        objectArray2[1] = "com/intellij/designer/actions/CommonEditActionsProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canDeleteElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "deleteElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "handleDeletion";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isCopyVisible";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isCopyEnabled";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "performCopy";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isPastePossible";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isPasteEnabled";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "performPaste";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "isCutVisible";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "isCutEnabled";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "performCut";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$deleteElement$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

