/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator;

import com.intellij.dupLocator.DupInfo;
import com.intellij.dupLocator.DuplocateVisitor;
import com.intellij.dupLocator.DuplocatorState;
import com.intellij.dupLocator.PsiElementRole;
import com.intellij.dupLocator.treeHash.FragmentsCollector;
import com.intellij.dupLocator.util.PsiFragment;
import com.intellij.lang.Language;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.psi.PsiElement;
import com.intellij.util.indexing.FileContent;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DuplicatesProfile {
    public static final ExtensionPointName<DuplicatesProfile> EP_NAME = ExtensionPointName.create((String)"com.intellij.duplicates.profile");
    private static final int FACTOR = 2;
    private static final int MAX_COST = 7000;

    @NotNull
    public abstract DuplocateVisitor createVisitor(@NotNull FragmentsCollector var1);

    @NotNull
    public DuplocateVisitor createVisitor(@NotNull FragmentsCollector collector, boolean forIndexing) {
        if (collector == null) {
            DuplicatesProfile.$$$reportNull$$$0(0);
        }
        DuplocateVisitor duplocateVisitor = this.createVisitor(collector);
        if (duplocateVisitor == null) {
            DuplicatesProfile.$$$reportNull$$$0(1);
        }
        return duplocateVisitor;
    }

    public abstract boolean isMyLanguage(@NotNull Language var1);

    @NotNull
    public abstract DuplocatorState getDuplocatorState(@NotNull Language var1);

    @Nullable
    public String getComment(@NotNull DupInfo info, int index) {
        if (info == null) {
            DuplicatesProfile.$$$reportNull$$$0(2);
        }
        return null;
    }

    public abstract boolean isMyDuplicate(@NotNull DupInfo var1, int var2);

    public boolean supportIndex() {
        return true;
    }

    public boolean supportDuplicatesIndex() {
        return false;
    }

    public boolean acceptsContentForIndexing(FileContent fileContent) {
        return true;
    }

    public boolean shouldPutInIndex(PsiFragment fragment, int cost, DuplocatorState state) {
        int lowerBound = state.getLowerBound();
        return cost >= 2 * lowerBound && cost <= 7000;
    }

    @Nullable
    public static DuplicatesProfile findProfileForLanguage(@NotNull Language language) {
        if (language == null) {
            DuplicatesProfile.$$$reportNull$$$0(3);
        }
        return DuplicatesProfile.findProfileForLanguage(EP_NAME.getExtensionList(), language);
    }

    @NotNull
    public static List<DuplicatesProfile> getAllProfiles() {
        List list = EP_NAME.getExtensionList();
        if (list == null) {
            DuplicatesProfile.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Nullable
    public static DuplicatesProfile findProfileForLanguage(List<? extends DuplicatesProfile> profiles, @NotNull Language language) {
        if (language == null) {
            DuplicatesProfile.$$$reportNull$$$0(5);
        }
        for (DuplicatesProfile duplicatesProfile : profiles) {
            if (!duplicatesProfile.isMyLanguage(language)) continue;
            return duplicatesProfile;
        }
        return null;
    }

    @NotNull
    public Language getLanguage(@NotNull PsiElement element) {
        if (element == null) {
            DuplicatesProfile.$$$reportNull$$$0(6);
        }
        Language language = element.getLanguage();
        if (language == null) {
            DuplicatesProfile.$$$reportNull$$$0(7);
        }
        return language;
    }

    @Nullable
    public PsiElementRole getRole(@NotNull PsiElement element) {
        if (element == null) {
            DuplicatesProfile.$$$reportNull$$$0(8);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collector";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/dupLocator/DuplicatesProfile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/dupLocator/DuplicatesProfile";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createVisitor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllProfiles";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createVisitor";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getComment";
                break;
            }
            case 3: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findProfileForLanguage";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getLanguage";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getRole";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

