/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.concurrency.JobScheduler;
import com.intellij.debugger.engine.JavaDebugProcess;
import com.intellij.debugger.impl.attach.JavaDebuggerAttachUtil;
import com.intellij.debugger.impl.attach.PidRemoteConnection;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.JavaCommandLine;
import com.intellij.execution.configurations.JavaCommandLineState;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ModuleRunProfile;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.CapturingProcessAdapter;
import com.intellij.execution.process.OSProcessUtil;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.JavaPatchableProgramRunner;
import com.intellij.execution.runners.ProcessProxy;
import com.intellij.execution.runners.ProcessProxyFactory;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.runners.RunConfigurationWithSuppressedDefaultRunAction;
import com.intellij.execution.runners.RunContentBuilder;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.unscramble.AnalyzeStacktraceUtil;
import com.intellij.unscramble.ThreadDumpConsoleFactory;
import com.intellij.unscramble.ThreadDumpParser;
import com.intellij.unscramble.ThreadState;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XDebuggerManagerListener;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;

public class DefaultJavaProgramRunner
extends JavaPatchableProgramRunner {
    private static final String ourWiseThreadDumpProperty = "idea.java.run.wise.thread.dump";
    public static final String DEFAULT_JAVA_RUNNER_ID = "Run";

    public static ProgramRunner getInstance() {
        return ProgramRunner.findRunnerById((String)DEFAULT_JAVA_RUNNER_ID);
    }

    @NotNull
    public String getRunnerId() {
        if (DEFAULT_JAVA_RUNNER_ID == null) {
            DefaultJavaProgramRunner.$$$reportNull$$$0(0);
        }
        return DEFAULT_JAVA_RUNNER_ID;
    }

    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile2) {
        if (executorId == null) {
            DefaultJavaProgramRunner.$$$reportNull$$$0(1);
        }
        if (profile2 == null) {
            DefaultJavaProgramRunner.$$$reportNull$$$0(2);
        }
        return executorId.equals(DefaultRunExecutor.EXECUTOR_ID) && profile2 instanceof ModuleRunProfile && !(profile2 instanceof RunConfigurationWithSuppressedDefaultRunAction);
    }

    public void patch(JavaParameters javaParameters, RunnerSettings settings, RunProfile runProfile, boolean beforeExecution) throws ExecutionException {
        DefaultJavaProgramRunner.runCustomPatchers((JavaParameters)javaParameters, (Executor)DefaultRunExecutor.getRunExecutorInstance(), (RunProfile)runProfile);
    }

    protected RunContentDescriptor doExecute(@NotNull RunProfileState state, @NotNull ExecutionEnvironment env) throws ExecutionException {
        ExecutionResult executionResult;
        if (state == null) {
            DefaultJavaProgramRunner.$$$reportNull$$$0(3);
        }
        if (env == null) {
            DefaultJavaProgramRunner.$$$reportNull$$$0(4);
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        boolean shouldAddDefaultActions = true;
        if (state instanceof JavaCommandLine) {
            ParametersList parametersList;
            JavaParameters parameters = ((JavaCommandLine)state).getJavaParameters();
            this.patch(parameters, env.getRunnerSettings(), env.getRunProfile(), true);
            if (Registry.is((String)"execution.java.always.debug") && DebuggerSettings.getInstance().ALWAYS_DEBUG && (parametersList = parameters.getVMParametersList()).getList().stream().noneMatch(s -> s.startsWith("-agentlib:jdwp"))) {
                parametersList.add("-agentlib:jdwp=transport=dt_socket,server=y,suspend=n,quiet=y");
            }
            final ProcessProxy proxy = ProcessProxyFactory.getInstance().createCommandLineProxy((JavaCommandLine)state);
            executionResult = state.execute(env.getExecutor(), (ProgramRunner)this);
            if (proxy != null) {
                ProcessHandler handler;
                ProcessHandler processHandler = handler = executionResult != null ? executionResult.getProcessHandler() : null;
                if (handler != null) {
                    proxy.attach(handler);
                    handler.addProcessListener((ProcessListener)new ProcessAdapter(){

                        public void processTerminated(@NotNull ProcessEvent event) {
                            if (event == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            proxy.destroy();
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/execution/impl/DefaultJavaProgramRunner$1", "processTerminated"));
                        }
                    });
                } else {
                    proxy.destroy();
                }
            }
            if (state instanceof JavaCommandLineState && !((JavaCommandLineState)state).shouldAddJavaProgramRunnerActions()) {
                shouldAddDefaultActions = false;
            }
        } else {
            executionResult = state.execute(env.getExecutor(), (ProgramRunner)this);
        }
        if (executionResult == null) {
            return null;
        }
        this.onProcessStarted(env.getRunnerSettings(), executionResult);
        RunContentBuilder contentBuilder = new RunContentBuilder(executionResult, env);
        if (shouldAddDefaultActions) {
            DefaultJavaProgramRunner.addDefaultActions(contentBuilder, executionResult, state instanceof JavaCommandLine);
        }
        return contentBuilder.showRunContent(env.getContentToReuse());
    }

    private static void addDefaultActions(@NotNull RunContentBuilder contentBuilder, @NotNull ExecutionResult executionResult, boolean isJavaCommandLine) {
        ExecutionConsole executionConsole;
        if (contentBuilder == null) {
            DefaultJavaProgramRunner.$$$reportNull$$$0(5);
        }
        if (executionResult == null) {
            DefaultJavaProgramRunner.$$$reportNull$$$0(6);
        }
        final JComponent consoleComponent = (executionConsole = executionResult.getExecutionConsole()) != null ? executionConsole.getComponent() : null;
        final ProcessHandler processHandler = executionResult.getProcessHandler();
        assert (processHandler != null) : executionResult;
        final ControlBreakAction controlBreakAction = new ControlBreakAction(processHandler);
        if (consoleComponent != null) {
            controlBreakAction.registerCustomShortcutSet(controlBreakAction.getShortcutSet(), consoleComponent);
            processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void processTerminated(@NotNull ProcessEvent event) {
                    if (event == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    processHandler.removeProcessListener((ProcessListener)this);
                    controlBreakAction.unregisterCustomShortcutSet(consoleComponent);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/execution/impl/DefaultJavaProgramRunner$2", "processTerminated"));
                }
            });
        }
        contentBuilder.addAction((AnAction)controlBreakAction);
        if (isJavaCommandLine) {
            AttachDebuggerAction.add(contentBuilder, processHandler);
        }
        contentBuilder.addAction((AnAction)new SoftExitAction(processHandler));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/impl/DefaultJavaProgramRunner";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executorId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentBuilder";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executionResult";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunnerId";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/impl/DefaultJavaProgramRunner";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "canRun";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doExecute";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addDefaultActions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static class SoftExitAction
    extends ProxyBasedAction {
        public SoftExitAction(ProcessHandler processHandler) {
            super(ExecutionBundle.message((String)"run.configuration.exit.action.name", (Object[])new Object[0]), null, AllIcons.Actions.Exit, processHandler);
        }

        @Override
        protected boolean available(ProcessProxy proxy) {
            return proxy.canSendStop();
        }

        @Override
        protected void perform(AnActionEvent e, ProcessProxy proxy) {
            this.myProcessHandler.putUserData(ProcessHandler.TERMINATION_REQUESTED, (Object)Boolean.TRUE);
            proxy.sendStop();
        }
    }

    private static class WiseDumpThreadsListener {
        private final Project myProject;
        private final ProcessHandler myProcessHandler;
        private final CapturingProcessAdapter myListener;

        WiseDumpThreadsListener(Project project2, ProcessHandler processHandler) {
            this.myProject = project2;
            this.myProcessHandler = processHandler;
            this.myListener = new CapturingProcessAdapter();
            this.myProcessHandler.addProcessListener((ProcessListener)this.myListener);
        }

        public void after() {
            if (this.myProject == null) {
                this.myProcessHandler.removeProcessListener((ProcessListener)this.myListener);
                return;
            }
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                String stdout;
                if (this.myProcessHandler.isProcessTerminated() || this.myProcessHandler.isProcessTerminating()) {
                    return;
                }
                List threadStates = null;
                long start = System.currentTimeMillis();
                while (System.currentTimeMillis() - start < 1000L && ((threadStates = ThreadDumpParser.parse((String)(stdout = this.myListener.getOutput().getStdout()))) == null || threadStates.isEmpty())) {
                    TimeoutUtil.sleep((long)50L);
                    threadStates = null;
                }
                this.myProcessHandler.removeProcessListener((ProcessListener)this.myListener);
                if (threadStates != null && !threadStates.isEmpty()) {
                    this.showThreadDump(this.myListener.getOutput().getStdout(), threadStates);
                }
            });
        }

        private void showThreadDump(String out, List<ThreadState> states) {
            ThreadDumpConsoleFactory factory = states.size() > 1 ? new ThreadDumpConsoleFactory(this.myProject, states) : null;
            String title = "<Stacktrace> " + DateFormatUtil.formatDateTime((long)System.currentTimeMillis());
            ApplicationManager.getApplication().invokeLater(() -> this.lambda$showThreadDump$1((AnalyzeStacktraceUtil.ConsoleFactory)factory, title, out), ModalityState.NON_MODAL);
        }

        private /* synthetic */ void lambda$showThreadDump$1(AnalyzeStacktraceUtil.ConsoleFactory factory, String title, String out) {
            AnalyzeStacktraceUtil.addConsole((Project)this.myProject, (AnalyzeStacktraceUtil.ConsoleFactory)factory, (String)title, (String)out);
        }
    }

    protected static class AttachDebuggerAction
    extends DumbAwareAction {
        private final AtomicBoolean myEnabled = new AtomicBoolean();
        private final AtomicReference<XDebugSession> myAttachedSession = new AtomicReference();
        private final BaseProcessHandler myProcessHandler;
        private MessageBusConnection myConnection = null;

        public AttachDebuggerAction(BaseProcessHandler processHandler) {
            super(ExecutionBundle.message((String)"run.configuration.attach.debugger.action.name", (Object[])new Object[0]), null, AllIcons.Debugger.AttachToProcess);
            this.myProcessHandler = processHandler;
            this.myProcessHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void startNotified(@NotNull ProcessEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    JobScheduler.getScheduler().schedule(() -> myEnabled.set(JavaDebuggerAttachUtil.canAttach(OSProcessUtil.getProcessID((Process)myProcessHandler.getProcess()))), 1L, TimeUnit.SECONDS);
                }

                public void processTerminated(@NotNull ProcessEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (myConnection != null) {
                        myConnection.disconnect();
                    }
                    myProcessHandler.removeProcessListener((ProcessListener)this);
                    XDebugSession attachedSession = myAttachedSession.getAndSet(null);
                    if (attachedSession != null) {
                        attachedSession.stop();
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "event";
                    objectArray2[1] = "com/intellij/execution/impl/DefaultJavaProgramRunner$AttachDebuggerAction$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "startNotified";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "processTerminated";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }

        public void update(@NotNull AnActionEvent e) {
            Project project2;
            if (e == null) {
                AttachDebuggerAction.$$$reportNull$$$0(0);
            }
            if ((project2 = e.getProject()) != null && this.myConnection == null) {
                this.myConnection = project2.getMessageBus().connect();
                this.myConnection.subscribe(XDebuggerManager.TOPIC, (Object)new XDebuggerManagerListener(){

                    public void processStarted(@NotNull XDebugProcess debugProcess) {
                        if (debugProcess == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        this.processEvent(debugProcess, true);
                    }

                    public void processStopped(@NotNull XDebugProcess debugProcess) {
                        if (debugProcess == null) {
                            2.$$$reportNull$$$0(1);
                        }
                        this.processEvent(debugProcess, false);
                    }

                    void processEvent(@NotNull XDebugProcess debugProcess, boolean started) {
                        RemoteConnection connection;
                        if (debugProcess == null) {
                            2.$$$reportNull$$$0(2);
                        }
                        if (debugProcess instanceof JavaDebugProcess && (connection = ((JavaDebugProcess)debugProcess).getDebuggerSession().getProcess().getConnection()) instanceof PidRemoteConnection && ((PidRemoteConnection)connection).getPid().equals(String.valueOf(OSProcessUtil.getProcessID((Process)myProcessHandler.getProcess())))) {
                            myAttachedSession.set(started ? debugProcess.getSession() : null);
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        objectArray2[0] = "debugProcess";
                        objectArray2[1] = "com/intellij/execution/impl/DefaultJavaProgramRunner$AttachDebuggerAction$2";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "processStarted";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[2] = "processStopped";
                                break;
                            }
                            case 2: {
                                objectArray = objectArray2;
                                objectArray2[2] = "processEvent";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
            }
            if (this.myAttachedSession.get() != null || this.myProcessHandler.isProcessTerminated()) {
                e.getPresentation().setEnabled(false);
                return;
            }
            e.getPresentation().setEnabledAndVisible(Boolean.TRUE.equals(this.myEnabled.get()));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                AttachDebuggerAction.$$$reportNull$$$0(1);
            }
            JavaDebuggerAttachUtil.attach(OSProcessUtil.getProcessID((Process)this.myProcessHandler.getProcess()), e.getProject());
        }

        public static void add(RunContentBuilder contentBuilder, ProcessHandler processHandler) {
            if (Registry.is((String)"debugger.attach.to.process.action") && processHandler instanceof BaseProcessHandler) {
                contentBuilder.addAction((AnAction)new AttachDebuggerAction((BaseProcessHandler)processHandler));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/execution/impl/DefaultJavaProgramRunner$AttachDebuggerAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static class ControlBreakAction
    extends ProxyBasedAction {
        public ControlBreakAction(ProcessHandler processHandler) {
            super(ExecutionBundle.message((String)"run.configuration.dump.threads.action.name", (Object[])new Object[0]), null, AllIcons.Actions.Dump, processHandler);
            this.setShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(3, 128)));
        }

        @Override
        protected boolean available(ProcessProxy proxy) {
            return proxy.canSendBreak();
        }

        @Override
        protected void perform(AnActionEvent e, ProcessProxy proxy) {
            boolean wise = Boolean.getBoolean(DefaultJavaProgramRunner.ourWiseThreadDumpProperty);
            WiseDumpThreadsListener wiseListener = wise ? new WiseDumpThreadsListener(e.getProject(), this.myProcessHandler) : null;
            proxy.sendBreak();
            if (wiseListener != null) {
                wiseListener.after();
            }
        }
    }

    private static abstract class ProxyBasedAction
    extends AnAction {
        protected final ProcessHandler myProcessHandler;

        protected ProxyBasedAction(String text, String description, Icon icon, ProcessHandler processHandler) {
            super(text, description, icon);
            this.myProcessHandler = processHandler;
        }

        public final void update(@NotNull AnActionEvent event) {
            ProcessProxy proxy;
            if (event == null) {
                ProxyBasedAction.$$$reportNull$$$0(0);
            }
            boolean available = (proxy = ProcessProxyFactory.getInstance().getAttachedProxy(this.myProcessHandler)) != null && this.available(proxy);
            Presentation presentation = event.getPresentation();
            if (!available) {
                presentation.setEnabledAndVisible(false);
            } else {
                presentation.setVisible(true);
                presentation.setEnabled(!this.myProcessHandler.isProcessTerminated());
            }
        }

        public final void actionPerformed(@NotNull AnActionEvent e) {
            ProcessProxy proxy;
            if (e == null) {
                ProxyBasedAction.$$$reportNull$$$0(1);
            }
            if ((proxy = ProcessProxyFactory.getInstance().getAttachedProxy(this.myProcessHandler)) != null) {
                this.perform(e, proxy);
            }
        }

        protected abstract boolean available(ProcessProxy var1);

        protected abstract void perform(AnActionEvent var1, ProcessProxy var2);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/execution/impl/DefaultJavaProgramRunner$ProxyBasedAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

