/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.runners;

import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.OSProcessUtil;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.UnixProcessManager;
import com.intellij.execution.runners.ProcessProxy;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.ThrowableRunnable;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousServerSocketChannel;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import java.nio.channels.NetworkChannel;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

class ProcessProxyImpl
implements ProcessProxy {
    static final Key<ProcessProxyImpl> KEY = Key.create((String)"ProcessProxyImpl");
    private final AsynchronousChannelGroup myGroup;
    private final int myPort;
    private final Object myLock = new Object();
    private AsynchronousSocketChannel myConnection;
    private int myPid;

    ProcessProxyImpl(String mainClass) throws IOException {
        this.myGroup = AsynchronousChannelGroup.withFixedThreadPool(1, r -> new Thread(r, "Process Proxy: " + mainClass));
        NetworkChannel channel = AsynchronousServerSocketChannel.open(this.myGroup).bind(new InetSocketAddress("127.0.0.1", 0)).setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)true);
        this.myPort = ((InetSocketAddress)((AsynchronousServerSocketChannel)channel).getLocalAddress()).getPort();
        ((AsynchronousServerSocketChannel)channel).accept(null, new CompletionHandler<AsynchronousSocketChannel, Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void completed(AsynchronousSocketChannel channel, Void attachment) {
                Object object = ProcessProxyImpl.this.myLock;
                synchronized (object) {
                    ProcessProxyImpl.this.myConnection = channel;
                }
            }

            @Override
            public void failed(Throwable t, Void attachment) {
            }
        });
    }

    int getPortNumber() {
        return this.myPort;
    }

    public void attach(@NotNull ProcessHandler processHandler) {
        if (processHandler == null) {
            ProcessProxyImpl.$$$reportNull$$$0(0);
        }
        processHandler.putUserData(KEY, (Object)this);
        ProcessProxyImpl.execute((ThrowableRunnable<Exception>)((ThrowableRunnable)() -> {
            if (processHandler == null) {
                ProcessProxyImpl.$$$reportNull$$$0(1);
            }
            int pid = -1;
            if (SystemInfo.isUnix && processHandler instanceof BaseOSProcessHandler) {
                pid = OSProcessUtil.getProcessID((Process)((BaseOSProcessHandler)processHandler).getProcess());
            }
            Object object = this.myLock;
            synchronized (object) {
                this.myPid = pid;
            }
        }));
    }

    private void writeLine(String s) {
        ProcessProxyImpl.execute((ThrowableRunnable<Exception>)((ThrowableRunnable)() -> {
            ByteBuffer out = ByteBuffer.wrap((s + '\n').getBytes(StandardCharsets.US_ASCII));
            Object object = this.myLock;
            synchronized (object) {
                this.myConnection.write(out);
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canSendBreak() {
        if (SystemInfo.isWindows) {
            Object object = this.myLock;
            synchronized (object) {
                if (this.myConnection == null) {
                    return false;
                }
            }
            return new File(PathManager.getBinPath(), "breakgen.dll").exists();
        }
        if (SystemInfo.isUnix) {
            Object object = this.myLock;
            synchronized (object) {
                return this.myPid > 0;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canSendStop() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myConnection != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendBreak() {
        if (SystemInfo.isWindows) {
            this.writeLine("BREAK");
        } else if (SystemInfo.isUnix) {
            int pid;
            Object object = this.myLock;
            synchronized (object) {
                pid = this.myPid;
            }
            UnixProcessManager.sendSignal((int)pid, (int)3);
        }
    }

    public void sendStop() {
        this.writeLine("STOP");
    }

    public void destroy() {
        ProcessProxyImpl.execute((ThrowableRunnable<Exception>)((ThrowableRunnable)() -> {
            Object object = this.myLock;
            synchronized (object) {
                if (this.myConnection != null) {
                    this.myConnection.close();
                }
            }
        }));
        ProcessProxyImpl.execute((ThrowableRunnable<Exception>)((ThrowableRunnable)() -> {
            this.myGroup.shutdownNow();
            this.myGroup.awaitTermination(1L, TimeUnit.SECONDS);
        }));
    }

    private static void execute(ThrowableRunnable<Exception> block) {
        try {
            block.run();
        }
        catch (Exception e) {
            Logger.getInstance(ProcessProxy.class).warn((Throwable)e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "processHandler";
        objectArray2[1] = "com/intellij/execution/runners/ProcessProxyImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "attach";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$attach$1";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

