/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testDiscovery;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.annotations.SerializedName;
import com.intellij.execution.testDiscovery.TestDiscoveryProducer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.io.HttpRequests;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntellijTestDiscoveryProducer
implements TestDiscoveryProducer {
    private static final String INTELLIJ_TEST_DISCOVERY_HOST = "http://intellij-test-discovery.labs.intellij.net";

    @Override
    @NotNull
    public MultiMap<String, String> getDiscoveredTests(@NotNull Project project2, @NotNull List<Couple<String>> classesAndMethods, byte frameworkId) {
        MultiMap multiMap;
        if (project2 == null) {
            IntellijTestDiscoveryProducer.$$$reportNull$$$0(0);
        }
        if (classesAndMethods == null) {
            IntellijTestDiscoveryProducer.$$$reportNull$$$0(1);
        }
        if (!ApplicationManager.getApplication().isInternal()) {
            MultiMap multiMap2 = MultiMap.empty();
            if (multiMap2 == null) {
                IntellijTestDiscoveryProducer.$$$reportNull$$$0(2);
            }
            return multiMap2;
        }
        try {
            List bareClasses = ContainerUtil.newSmartList();
            List allTogether = ContainerUtil.newSmartList();
            classesAndMethods.forEach(couple -> {
                if (couple.second == null) {
                    bareClasses.add(couple.first);
                } else {
                    allTogether.add(couple);
                }
            });
            MultiMap result = new MultiMap();
            result.putAllValues(IntellijTestDiscoveryProducer.request(allTogether, couple -> "\"" + (String)couple.first + "." + (String)couple.second + "\"", "methods"));
            result.putAllValues(IntellijTestDiscoveryProducer.request(bareClasses, s -> "\"" + s + "\"", "classes"));
            multiMap = result;
        }
        catch (HttpRequests.HttpStatusException http) {
            LOG.debug("No tests found", (Throwable)http);
        }
        catch (IOException e) {
            LOG.debug((Throwable)e);
        }
        if (multiMap == null) {
            IntellijTestDiscoveryProducer.$$$reportNull$$$0(3);
        }
        return multiMap;
        MultiMap multiMap3 = MultiMap.empty();
        if (multiMap3 == null) {
            IntellijTestDiscoveryProducer.$$$reportNull$$$0(4);
        }
        return multiMap3;
    }

    @NotNull
    private static <T> MultiMap<String, String> request(List<T> collection, Function<? super T, String> toString, String what) throws IOException {
        if (collection.isEmpty()) {
            MultiMap multiMap = MultiMap.empty();
            if (multiMap == null) {
                IntellijTestDiscoveryProducer.$$$reportNull$$$0(5);
            }
            return multiMap;
        }
        String url = "http://intellij-test-discovery.labs.intellij.net/search/tests/by-" + what;
        LOG.debug(url);
        MultiMap multiMap = (MultiMap)HttpRequests.post((String)url, (String)"application/json").productNameAsUserAgent().gzip(true).connect(r -> {
            r.write(collection.stream().map(toString).collect(Collectors.joining(",", "[", "]")));
            TestsSearchResult search = (TestsSearchResult)new ObjectMapper().readValue(r.getInputStream(), TestsSearchResult.class);
            MultiMap result = new MultiMap();
            search.getTests().forEach((classFqn, testMethodName) -> result.putValues(classFqn, (Collection)testMethodName));
            return result;
        });
        if (multiMap == null) {
            IntellijTestDiscoveryProducer.$$$reportNull$$$0(6);
        }
        return multiMap;
    }

    @Override
    public boolean isRemote() {
        return true;
    }

    @Override
    @NotNull
    public MultiMap<String, String> getDiscoveredTestsForFiles(@NotNull Project project2, @NotNull List<String> filePaths, byte frameworkId) {
        MultiMap<String, String> multiMap;
        if (project2 == null) {
            IntellijTestDiscoveryProducer.$$$reportNull$$$0(7);
        }
        if (filePaths == null) {
            IntellijTestDiscoveryProducer.$$$reportNull$$$0(8);
        }
        try {
            multiMap = IntellijTestDiscoveryProducer.request(filePaths, s -> "\"" + s + "\"", "files");
        }
        catch (IOException e) {
            LOG.debug((Throwable)e);
            MultiMap multiMap2 = MultiMap.empty();
            if (multiMap2 == null) {
                IntellijTestDiscoveryProducer.$$$reportNull$$$0(10);
            }
            return multiMap2;
        }
        if (multiMap == null) {
            IntellijTestDiscoveryProducer.$$$reportNull$$$0(9);
        }
        return multiMap;
    }

    @Override
    @NotNull
    public List<String> getAffectedFilePaths(@NotNull Project project2, @NotNull List<String> testFqns, byte frameworkId) throws IOException {
        if (project2 == null) {
            IntellijTestDiscoveryProducer.$$$reportNull$$$0(11);
        }
        if (testFqns == null) {
            IntellijTestDiscoveryProducer.$$$reportNull$$$0(12);
        }
        String url = "http://intellij-test-discovery.labs.intellij.net/search/test/details";
        final ThrowableComputable query = () -> {
            if (testFqns == null) {
                IntellijTestDiscoveryProducer.$$$reportNull$$$0(15);
            }
            return (List)HttpRequests.post((String)url, (String)"application/json").productNameAsUserAgent().gzip(true).connect(r -> {
                if (testFqns == null) {
                    IntellijTestDiscoveryProducer.$$$reportNull$$$0(16);
                }
                r.write(testFqns.stream().map(s -> "\"" + s + "\"").collect(Collectors.joining(",", "[", "]")));
                return Arrays.stream((Object[])new ObjectMapper().readValue(r.getInputStream(), TestDetails[].class)).map(details -> ((TestDetails)details).files).flatMap(Collection::stream).collect(Collectors.toList());
            });
        };
        if (ApplicationManager.getApplication().isReadAccessAllowed()) {
            List result = (List)ProgressManager.getInstance().run((Task.WithResult)new Task.WithResult<List<String>, IOException>(project2, "Searching for Affected File Paths...", true){

                protected List<String> compute(@NotNull ProgressIndicator indicator) throws IOException {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return (List)query.compute();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/execution/testDiscovery/IntellijTestDiscoveryProducer$1", "compute"));
                }
            });
            List list = result == null ? Collections.emptyList() : result;
            if (list == null) {
                IntellijTestDiscoveryProducer.$$$reportNull$$$0(13);
            }
            return list;
        }
        List list = (List)query.compute();
        if (list == null) {
            IntellijTestDiscoveryProducer.$$$reportNull$$$0(14);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classesAndMethods";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/testDiscovery/IntellijTestDiscoveryProducer";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePaths";
                break;
            }
            case 12: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testFqns";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/testDiscovery/IntellijTestDiscoveryProducer";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDiscoveredTests";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "request";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDiscoveredTestsForFiles";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getAffectedFilePaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDiscoveredTests";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 13: 
            case 14: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getDiscoveredTestsForFiles";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getAffectedFilePaths";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getAffectedFilePaths$9";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$8";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private static class TestDetails {
        @Nullable
        private String method;
        @SerializedName(value="class")
        @JsonProperty(value="class")
        @Nullable
        private String className;
        @Nullable
        private List<String> files = ContainerUtil.newSmartList();
        @Nullable
        private String message;

        private TestDetails() {
        }

        @Nullable
        public String getMethod() {
            return this.method;
        }

        public TestDetails setMethod(String method) {
            this.method = method;
            return this;
        }

        @Nullable
        public String getClassName() {
            return this.className;
        }

        public TestDetails setClassName(String name2) {
            this.className = name2;
            return this;
        }

        @NotNull
        public List<String> getFiles() {
            if (this.files == null) {
                List<String> list = Collections.emptyList();
                if (list == null) {
                    TestDetails.$$$reportNull$$$0(0);
                }
                return list;
            }
            List<String> list = this.files;
            if (list == null) {
                TestDetails.$$$reportNull$$$0(1);
            }
            return list;
        }

        public TestDetails setFiles(@NotNull List<String> files) {
            if (files == null) {
                TestDetails.$$$reportNull$$$0(2);
            }
            this.files = files;
            return this;
        }

        @Nullable
        public String getMessage() {
            return this.message;
        }

        public TestDetails setMessage(String message) {
            this.message = message;
            return this;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/testDiscovery/IntellijTestDiscoveryProducer$TestDetails";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "files";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFiles";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/testDiscovery/IntellijTestDiscoveryProducer$TestDetails";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setFiles";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class TestsSearchResult {
        @Nullable
        private String method;
        @SerializedName(value="class")
        @JsonProperty(value="class")
        @Nullable
        private String className;
        private int found;
        @NotNull
        private Map<String, List<String>> tests = new HashMap<String, List<String>>();
        @Nullable
        private String message;

        @Nullable
        public String getMethod() {
            return this.method;
        }

        public TestsSearchResult setMethod(String method) {
            this.method = method;
            return this;
        }

        @Nullable
        public String getClassName() {
            return this.className;
        }

        public TestsSearchResult setClassName(String name2) {
            this.className = name2;
            return this;
        }

        public int getFound() {
            return this.found;
        }

        public TestsSearchResult setFound(int found2) {
            this.found = found2;
            return this;
        }

        @NotNull
        public Map<String, List<String>> getTests() {
            Map<String, List<String>> map = this.tests;
            if (map == null) {
                TestsSearchResult.$$$reportNull$$$0(0);
            }
            return map;
        }

        public TestsSearchResult setTests(@NotNull Map<String, List<String>> tests) {
            if (tests == null) {
                TestsSearchResult.$$$reportNull$$$0(1);
            }
            this.tests = tests;
            return this;
        }

        @Nullable
        public String getMessage() {
            return this.message;
        }

        public TestsSearchResult setMessage(String message) {
            this.message = message;
            return this;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/testDiscovery/IntellijTestDiscoveryProducer$TestsSearchResult";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tests";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTests";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/testDiscovery/IntellijTestDiscoveryProducer$TestsSearchResult";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setTests";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

