/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jarFinder;

import com.intellij.codeInsight.AttachSourcesProvider;
import com.intellij.jarFinder.AbstractAttachSourceProvider;
import com.intellij.jarFinder.MavenCentralSourceSearcher;
import com.intellij.jarFinder.SonatypeSourceSearcher;
import com.intellij.jarFinder.SourceSearchException;
import com.intellij.jarFinder.SourceSearcher;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.LibrarySourceRootDetectorUtil;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.HttpRequests;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InternetAttachSourceProvider
extends AbstractAttachSourceProvider {
    private static final Logger LOG = Logger.getInstance(InternetAttachSourceProvider.class);
    private static final Pattern ARTIFACT_IDENTIFIER = Pattern.compile("[A-Za-z0-9\\.\\-_]+");

    @NotNull
    public Collection<AttachSourcesProvider.AttachSourcesAction> getActions(List<LibraryOrderEntry> orderEntries, final @Nullable PsiFile psiFile) {
        final VirtualFile jar = InternetAttachSourceProvider.getJarByPsiFile(psiFile);
        if (jar == null) {
            List<AttachSourcesProvider.AttachSourcesAction> list = Collections.emptyList();
            if (list == null) {
                InternetAttachSourceProvider.$$$reportNull$$$0(0);
            }
            return list;
        }
        final String jarName = jar.getNameWithoutExtension();
        int index = jarName.lastIndexOf(45);
        if (index == -1) {
            List<AttachSourcesProvider.AttachSourcesAction> list = Collections.emptyList();
            if (list == null) {
                InternetAttachSourceProvider.$$$reportNull$$$0(1);
            }
            return list;
        }
        final String version = jarName.substring(index + 1);
        final String artifactId = jarName.substring(0, index);
        if (!ARTIFACT_IDENTIFIER.matcher(version).matches() || !ARTIFACT_IDENTIFIER.matcher(artifactId).matches()) {
            List<AttachSourcesProvider.AttachSourcesAction> list = Collections.emptyList();
            if (list == null) {
                InternetAttachSourceProvider.$$$reportNull$$$0(2);
            }
            return list;
        }
        final HashSet libraries2 = new HashSet();
        for (LibraryOrderEntry libraryOrderEntry : orderEntries) {
            ContainerUtil.addIfNotNull(libraries2, (Object)libraryOrderEntry.getLibrary());
        }
        if (libraries2.isEmpty()) {
            List<AttachSourcesProvider.AttachSourcesAction> list = Collections.emptyList();
            if (list == null) {
                InternetAttachSourceProvider.$$$reportNull$$$0(3);
            }
            return list;
        }
        final String sourceFileName = jarName + "-sources.jar";
        for (Library library : libraries2) {
            for (VirtualFile file : library.getFiles(OrderRootType.SOURCES)) {
                if (!file.getPath().contains(sourceFileName) || !InternetAttachSourceProvider.isRootInExistingFile(file)) continue;
                List<AttachSourcesProvider.AttachSourcesAction> list = Collections.emptyList();
                if (list == null) {
                    InternetAttachSourceProvider.$$$reportNull$$$0(4);
                }
                return list;
            }
        }
        final File file = InternetAttachSourceProvider.getLibrarySourceDir();
        final File sourceFile = new File(file, sourceFileName);
        if (sourceFile.exists()) {
            Set<1> set = Collections.singleton(new AttachSourcesProvider.LightAttachSourcesAction(){

                public String getName() {
                    return "Attach downloaded source";
                }

                public String getBusyText() {
                    return this.getName();
                }

                public ActionCallback perform(List<LibraryOrderEntry> orderEntriesContainingFile) {
                    InternetAttachSourceProvider.attachSourceJar(sourceFile, libraries2);
                    return ActionCallback.DONE;
                }
            });
            if (set == null) {
                InternetAttachSourceProvider.$$$reportNull$$$0(5);
            }
            return set;
        }
        Set<2> set = Collections.singleton(new AttachSourcesProvider.LightAttachSourcesAction(){

            public String getName() {
                return "Download...";
            }

            public String getBusyText() {
                return "Searching...";
            }

            public ActionCallback perform(List<LibraryOrderEntry> orderEntriesContainingFile) {
                Task.Modal task = new Task.Modal(psiFile.getProject(), "Searching source...", true){

                    public void run(@NotNull ProgressIndicator indicator) {
                        SourceSearcher[] searchers;
                        if (indicator == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        String artifactUrl = null;
                        for (SourceSearcher searcher : searchers = new SourceSearcher[]{new MavenCentralSourceSearcher(), new SonatypeSourceSearcher()}) {
                            try {
                                artifactUrl = searcher.findSourceJar(indicator, artifactId, version, jar);
                            }
                            catch (SourceSearchException e) {
                                LOG.warn((Throwable)e);
                                this.showMessage("Downloading failed", e.getMessage(), NotificationType.ERROR);
                                continue;
                            }
                            if (artifactUrl != null) break;
                        }
                        if (artifactUrl == null) {
                            this.showMessage("Sources not found", "Sources for '" + jarName + ".jar' not found", NotificationType.WARNING);
                            return;
                        }
                        if (!file.isDirectory() && !file.mkdirs()) {
                            this.showMessage("Downloading failed", "Failed to create directory to store sources: " + file, NotificationType.ERROR);
                            return;
                        }
                        try {
                            File tmpDownload = FileUtil.createTempFile((File)file, (String)"download.", (String)".tmp", (boolean)false, (boolean)false);
                            HttpRequests.request((String)artifactUrl).saveToFile(tmpDownload, indicator);
                            if (!sourceFile.exists() && !tmpDownload.renameTo(sourceFile)) {
                                LOG.warn("Failed to rename file " + tmpDownload + " to " + sourceFileName);
                            }
                        }
                        catch (IOException e) {
                            LOG.warn((Throwable)e);
                            this.showMessage("Downloading failed", "Connection problem. See log for more details.", NotificationType.ERROR);
                        }
                    }

                    public void onSuccess() {
                        InternetAttachSourceProvider.attachSourceJar(sourceFile, libraries2);
                    }

                    private void showMessage(String title, String message, NotificationType notificationType) {
                        new Notification("Source searcher", title, message, notificationType).notify(this.getProject());
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/jarFinder/InternetAttachSourceProvider$2$1", "run"));
                    }
                };
                task.queue();
                return ActionCallback.DONE;
            }
        });
        if (set == null) {
            InternetAttachSourceProvider.$$$reportNull$$$0(6);
        }
        return set;
    }

    private static boolean isRootInExistingFile(VirtualFile root) {
        VirtualFile jar;
        return !(root.getFileSystem() instanceof JarFileSystem) || (jar = JarFileSystem.getInstance().getVirtualFileForJar(root)) != null && VfsUtilCore.virtualToIoFile((VirtualFile)jar).exists();
    }

    public static void attachSourceJar(@NotNull File sourceJar, @NotNull Collection<Library> libraries2) {
        VirtualFile srcFile;
        if (sourceJar == null) {
            InternetAttachSourceProvider.$$$reportNull$$$0(7);
        }
        if (libraries2 == null) {
            InternetAttachSourceProvider.$$$reportNull$$$0(8);
        }
        if ((srcFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(sourceJar)) == null) {
            return;
        }
        VirtualFile jarRoot = JarFileSystem.getInstance().getJarRootForLocalFile(srcFile);
        if (jarRoot == null) {
            return;
        }
        VirtualFile[] roots = LibrarySourceRootDetectorUtil.scanAndSelectDetectedJavaSourceRoots(null, new VirtualFile[]{jarRoot});
        if (roots.length == 0) {
            roots = new VirtualFile[]{jarRoot};
        }
        InternetAttachSourceProvider.doAttachSourceJars(libraries2, roots);
    }

    private static void doAttachSourceJars(@NotNull Collection<Library> libraries2, VirtualFile[] roots) {
        if (libraries2 == null) {
            InternetAttachSourceProvider.$$$reportNull$$$0(9);
        }
        WriteAction.run(() -> {
            if (libraries2 == null) {
                InternetAttachSourceProvider.$$$reportNull$$$0(10);
            }
            for (Library library : libraries2) {
                Library.ModifiableModel model = library.getModifiableModel();
                HashSet alreadyExistingFiles = ContainerUtil.newHashSet((Object[])model.getFiles(OrderRootType.SOURCES));
                for (VirtualFile root : roots) {
                    if (alreadyExistingFiles.contains(root)) continue;
                    model.addRoot(root, OrderRootType.SOURCES);
                }
                model.commit();
            }
        });
    }

    public static File getLibrarySourceDir() {
        String path = System.getProperty("idea.library.source.dir");
        return path != null ? new File(path) : new File(SystemProperties.getUserHome(), ".ideaLibSources");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jarFinder/InternetAttachSourceProvider";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceJar";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraries";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActions";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jarFinder/InternetAttachSourceProvider";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "attachSourceJar";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "doAttachSourceJars";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "lambda$doAttachSourceJars$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

