/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.execution;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemJavaUtil;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemJdkException;
import com.intellij.openapi.externalSystem.service.execution.InvalidJavaHomeException;
import com.intellij.openapi.externalSystem.service.execution.InvalidSdkException;
import com.intellij.openapi.externalSystem.service.execution.ProjectJdkNotFoundException;
import com.intellij.openapi.externalSystem.service.execution.UndefinedJavaHomeException;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.SimpleJavaSdkType;
import com.intellij.openapi.projectRoots.impl.SdkConfigurationUtil;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.SystemProperties;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemJdkUtil {
    public static final String USE_INTERNAL_JAVA = "#JAVA_INTERNAL";
    public static final String USE_PROJECT_JDK = "#USE_PROJECT_JDK";
    public static final String USE_JAVA_HOME = "#JAVA_HOME";

    @Nullable
    public static Sdk getJdk(@Nullable Project project2, @Nullable String jdkName) throws ExternalSystemJdkException {
        if (jdkName == null) {
            return null;
        }
        if (USE_INTERNAL_JAVA.equals(jdkName)) {
            return ExternalSystemJdkUtil.getInternalJdk();
        }
        if (USE_PROJECT_JDK.equals(jdkName)) {
            if (project2 != null) {
                Module[] modules;
                Sdk res = ProjectRootManager.getInstance((Project)project2).getProjectSdk();
                if (res != null) {
                    return res;
                }
                for (Module module2 : modules = ModuleManager.getInstance((Project)project2).getModules()) {
                    Sdk sdk = ModuleRootManager.getInstance((Module)module2).getSdk();
                    if (sdk == null || !(sdk.getSdkType() instanceof JavaSdkType)) continue;
                    return sdk;
                }
            }
            if (project2 == null || project2.isDefault()) {
                SdkType javaSdk = ExternalSystemJdkUtil.getJavaSdk();
                Sdk recent = javaSdk == null ? null : ProjectJdkTable.getInstance().findMostRecentSdkOfType((SdkTypeId)javaSdk);
                return recent != null ? recent : ExternalSystemJdkUtil.getInternalJdk();
            }
            throw new ProjectJdkNotFoundException();
        }
        if (USE_JAVA_HOME.equals(jdkName)) {
            String javaHome = (String)EnvironmentUtil.getEnvironmentMap().get("JAVA_HOME");
            if (StringUtil.isEmptyOrSpaces((String)javaHome)) {
                throw new UndefinedJavaHomeException();
            }
            if (!ExternalSystemJdkUtil.isValidJdk(javaHome)) {
                throw new InvalidJavaHomeException(javaHome);
            }
            SimpleJavaSdkType sdkType = SimpleJavaSdkType.getInstance();
            String sdkName = sdkType.suggestSdkName(null, javaHome);
            return sdkType.createJdk(sdkName, javaHome);
        }
        Sdk projectJdk = ProjectJdkTable.getInstance().findJdk(jdkName);
        if (projectJdk != null) {
            String homePath = projectJdk.getHomePath();
            if (!ExternalSystemJdkUtil.isValidJdk(homePath)) {
                throw new InvalidSdkException(homePath);
            }
            return projectJdk;
        }
        return null;
    }

    @NotNull
    public static Pair<String, Sdk> getAvailableJdk(@Nullable Project project2) throws ExternalSystemJdkException {
        String javaHome;
        Stream<Sdk> projectSdks;
        Sdk projectSdk;
        SdkType javaSdkType = ExternalSystemJdkUtil.getJavaSdkType();
        if (project2 != null && (projectSdk = (Sdk)(projectSdks = Stream.concat(Stream.of(ProjectRootManager.getInstance((Project)project2).getProjectSdk()), Stream.of(ModuleManager.getInstance((Project)project2).getModules()).map(module2 -> ModuleRootManager.getInstance((Module)module2).getSdk()))).filter(sdk -> sdk != null && sdk.getSdkType() == javaSdkType && ExternalSystemJdkUtil.isValidJdk(sdk.getHomePath())).findFirst().orElse(null)) != null) {
            Pair pair2 = Pair.pair((Object)USE_PROJECT_JDK, (Object)projectSdk);
            if (pair2 == null) {
                ExternalSystemJdkUtil.$$$reportNull$$$0(0);
            }
            return pair2;
        }
        List allJdks = ProjectJdkTable.getInstance().getSdksOfType((SdkTypeId)javaSdkType);
        Sdk mostRecentSdk = allJdks.stream().filter(sdk -> ExternalSystemJdkUtil.isValidJdk(sdk.getHomePath())).max(javaSdkType.versionComparator()).orElse(null);
        if (mostRecentSdk != null) {
            Pair pair3 = Pair.pair((Object)mostRecentSdk.getName(), (Object)mostRecentSdk);
            if (pair3 == null) {
                ExternalSystemJdkUtil.$$$reportNull$$$0(1);
            }
            return pair3;
        }
        if (!ApplicationManager.getApplication().isUnitTestMode() && ExternalSystemJdkUtil.isValidJdk(javaHome = (String)EnvironmentUtil.getEnvironmentMap().get("JAVA_HOME"))) {
            SimpleJavaSdkType simpleJavaSdkType = SimpleJavaSdkType.getInstance();
            String sdkName = simpleJavaSdkType.suggestSdkName(null, javaHome);
            Pair pair4 = Pair.pair((Object)USE_JAVA_HOME, (Object)simpleJavaSdkType.createJdk(sdkName, javaHome));
            if (pair4 == null) {
                ExternalSystemJdkUtil.$$$reportNull$$$0(2);
            }
            return pair4;
        }
        Pair pair5 = Pair.pair((Object)USE_INTERNAL_JAVA, (Object)ExternalSystemJdkUtil.getInternalJdk());
        if (pair5 == null) {
            ExternalSystemJdkUtil.$$$reportNull$$$0(3);
        }
        return pair5;
    }

    @NotNull
    public static Collection<String> suggestJdkHomePaths() {
        Collection collection = ExternalSystemJdkUtil.getJavaSdkType().suggestHomePaths();
        if (collection == null) {
            ExternalSystemJdkUtil.$$$reportNull$$$0(4);
        }
        return collection;
    }

    @NotNull
    public static SdkType getJavaSdkType() {
        SdkType javaSdk = ExternalSystemJdkUtil.getJavaSdk();
        Object object = javaSdk == null ? SimpleJavaSdkType.getInstance() : javaSdk;
        if (object == null) {
            ExternalSystemJdkUtil.$$$reportNull$$$0(5);
        }
        return object;
    }

    @Deprecated
    public static boolean checkForJdk(@NotNull Project project2, @Nullable String jdkName) {
        if (project2 == null) {
            ExternalSystemJdkUtil.$$$reportNull$$$0(6);
        }
        try {
            Sdk sdk = ExternalSystemJdkUtil.getJdk(project2, jdkName);
            return sdk != null && sdk.getHomePath() != null && JdkUtil.checkForJdk((String)sdk.getHomePath());
        }
        catch (ExternalSystemJdkException externalSystemJdkException) {
            return false;
        }
    }

    public static boolean isValidJdk(@Nullable String homePath) {
        return !StringUtil.isEmptyOrSpaces((String)homePath) && JdkUtil.checkForJdk((String)homePath) && JdkUtil.checkForJre((String)homePath);
    }

    @NotNull
    public static Sdk addJdk(String homePath) {
        Sdk jdk;
        if (ExternalSystemJdkUtil.isJavaSdkPresent() && (jdk = ExternalSystemJavaUtil.tryAddJdk(homePath)) != null) {
            Sdk sdk = jdk;
            if (sdk == null) {
                ExternalSystemJdkUtil.$$$reportNull$$$0(7);
            }
            return sdk;
        }
        SimpleJavaSdkType simpleJavaSdkType = SimpleJavaSdkType.getInstance();
        jdk = simpleJavaSdkType.createJdk(simpleJavaSdkType.suggestSdkName(null, homePath), homePath);
        SdkConfigurationUtil.addSdk((Sdk)jdk);
        Sdk sdk = jdk;
        if (sdk == null) {
            ExternalSystemJdkUtil.$$$reportNull$$$0(8);
        }
        return sdk;
    }

    @Nullable
    private static SdkType getJavaSdk() {
        if (ExternalSystemJdkUtil.isJavaSdkPresent()) {
            return ExternalSystemJavaUtil.getJavaSdk();
        }
        return null;
    }

    @NotNull
    private static Sdk getInternalJdk() {
        Sdk internalJdk;
        if (ExternalSystemJdkUtil.isJavaSdkPresent() && (internalJdk = ExternalSystemJavaUtil.getInternalJdk()) != null) {
            Sdk sdk = internalJdk;
            if (sdk == null) {
                ExternalSystemJdkUtil.$$$reportNull$$$0(9);
            }
            return sdk;
        }
        String jdkHome = SystemProperties.getJavaHome();
        SimpleJavaSdkType simpleJavaSdkType = SimpleJavaSdkType.getInstance();
        Sdk sdk = simpleJavaSdkType.createJdk(simpleJavaSdkType.suggestSdkName(null, jdkHome), jdkHome);
        if (sdk == null) {
            ExternalSystemJdkUtil.$$$reportNull$$$0(10);
        }
        return sdk;
    }

    private static boolean isJavaSdkPresent() {
        try {
            Class.forName("com.intellij.openapi.projectRoots.impl.JavaSdkImpl");
            return true;
        }
        catch (Throwable ignore) {
            return false;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/execution/ExternalSystemJdkUtil";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableJdk";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestJdkHomePaths";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getJavaSdkType";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/execution/ExternalSystemJdkUtil";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "addJdk";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getInternalJdk";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkForJdk";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

