/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ModuleDependencyData;
import com.intellij.openapi.externalSystem.model.project.OrderAware;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractDependencyDataService;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ExportableOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.impl.ModuleOrderEntryImpl;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

@Order(value=-2147483618)
public class ModuleDependencyDataService
extends AbstractDependencyDataService<ModuleDependencyData, ModuleOrderEntry> {
    private static final Logger LOG = Logger.getInstance(ModuleDependencyDataService.class);

    @NotNull
    public Key<ModuleDependencyData> getTargetDataKey() {
        Key key = ProjectKeys.MODULE_DEPENDENCY;
        if (key == null) {
            ModuleDependencyDataService.$$$reportNull$$$0(0);
        }
        return key;
    }

    @Override
    @NotNull
    public Class<ModuleOrderEntry> getOrderEntryType() {
        if (ModuleOrderEntry.class == null) {
            ModuleDependencyDataService.$$$reportNull$$$0(1);
        }
        return ModuleOrderEntry.class;
    }

    @Override
    protected String getOrderEntryName(@NotNull IdeModifiableModelsProvider modelsProvider, @NotNull ModuleOrderEntry orderEntry) {
        if (modelsProvider == null) {
            ModuleDependencyDataService.$$$reportNull$$$0(2);
        }
        if (orderEntry == null) {
            ModuleDependencyDataService.$$$reportNull$$$0(3);
        }
        String moduleName = orderEntry.getModuleName();
        Module orderEntryModule = orderEntry.getModule();
        if (orderEntryModule != null) {
            moduleName = modelsProvider.getModifiableModuleModel().getActualName(orderEntryModule);
        }
        return moduleName;
    }

    @Override
    protected Map<OrderEntry, OrderAware> importData(@NotNull Collection<DataNode<ModuleDependencyData>> toImport, @NotNull Module module2, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (toImport == null) {
            ModuleDependencyDataService.$$$reportNull$$$0(4);
        }
        if (module2 == null) {
            ModuleDependencyDataService.$$$reportNull$$$0(5);
        }
        if (modelsProvider == null) {
            ModuleDependencyDataService.$$$reportNull$$$0(6);
        }
        HashMap toRemove = ContainerUtilRt.newHashMap();
        LinkedHashMap orderEntryDataMap = ContainerUtil.newLinkedHashMap();
        for (OrderEntry entry : modelsProvider.getOrderEntries(module2)) {
            if (!(entry instanceof ModuleOrderEntry)) continue;
            ModuleOrderEntry e = (ModuleOrderEntry)entry;
            toRemove.put(Pair.create((Object)e.getModuleName(), (Object)e.getScope()), e);
        }
        HashSet processed = ContainerUtil.newHashSet();
        ModifiableRootModel modifiableRootModel = modelsProvider.getModifiableRootModel(module2);
        for (DataNode<ModuleDependencyData> dependencyNode : toImport) {
            ModuleOrderEntry orderEntry;
            ModuleDependencyData dependencyData = (ModuleDependencyData)dependencyNode.getData();
            if (processed.contains(dependencyData)) continue;
            processed.add(dependencyData);
            toRemove.remove(Pair.create((Object)dependencyData.getInternalName(), (Object)dependencyData.getScope()));
            ModuleData moduleData = (ModuleData)dependencyData.getTarget();
            Module ideDependencyModule = modelsProvider.findIdeModule(moduleData);
            if (module2.equals(ideDependencyModule)) continue;
            if (ideDependencyModule == null) {
                LOG.warn(String.format("Can't import module dependency for '%s' module. Reason: target module (%s) is not found at the ide", module2.getName(), dependencyData));
            }
            if ((orderEntry = modelsProvider.findIdeModuleDependency(dependencyData, module2)) == null) {
                orderEntry = (ModuleOrderEntry)ReadAction.compute(() -> ideDependencyModule == null ? modifiableRootModel.addInvalidModuleEntry(moduleData.getInternalName()) : modifiableRootModel.addModuleOrderEntry(ideDependencyModule));
            }
            orderEntry.setScope(dependencyData.getScope());
            orderEntry.setExported(dependencyData.isExported());
            boolean productionOnTestDependency = dependencyData.isProductionOnTestDependency();
            if (orderEntry instanceof ModuleOrderEntryImpl) {
                ((ModuleOrderEntryImpl)orderEntry).setProductionOnTestDependency(productionOnTestDependency);
            } else if (productionOnTestDependency) {
                LOG.warn("Unable to set productionOnTestDependency for entry: " + orderEntry);
            }
            orderEntryDataMap.put(orderEntry, dependencyData);
        }
        if (!toRemove.isEmpty()) {
            this.removeData(toRemove.values(), module2, modelsProvider);
        }
        return orderEntryDataMap;
    }

    @Override
    protected void removeData(@NotNull Collection<? extends ExportableOrderEntry> toRemove, @NotNull Module module2, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (toRemove == null) {
            ModuleDependencyDataService.$$$reportNull$$$0(7);
        }
        if (module2 == null) {
            ModuleDependencyDataService.$$$reportNull$$$0(8);
        }
        if (modelsProvider == null) {
            ModuleDependencyDataService.$$$reportNull$$$0(9);
        }
        List filteredList = ContainerUtil.filter(toRemove, o -> {
            if (module2 == null) {
                ModuleDependencyDataService.$$$reportNull$$$0(10);
            }
            if (o instanceof ModuleOrderEntry) {
                String moduleName = ((ModuleOrderEntry)o).getModuleName();
                return ModuleManager.getInstance((Project)module2.getProject()).getUnloadedModuleDescription(moduleName) == null;
            }
            return true;
        });
        super.removeData(filteredList, module2, modelsProvider);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/project/manage/ModuleDependencyDataService";
                break;
            }
            case 2: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelsProvider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orderEntry";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toImport";
                break;
            }
            case 5: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toRemove";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetDataKey";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrderEntryType";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/manage/ModuleDependencyDataService";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getOrderEntryName";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "importData";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "removeData";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "lambda$removeData$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

