/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.artifacts.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactEditorEx;
import com.intellij.openapi.roots.ui.configuration.artifacts.LayoutTreeComponent;
import com.intellij.openapi.roots.ui.configuration.artifacts.LayoutTreeSelection;
import com.intellij.openapi.roots.ui.configuration.artifacts.actions.LayoutTreeActionBase;
import com.intellij.openapi.roots.ui.configuration.artifacts.nodes.CompositePackagingElementNode;
import com.intellij.openapi.roots.ui.configuration.artifacts.nodes.PackagingElementNode;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.CompositePackagingElementType;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementFactory;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class SurroundElementWithAction
extends LayoutTreeActionBase {
    public SurroundElementWithAction(ArtifactEditorEx artifactEditor) {
        super("Surround With...", artifactEditor);
        this.registerCustomShortcutSet(KeymapUtil.getActiveKeymapShortcuts((String)"SurroundWith"), (JComponent)((Object)artifactEditor.getLayoutTreeComponent().getLayoutTree()));
    }

    @Override
    protected boolean isEnabled() {
        return this.myArtifactEditor.getLayoutTreeComponent().getSelection().getCommonParentElement() != null;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        LayoutTreeComponent treeComponent;
        LayoutTreeSelection selection;
        CompositePackagingElement<?> parent;
        if (e == null) {
            SurroundElementWithAction.$$$reportNull$$$0(0);
        }
        if ((parent = (selection = (treeComponent = this.myArtifactEditor.getLayoutTreeComponent()).getSelection()).getCommonParentElement()) == null) {
            return;
        }
        CompositePackagingElementNode parentNode = selection.getNodes().get(0).getParentNode();
        if (parentNode == null) {
            return;
        }
        if (!treeComponent.checkCanModifyChildren((PackagingElement<?>)parent, parentNode, (Collection<? extends PackagingElementNode<?>>)selection.getNodes())) {
            return;
        }
        CompositePackagingElementType[] types = PackagingElementFactory.getInstance().getCompositeElementTypes();
        final List<PackagingElement<?>> selected = selection.getElements();
        if (types.length == 1) {
            this.surroundWith(types[0], parent, selected, treeComponent);
        } else {
            JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<CompositePackagingElementType>("Surround With...", types){

                public Icon getIconFor(CompositePackagingElementType aValue) {
                    return aValue.getCreateElementIcon();
                }

                @NotNull
                public String getTextFor(CompositePackagingElementType value) {
                    String string = value.getPresentableName();
                    if (string == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return string;
                }

                public PopupStep onChosen(CompositePackagingElementType selectedValue, boolean finalChoice) {
                    return this.doFinalStep(() -> SurroundElementWithAction.this.surroundWith(selectedValue, parent, selected, treeComponent));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/artifacts/actions/SurroundElementWithAction$1", "getTextFor"));
                }
            }).showInBestPositionFor(e.getDataContext());
        }
    }

    private void surroundWith(CompositePackagingElementType<?> type, CompositePackagingElement<?> parent, List<PackagingElement<?>> selected, LayoutTreeComponent treeComponent) {
        if (this.myArtifactEditor.isDisposed() || selected.isEmpty()) {
            return;
        }
        Project project2 = this.myArtifactEditor.getContext().getProject();
        String elementName = ((PackagingElement)ContainerUtil.getFirstItem(selected, null)).createPresentation(this.myArtifactEditor.getContext()).getPresentableName();
        String baseName = PathUtil.suggestFileName((String)elementName);
        CompositePackagingElement newParent = type.createComposite(parent, baseName, this.myArtifactEditor.getContext());
        if (newParent != null) {
            treeComponent.editLayout(() -> {
                for (PackagingElement element : selected) {
                    newParent.addOrFindChild(ArtifactUtil.copyWithChildren(element, project2));
                }
                for (PackagingElement element : selected) {
                    parent.removeChild(element);
                }
                parent.addOrFindChild((PackagingElement)newParent);
            });
            treeComponent.rebuildTree();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/roots/ui/configuration/artifacts/actions/SurroundElementWithAction", "actionPerformed"));
    }
}

