/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.libraryEditor;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.impl.ModuleLibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.ui.configuration.libraries.LibraryEditingUtil;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryRootsComponent;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ui.FormBuilder;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JTextField;
import org.jetbrains.annotations.Nullable;

public abstract class LibraryEditorDialogBase
extends DialogWrapper {
    protected JTextField myNameField;
    private final LibraryRootsComponent myLibraryRootsComponent;

    public LibraryEditorDialogBase(Component parent, LibraryRootsComponent libraryRootsComponent) {
        super(parent, true);
        this.myLibraryRootsComponent = libraryRootsComponent;
        libraryRootsComponent.resetProperties();
        this.setTitle(ProjectBundle.message((String)"library.configure.title", (Object[])new Object[0]));
        Disposer.register((Disposable)this.getDisposable(), (Disposable)this.myLibraryRootsComponent);
    }

    public void setContextModule(Module module2) {
        this.myLibraryRootsComponent.setContextModule(module2);
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditorDialog";
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myNameField;
    }

    protected final void doOKAction() {
        if (!this.validateAndApply()) {
            return;
        }
        super.doOKAction();
    }

    protected boolean validateAndApply() {
        String newName = this.myNameField.getText().trim();
        if (newName.length() == 0) {
            newName = null;
        }
        if (this.shouldCheckName(newName)) {
            LibraryTable.ModifiableModel tableModifiableModel = this.getTableModifiableModel();
            if (tableModifiableModel != null && !(tableModifiableModel instanceof ModuleLibraryTable)) {
                if (newName == null) {
                    Messages.showErrorDialog((String)ProjectBundle.message((String)"library.name.not.specified.error", (Object[])new Object[]{newName}), (String)ProjectBundle.message((String)"library.name.not.specified.title", (Object[])new Object[0]));
                    return false;
                }
                if (LibraryEditingUtil.libraryAlreadyExists(tableModifiableModel, newName)) {
                    Messages.showErrorDialog((String)ProjectBundle.message((String)"library.name.already.exists.error", (Object[])new Object[]{newName}), (String)ProjectBundle.message((String)"library.name.already.exists.title", (Object[])new Object[0]));
                    return false;
                }
            }
            this.myLibraryRootsComponent.renameLibrary(newName);
        }
        this.myLibraryRootsComponent.applyProperties();
        return true;
    }

    protected abstract boolean shouldCheckName(String var1);

    @Nullable
    protected LibraryTable.ModifiableModel getTableModifiableModel() {
        return null;
    }

    protected LibraryRootsComponent getLibraryRootsComponent() {
        return this.myLibraryRootsComponent;
    }

    protected JComponent createNorthPanel() {
        String currentName = this.myLibraryRootsComponent.getLibraryEditor().getName();
        this.myNameField = new JTextField(currentName);
        this.myNameField.selectAll();
        FormBuilder formBuilder = FormBuilder.createFormBuilder().addLabeledComponent("&Name:", (JComponent)this.myNameField);
        this.addNorthComponents(formBuilder);
        return formBuilder.addVerticalGap(10).getPanel();
    }

    protected void addNorthComponents(FormBuilder formBuilder) {
    }

    protected JComponent createCenterPanel() {
        return this.myLibraryRootsComponent.getComponent();
    }
}

