/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.elements;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetTypeId;
import com.intellij.facet.FacetTypeRegistry;
import com.intellij.ide.util.ChooseElementsDialog;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementType;
import com.intellij.packaging.ui.ArtifactEditorContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class FacetBasedPackagingElementType<E extends PackagingElement<?>, F extends Facet>
extends PackagingElementType<E> {
    private final FacetTypeId<F> myFacetType;

    protected FacetBasedPackagingElementType(@NotNull @NonNls String id, @NotNull String presentableName, FacetTypeId<F> facetType) {
        if (id == null) {
            FacetBasedPackagingElementType.$$$reportNull$$$0(0);
        }
        if (presentableName == null) {
            FacetBasedPackagingElementType.$$$reportNull$$$0(1);
        }
        super(id, presentableName);
        this.myFacetType = facetType;
    }

    public boolean canCreate(@NotNull ArtifactEditorContext context, @NotNull Artifact artifact) {
        if (context == null) {
            FacetBasedPackagingElementType.$$$reportNull$$$0(2);
        }
        if (artifact == null) {
            FacetBasedPackagingElementType.$$$reportNull$$$0(3);
        }
        return !this.getFacets(context).isEmpty();
    }

    public Icon getCreateElementIcon() {
        return FacetTypeRegistry.getInstance().findFacetType(this.myFacetType).getIcon();
    }

    @NotNull
    public List<? extends E> chooseAndCreate(@NotNull ArtifactEditorContext context, @NotNull Artifact artifact, @NotNull CompositePackagingElement<?> parent) {
        if (context == null) {
            FacetBasedPackagingElementType.$$$reportNull$$$0(4);
        }
        if (artifact == null) {
            FacetBasedPackagingElementType.$$$reportNull$$$0(5);
        }
        if (parent == null) {
            FacetBasedPackagingElementType.$$$reportNull$$$0(6);
        }
        List<F> facets = this.getFacets(context);
        ChooseFacetsDialog dialog = new ChooseFacetsDialog(context.getProject(), facets, this.getDialogTitle(), this.getDialogDescription());
        if (dialog.showAndGet()) {
            ArrayList<E> elements = new ArrayList<E>();
            for (Facet facet : dialog.getChosenElements()) {
                elements.add(this.createElement(context.getProject(), facet));
            }
            ArrayList<E> arrayList = elements;
            if (arrayList == null) {
                FacetBasedPackagingElementType.$$$reportNull$$$0(7);
            }
            return arrayList;
        }
        List list = Collections.emptyList();
        if (list == null) {
            FacetBasedPackagingElementType.$$$reportNull$$$0(8);
        }
        return list;
    }

    private List<F> getFacets(ArtifactEditorContext context) {
        Module[] modules = context.getModulesProvider().getModules();
        ArrayList facets = new ArrayList();
        for (Module module2 : modules) {
            facets.addAll(context.getFacetsProvider().getFacetsByType(module2, this.myFacetType));
        }
        return facets;
    }

    protected abstract E createElement(Project var1, F var2);

    protected abstract String getDialogTitle();

    protected abstract String getDialogDescription();

    protected abstract String getItemText(F var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentableName";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/packaging/impl/elements/FacetBasedPackagingElementType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/packaging/impl/elements/FacetBasedPackagingElementType";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "chooseAndCreate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "canCreate";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "chooseAndCreate";
                break;
            }
            case 7: 
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class ChooseFacetsDialog
    extends ChooseElementsDialog<F> {
        private ChooseFacetsDialog(Project project2, List<? extends F> items, String title, String description) {
            super(project2, items, title, description, true);
        }

        protected String getItemText(F item) {
            return FacetBasedPackagingElementType.this.getItemText(item);
        }

        protected Icon getItemIcon(F item) {
            return FacetTypeRegistry.getInstance().findFacetType(FacetBasedPackagingElementType.this.myFacetType).getIcon();
        }
    }
}

