/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration.rules;

import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.typeMigration.TypeConversionDescriptor;
import com.intellij.refactoring.typeMigration.TypeConversionDescriptorBase;
import com.intellij.refactoring.typeMigration.TypeMigrationLabeler;
import com.intellij.refactoring.typeMigration.rules.TypeConversionRule;

public class BoxingTypeConversionRule
extends TypeConversionRule {
    public TypeConversionDescriptorBase findConversion(PsiType from, PsiType to, PsiMember member, PsiExpression context, TypeMigrationLabeler labeler) {
        String boxedTypeName;
        if (to instanceof PsiClassType && from instanceof PsiPrimitiveType) {
            String boxedTypeName2;
            if (!PsiUtil.isLanguageLevel5OrHigher((PsiElement)context) && Comparing.strEqual((String)(boxedTypeName2 = ((PsiPrimitiveType)from).getBoxedTypeName()), (String)to.getCanonicalText())) {
                return new TypeConversionDescriptor("$qualifier$", boxedTypeName2 + ".valueOf($qualifier$)");
            }
        } else if (from instanceof PsiClassType && to instanceof PsiPrimitiveType && !PsiUtil.isLanguageLevel5OrHigher((PsiElement)context) && Comparing.strEqual((String)(boxedTypeName = ((PsiPrimitiveType)to).getBoxedTypeName()), (String)from.getCanonicalText())) {
            return new TypeConversionDescriptor("$qualifier$", "($qualifier$)." + to.getCanonicalText() + "Value()");
        }
        return null;
    }
}

