/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher.compiler;

import com.intellij.dupLocator.util.NodeFilter;
import com.intellij.psi.PsiElement;
import com.intellij.structuralsearch.MalformedPatternException;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.impl.matcher.compiler.CompileContext;
import com.intellij.structuralsearch.impl.matcher.filters.CompositeFilter;
import com.intellij.structuralsearch.impl.matcher.filters.LexicalNodesFilter;
import com.intellij.structuralsearch.impl.matcher.handlers.LiteralWithSubstitutionHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.MatchingHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.SubstitutionHandler;
import com.intellij.structuralsearch.impl.matcher.predicates.RegExpPredicate;
import com.intellij.util.SmartList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class GlobalCompilingVisitor {
    @NonNls
    private static final String SUBSTITUTION_PATTERN_STR = "\\b(__\\$_\\w+)\\b";
    private static final Pattern ourSubstitutionPattern = Pattern.compile("\\b(__\\$_\\w+)\\b");
    private static final Set<String> ourReservedWords = new HashSet<String>(Arrays.asList("Modifier", "Instance"));
    private static final Pattern ourAlternativePattern;
    @NonNls
    private static final String WORD_SEARCH_PATTERN_STR = ".*?\\b(.+?)\\b.*?";
    static final Pattern ourWordSearchPattern;
    private CompileContext context;
    private final List<PsiElement> myLexicalNodes = new SmartList();
    private int myCodeBlockLevel;
    private static final NodeFilter ourFilter;

    public static NodeFilter getFilter() {
        return ourFilter;
    }

    public void setHandler(PsiElement element, MatchingHandler handler) {
        MatchingHandler realHandler = this.context.getPattern().getHandlerSimple(element);
        if (realHandler instanceof SubstitutionHandler) {
            ((SubstitutionHandler)realHandler).setMatchHandler(handler);
        } else {
            this.context.getPattern().setHandler(element, handler);
        }
    }

    public final void handle(PsiElement element) {
        if ((!ourFilter.accepts(element) || StructuralSearchUtil.isIdentifier(element)) && this.context.getPattern().isRealTypedVar(element) && this.context.getPattern().getHandlerSimple(element) == null) {
            String name2 = this.context.getPattern().getTypedVarString(element);
            SubstitutionHandler handler = (SubstitutionHandler)this.context.getPattern().getHandler(name2);
            if (handler == null) {
                return;
            }
            this.context.getPattern().setHandler(element, handler);
            if (this.context.getOptions().getVariableConstraint(handler.getName()).isPartOfSearchResults()) {
                handler.setTarget(true);
                this.context.getPattern().setTargetNode(element);
            }
        }
    }

    public CompileContext getContext() {
        return this.context;
    }

    public int getCodeBlockLevel() {
        return this.myCodeBlockLevel;
    }

    public void setCodeBlockLevel(int codeBlockLevel) {
        this.myCodeBlockLevel = codeBlockLevel;
    }

    public static void setFilter(MatchingHandler handler, NodeFilter filter) {
        if (handler.getFilter() != null && handler.getFilter().getClass() != filter.getClass()) {
            handler.setFilter(new CompositeFilter(filter, handler.getFilter()));
        } else {
            handler.setFilter(filter);
        }
    }

    public void setFilterSimple(PsiElement element, NodeFilter filter) {
        this.context.getPattern().getHandler(element).setFilter(filter);
    }

    public List<PsiElement> getLexicalNodes() {
        return this.myLexicalNodes;
    }

    public void addLexicalNode(PsiElement node) {
        this.myLexicalNodes.add(node);
    }

    void compile(PsiElement[] elements, CompileContext context) {
        this.myCodeBlockLevel = 0;
        this.context = context;
        StructuralSearchProfile profile2 = StructuralSearchUtil.getProfileByFileType(context.getOptions().getFileType());
        assert (profile2 != null);
        profile2.compile(elements, this);
        assert (context.getPattern().getStrategy() != null);
    }

    @Nullable
    public MatchingHandler processPatternStringWithFragments(String pattern, OccurenceKind kind) {
        return this.processPatternStringWithFragments(pattern, kind, ourSubstitutionPattern);
    }

    @Nullable
    public MatchingHandler processPatternStringWithFragments(String pattern, OccurenceKind kind, Pattern substitutionPattern) {
        String word;
        String content;
        if (kind == OccurenceKind.LITERAL) {
            content = pattern.substring(1, pattern.length() - 1);
        } else if (kind == OccurenceKind.COMMENT) {
            content = pattern;
        } else {
            assert (false);
            return null;
        }
        StringBuilder buf = new StringBuilder(content.length());
        Matcher matcher = substitutionPattern.matcher(content);
        SmartList handlers = new SmartList();
        int start = 0;
        boolean hasLiteralContent = false;
        MatchingHandler handler = null;
        while (matcher.find()) {
            word = content.substring(start, matcher.start());
            if (!word.isEmpty()) {
                buf.append(StructuralSearchUtil.shieldRegExpMetaChars(word));
                hasLiteralContent = true;
                this.processTokenizedName(word, false, kind);
            }
            if ((handler = (SubstitutionHandler)this.getContext().getPattern().getHandler(matcher.group(1))) == null) {
                throw new MalformedPatternException();
            }
            handlers.add(handler);
            RegExpPredicate predicate = ((SubstitutionHandler)handler).findRegExpPredicate();
            if (predicate == null || !predicate.isWholeWords()) {
                buf.append("(.*?)");
            } else {
                buf.append(".*?\\b(").append(predicate.getRegExp()).append(")\\b.*?");
            }
            if (GlobalCompilingVisitor.isSuitablePredicate(predicate, (SubstitutionHandler)handler)) {
                this.processTokenizedName(predicate.getRegExp(), false, kind);
            }
            start = matcher.end();
        }
        word = content.substring(start);
        if (!word.isEmpty()) {
            hasLiteralContent = true;
            buf.append(StructuralSearchUtil.shieldRegExpMetaChars(word));
            this.processTokenizedName(word, false, kind);
        }
        if (hasLiteralContent) {
            if (kind == OccurenceKind.LITERAL) {
                buf.insert(0, "[\"']");
                buf.append("[\"']");
            }
            buf.append("$");
        }
        if (!handlers.isEmpty()) {
            return hasLiteralContent ? new LiteralWithSubstitutionHandler(buf.toString(), (List<? extends SubstitutionHandler>)handlers) : handler;
        }
        return null;
    }

    @Contract(value="null,_ -> false")
    static boolean isSuitablePredicate(RegExpPredicate predicate, SubstitutionHandler handler) {
        return predicate != null && handler.getMinOccurs() != 0 && predicate.couldBeOptimized();
    }

    public static void addFilesToSearchForGivenWord(String word, boolean endTransaction, OccurenceKind kind, CompileContext compileContext) {
        if (!compileContext.getSearchHelper().doOptimizing()) {
            return;
        }
        if (ourReservedWords.contains(word)) {
            return;
        }
        if (kind == OccurenceKind.CODE) {
            compileContext.getSearchHelper().addWordToSearchInCode(word);
        } else if (kind == OccurenceKind.COMMENT) {
            compileContext.getSearchHelper().addWordToSearchInComments(word);
        } else if (kind == OccurenceKind.LITERAL) {
            compileContext.getSearchHelper().addWordToSearchInLiterals(word);
        } else if (kind == OccurenceKind.TEXT) {
            compileContext.getSearchHelper().addWordToSearchInText(word);
        }
        if (endTransaction) {
            compileContext.getSearchHelper().endTransaction();
        }
    }

    public void processTokenizedName(String name2, boolean skipComments, OccurenceKind kind) {
        WordTokenizer tokenizer = new WordTokenizer(name2);
        Iterator<String> i = tokenizer.iterator();
        while (i.hasNext()) {
            String nextToken = i.next();
            if (skipComments && (nextToken.equals("/*") || nextToken.equals("/**") || nextToken.equals("*/") || nextToken.equals("*") || nextToken.equals("//"))) continue;
            Matcher matcher = ourAlternativePattern.matcher(nextToken);
            if (matcher.matches()) {
                StringTokenizer alternatives = new StringTokenizer(matcher.group(1), "|");
                while (alternatives.hasMoreTokens()) {
                    GlobalCompilingVisitor.addFilesToSearchForGivenWord(alternatives.nextToken(), !alternatives.hasMoreTokens(), kind, this.getContext());
                }
                continue;
            }
            GlobalCompilingVisitor.addFilesToSearchForGivenWord(nextToken, true, kind, this.getContext());
        }
    }

    static {
        for (StructuralSearchProfile profile2 : StructuralSearchProfile.EP_NAME.getExtensionList()) {
            ourReservedWords.addAll(profile2.getReservedWords());
        }
        ourAlternativePattern = Pattern.compile("^\\((.+)\\)$");
        ourWordSearchPattern = Pattern.compile(WORD_SEARCH_PATTERN_STR);
        ourFilter = LexicalNodesFilter.getInstance();
    }

    private static class WordTokenizer {
        private final List<String> myWords = new SmartList();

        WordTokenizer(String text) {
            StringTokenizer tokenizer = new StringTokenizer(text);
            Matcher matcher = null;
            while (tokenizer.hasMoreTokens()) {
                int i;
                String nextToken = tokenizer.nextToken();
                if (matcher == null) {
                    matcher = ourWordSearchPattern.matcher(nextToken);
                } else {
                    matcher.reset(nextToken);
                }
                nextToken = matcher.matches() ? matcher.group(1) : nextToken;
                int lastWordStart = 0;
                for (i = 0; i < nextToken.length(); ++i) {
                    if (Character.isJavaIdentifierStart(nextToken.charAt(i))) continue;
                    if (i != lastWordStart) {
                        this.myWords.add(nextToken.substring(lastWordStart, i));
                    }
                    lastWordStart = i + 1;
                }
                if (i == lastWordStart) continue;
                this.myWords.add(nextToken.substring(lastWordStart, i));
            }
        }

        Iterator<String> iterator() {
            return this.myWords.iterator();
        }
    }

    public static enum OccurenceKind {
        LITERAL,
        COMMENT,
        CODE,
        TEXT;

    }
}

