/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher.compiler;

import com.intellij.psi.PsiFile;
import com.intellij.structuralsearch.impl.matcher.compiler.OptimizingSearchHelperBase;
import com.intellij.util.SmartList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class TestModeOptimizingSearchHelper
extends OptimizingSearchHelperBase {
    private final StringBuilder builder = new StringBuilder();
    private String plan;
    private boolean myTransactionStarted = false;
    private final List<String> myWords = new SmartList();

    TestModeOptimizingSearchHelper() {
    }

    @Override
    public boolean doOptimizing() {
        return true;
    }

    @Override
    public void clear() {
        assert (!this.myTransactionStarted);
        this.plan = this.builder.toString();
        this.builder.setLength(0);
    }

    private void append(String word, String prefix) {
        this.myWords.add(prefix + word);
        this.myTransactionStarted = true;
    }

    @Override
    protected void doAddSearchWordInCode(@NotNull String word) {
        if (word == null) {
            TestModeOptimizingSearchHelper.$$$reportNull$$$0(0);
        }
        this.append(word, "in code:");
    }

    @Override
    protected void doAddSearchWordInText(@NotNull String word) {
        if (word == null) {
            TestModeOptimizingSearchHelper.$$$reportNull$$$0(1);
        }
        this.append(word, "in text:");
    }

    @Override
    protected void doAddSearchWordInComments(@NotNull String word) {
        if (word == null) {
            TestModeOptimizingSearchHelper.$$$reportNull$$$0(2);
        }
        this.append(word, "in comments:");
    }

    @Override
    protected void doAddSearchWordInLiterals(@NotNull String word) {
        if (word == null) {
            TestModeOptimizingSearchHelper.$$$reportNull$$$0(3);
        }
        this.append(word, "in literals:");
    }

    @Override
    public void endTransaction() {
        if (!this.myTransactionStarted) {
            return;
        }
        this.myTransactionStarted = false;
        super.endTransaction();
        Collections.sort(this.myWords);
        this.builder.append('[');
        boolean bar = false;
        for (String word : this.myWords) {
            if (bar) {
                this.builder.append('|');
            } else {
                bar = true;
            }
            this.builder.append(word);
        }
        this.builder.append(']');
        this.myWords.clear();
    }

    @Override
    public boolean isScannedSomething() {
        return false;
    }

    @Override
    @NotNull
    public Set<PsiFile> getFilesSetToScan() {
        assert (!this.myTransactionStarted);
        Set<PsiFile> set = Collections.emptySet();
        if (set == null) {
            TestModeOptimizingSearchHelper.$$$reportNull$$$0(4);
        }
        return set;
    }

    public String getSearchPlan() {
        assert (!this.myTransactionStarted);
        return this.plan;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "word";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/impl/matcher/compiler/TestModeOptimizingSearchHelper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/impl/matcher/compiler/TestModeOptimizingSearchHelper";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesSetToScan";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doAddSearchWordInCode";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "doAddSearchWordInText";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "doAddSearchWordInComments";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doAddSearchWordInLiterals";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

