/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchProfileBase;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.plugin.ui.FileTypeInfo;
import com.intellij.ui.ComboboxSpeedSearch;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileTypeSelector
extends ComboBox<FileTypeInfo> {
    public FileTypeSelector(@NotNull List<FileType> types) {
        if (types == null) {
            FileTypeSelector.$$$reportNull$$$0(0);
        }
        super(FileTypeSelector.createModel(types));
        this.setRenderer((ListCellRenderer)((Object)new MyCellRenderer()));
        new MySpeedSearch(this);
    }

    @Nullable
    public FileTypeInfo getSelectedItem() {
        return (FileTypeInfo)super.getSelectedItem();
    }

    @Nullable
    public FileType getSelectedFileType() {
        FileTypeInfo info = (FileTypeInfo)super.getSelectedItem();
        return info != null ? info.getFileType() : null;
    }

    public void setSelectedItem(@NotNull FileType type, @Nullable Language dialect, @Nullable String context) {
        if (type == null) {
            FileTypeSelector.$$$reportNull$$$0(1);
        }
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            FileTypeInfo info = (FileTypeInfo)model.getElementAt(i);
            if (!info.isEqualTo(type, dialect, context)) continue;
            this.setSelectedItem(info);
            return;
        }
    }

    public void setSelectedItem(Object anObject) {
        MyComboBoxModel model;
        int index;
        FileTypeInfo selectedInfo;
        if (anObject instanceof FileTypeInfo && !(selectedInfo = (FileTypeInfo)anObject).isEnabled() && (index = (model = (MyComboBoxModel)this.getModel()).getIndexOf(selectedInfo)) >= 0 && index + 1 < model.getSize()) {
            FileTypeInfo nextInfo = (FileTypeInfo)model.getElementAt(index + 1);
            super.setSelectedItem((Object)nextInfo);
            return;
        }
        super.setSelectedItem(anObject);
    }

    @NotNull
    private static DefaultComboBoxModel<FileTypeInfo> createModel(List<FileType> types) {
        ArrayList<FileTypeInfo> infos = new ArrayList<FileTypeInfo>();
        for (FileType fileType : types) {
            String[] contextNames;
            boolean duplicated = FileTypeSelector.isDuplicated(fileType, types);
            StructuralSearchProfile profile2 = StructuralSearchUtil.getProfileByFileType(fileType);
            if (profile2 instanceof StructuralSearchProfileBase && (contextNames = ((StructuralSearchProfileBase)profile2).getContextNames()).length != 0) {
                infos.add(new FileTypeInfo(fileType, null, null, false, duplicated));
                for (String contextName : contextNames) {
                    infos.add(new FileTypeInfo(fileType, null, contextName, true, duplicated));
                }
                continue;
            }
            infos.add(new FileTypeInfo(fileType, null, null, true, duplicated));
            if (!(fileType instanceof LanguageFileType)) continue;
            Language language = ((LanguageFileType)fileType).getLanguage();
            Language[] languageDialects = LanguageUtil.getLanguageDialects((Language)language);
            Arrays.sort(languageDialects, Comparator.comparing(Language::getDisplayName));
            for (Language dialect : languageDialects) {
                infos.add(new FileTypeInfo(fileType, dialect, null, true, duplicated));
            }
        }
        MyComboBoxModel myComboBoxModel = new MyComboBoxModel(infos);
        if (myComboBoxModel == null) {
            FileTypeSelector.$$$reportNull$$$0(2);
        }
        return myComboBoxModel;
    }

    private static boolean isDuplicated(@NotNull FileType fileType, @NotNull List<FileType> types) {
        if (fileType == null) {
            FileTypeSelector.$$$reportNull$$$0(3);
        }
        if (types == null) {
            FileTypeSelector.$$$reportNull$$$0(4);
        }
        String description = fileType.getDescription();
        for (FileType type : types) {
            if (type == fileType || !description.equals(type.getDescription())) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/plugin/ui/FileTypeSelector";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/plugin/ui/FileTypeSelector";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setSelectedItem";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isDuplicated";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MySpeedSearch
    extends ComboboxSpeedSearch {
        MySpeedSearch(FileTypeSelector comboBox) {
            super((JComboBox)((Object)comboBox));
        }

        protected String getElementText(Object element) {
            return ((FileTypeInfo)element).getSearchText();
        }
    }

    private static class MyCellRenderer
    extends ListCellRendererWrapper<FileTypeInfo> {
        private static final Icon EMPTY_ICON = EmptyIcon.ICON_18;
        private static final Icon WIDE_EMPTY_ICON = JBUI.scale((JBUI.JBIcon)EmptyIcon.create((int)32, (int)18));

        private MyCellRenderer() {
        }

        public void customize(JList list, FileTypeInfo info, int index, boolean selected, boolean hasFocus) {
            if (info == null) {
                return;
            }
            if (info.isNested() && index >= 0) {
                this.setIcon(WIDE_EMPTY_ICON);
                this.setText(info.getText());
            } else {
                this.setIcon(MyCellRenderer.getFileTypeIcon(info));
                this.setText(info.getFullText());
            }
        }

        @NotNull
        private static Icon getFileTypeIcon(FileTypeInfo info) {
            LayeredIcon layeredIcon = new LayeredIcon(2);
            layeredIcon.setIcon(EMPTY_ICON, 0);
            Icon icon = info.getFileType().getIcon();
            if (icon != null) {
                layeredIcon.setIcon(icon, 1);
            }
            LayeredIcon layeredIcon2 = layeredIcon;
            if (layeredIcon2 == null) {
                MyCellRenderer.$$$reportNull$$$0(0);
            }
            return layeredIcon2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/structuralsearch/plugin/ui/FileTypeSelector$MyCellRenderer", "getFileTypeIcon"));
        }
    }

    private static class MyComboBoxModel
    extends DefaultComboBoxModel<FileTypeInfo> {
        MyComboBoxModel(List<FileTypeInfo> infos) {
            super(infos.toArray(FileTypeInfo.EMPTY_ARRAY));
        }
    }
}

