/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui;

import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Splitter;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.plugin.replace.ui.ReplaceConfiguration;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.structuralsearch.plugin.ui.ExistingTemplatesComponent;
import com.intellij.structuralsearch.plugin.ui.SubstitutionShortInfoHandler;
import com.intellij.structuralsearch.plugin.ui.UIUtil;
import com.intellij.util.Producer;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SelectTemplateDialog
extends DialogWrapper {
    private final boolean showHistory;
    private Editor searchPatternEditor;
    private Editor replacePatternEditor;
    private final boolean replace;
    private final Project project;
    private final ExistingTemplatesComponent existingTemplatesComponent;
    private MySelectionListener selectionListener;
    private CardLayout myCardLayout;
    private JPanel myPreviewPanel;
    @NonNls
    private static final String PREVIEW_CARD = "Preview";
    @NonNls
    private static final String SELECT_TEMPLATE_CARD = "SelectCard";

    public SelectTemplateDialog(Project project2, boolean showHistory, boolean replace) {
        super(project2, true);
        this.project = project2;
        this.showHistory = showHistory;
        this.replace = replace;
        this.existingTemplatesComponent = ExistingTemplatesComponent.getInstance(this.project);
        this.setTitle(SSRBundle.message(this.showHistory ? "used.templates.history.dialog.title" : "existing.templates.dialog.title", new Object[0]));
        this.init();
        if (this.showHistory) {
            int selection = this.existingTemplatesComponent.getHistoryList().getSelectedIndex();
            if (selection != -1) {
                this.setPatternFromList(selection);
            }
        } else {
            TreePath selection = this.existingTemplatesComponent.getPatternTree().getSelectionPath();
            if (selection != null) {
                this.setPatternFromNode((DefaultMutableTreeNode)selection.getLastPathComponent());
            } else {
                this.showPatternPreviewFromConfiguration(null);
            }
        }
        this.setupListeners();
    }

    protected void doOKAction() {
        super.doOKAction();
        this.existingTemplatesComponent.finish(true);
    }

    public void doCancelAction() {
        super.doCancelAction();
        this.existingTemplatesComponent.finish(false);
    }

    private void setPatternFromList(int index) {
        this.showPatternPreviewFromConfiguration(this.existingTemplatesComponent.getHistoryList().getModel().getElementAt(index));
    }

    protected JComponent createCenterPanel() {
        JComponent centerComponent;
        JPanel centerPanel = new JPanel(new BorderLayout());
        Splitter splitter = new Splitter(false, 0.3f);
        centerPanel.add("Center", (Component)splitter);
        centerPanel.add((Component)splitter);
        splitter.setFirstComponent(this.showHistory ? this.existingTemplatesComponent.getHistoryPanel() : this.existingTemplatesComponent.getTemplatesPanel());
        JPanel panel = new JPanel(new BorderLayout());
        splitter.setSecondComponent((JComponent)panel);
        this.searchPatternEditor = UIUtil.createEditor(EditorFactory.getInstance().createDocument((CharSequence)""), this.project, false, true, (TemplateContextType)ContainerUtil.findInstance((Object[])TemplateContextType.EP_NAME.getExtensions(), TemplateContextType.class));
        if (this.replace) {
            this.replacePatternEditor = UIUtil.createEditor(EditorFactory.getInstance().createDocument((CharSequence)""), this.project, false, true, (TemplateContextType)ContainerUtil.findInstance((Object[])TemplateContextType.EP_NAME.getExtensions(), TemplateContextType.class));
            centerComponent = new Splitter(true);
            ((Splitter)centerComponent).setFirstComponent(this.searchPatternEditor.getComponent());
            ((Splitter)centerComponent).setSecondComponent(this.replacePatternEditor.getComponent());
        } else {
            centerComponent = this.searchPatternEditor.getComponent();
        }
        this.myCardLayout = new CardLayout();
        this.myPreviewPanel = new JPanel(this.myCardLayout);
        this.myPreviewPanel.add((Component)centerComponent, PREVIEW_CARD);
        JPanel selectPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gb = new GridBagConstraints(0, 0, 0, 0, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0);
        selectPanel.add((Component)new JLabel(SSRBundle.message("selecttemplate.template.label.please.select.template", new Object[0])), gb);
        this.myPreviewPanel.add((Component)selectPanel, SELECT_TEMPLATE_CARD);
        panel.add("Center", this.myPreviewPanel);
        JPanel labelPanel = new JPanel(new FlowLayout(0, 2, 0));
        labelPanel.add(new JLabel(SSRBundle.message("selecttemplate.template.preview", new Object[0])));
        labelPanel.add(UIUtil.createCompleteMatchInfo((Producer<? extends Configuration>)((Producer)() -> {
            Configuration[] configurations = this.getSelectedConfigurations();
            return configurations.length != 1 ? null : configurations[0];
        })));
        panel.add("North", labelPanel);
        return centerPanel;
    }

    public void dispose() {
        EditorFactory.getInstance().releaseEditor(this.searchPatternEditor);
        if (this.replacePatternEditor != null) {
            EditorFactory.getInstance().releaseEditor(this.replacePatternEditor);
        }
        this.removeListeners();
        super.dispose();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.showHistory ? this.existingTemplatesComponent.getHistoryList() : this.existingTemplatesComponent.getPatternTree();
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.structuralsearch.plugin.ui.SelectTemplateDialog";
    }

    private void setupListeners() {
        this.existingTemplatesComponent.setOwner(this);
        this.selectionListener = new MySelectionListener();
        if (this.showHistory) {
            this.existingTemplatesComponent.getHistoryList().getSelectionModel().addListSelectionListener(this.selectionListener);
        } else {
            this.existingTemplatesComponent.getPatternTree().getSelectionModel().addTreeSelectionListener(this.selectionListener);
        }
    }

    private void removeListeners() {
        this.existingTemplatesComponent.setOwner(null);
        if (this.showHistory) {
            this.existingTemplatesComponent.getHistoryList().getSelectionModel().removeListSelectionListener(this.selectionListener);
        } else {
            this.existingTemplatesComponent.getPatternTree().getSelectionModel().removeTreeSelectionListener(this.selectionListener);
        }
    }

    private void setPatternFromNode(DefaultMutableTreeNode node) {
        if (node == null) {
            return;
        }
        Object userObject = node.getUserObject();
        Configuration configuration = userObject instanceof Configuration ? (Configuration)userObject : null;
        this.showPatternPreviewFromConfiguration(configuration);
    }

    private void showPatternPreviewFromConfiguration(@Nullable Configuration configuration) {
        if (configuration == null) {
            this.myCardLayout.show(this.myPreviewPanel, SELECT_TEMPLATE_CARD);
            return;
        }
        this.myCardLayout.show(this.myPreviewPanel, PREVIEW_CARD);
        MatchOptions matchOptions = configuration.getMatchOptions();
        UIUtil.setContent(this.searchPatternEditor, matchOptions.getSearchPattern());
        this.searchPatternEditor.putUserData(SubstitutionShortInfoHandler.CURRENT_CONFIGURATION_KEY, (Object)configuration);
        if (this.replace) {
            String replacement = configuration instanceof ReplaceConfiguration ? ((ReplaceConfiguration)configuration).getReplaceOptions().getReplacement() : configuration.getMatchOptions().getSearchPattern();
            UIUtil.setContent(this.replacePatternEditor, replacement);
            this.replacePatternEditor.putUserData(SubstitutionShortInfoHandler.CURRENT_CONFIGURATION_KEY, (Object)configuration);
        }
    }

    @NotNull
    public Configuration[] getSelectedConfigurations() {
        if (this.showHistory) {
            List<Configuration> selectedValues = this.existingTemplatesComponent.getHistoryList().getSelectedValuesList();
            Configuration[] configurationArray = selectedValues.toArray(Configuration.EMPTY_ARRAY);
            if (configurationArray == null) {
                SelectTemplateDialog.$$$reportNull$$$0(0);
            }
            return configurationArray;
        }
        TreePath[] paths = this.existingTemplatesComponent.getPatternTree().getSelectionModel().getSelectionPaths();
        if (paths == null) {
            if (Configuration.EMPTY_ARRAY == null) {
                SelectTemplateDialog.$$$reportNull$$$0(1);
            }
            return Configuration.EMPTY_ARRAY;
        }
        ArrayList<Configuration> configurations = new ArrayList<Configuration>();
        for (TreePath path : paths) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            Object userObject = node.getUserObject();
            if (!(userObject instanceof Configuration)) continue;
            configurations.add((Configuration)userObject);
        }
        Configuration[] configurationArray = configurations.toArray(Configuration.EMPTY_ARRAY);
        if (configurationArray == null) {
            SelectTemplateDialog.$$$reportNull$$$0(2);
        }
        return configurationArray;
    }

    public void selectConfiguration(String name2) {
        this.existingTemplatesComponent.selectConfiguration(name2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/structuralsearch/plugin/ui/SelectTemplateDialog", "getSelectedConfigurations"));
    }

    class MySelectionListener
    implements TreeSelectionListener,
    ListSelectionListener {
        MySelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            if (e.getNewLeadSelectionPath() != null) {
                SelectTemplateDialog.this.setPatternFromNode((DefaultMutableTreeNode)e.getNewLeadSelectionPath().getLastPathComponent());
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting() || e.getLastIndex() == -1) {
                return;
            }
            int selectionIndex = SelectTemplateDialog.this.existingTemplatesComponent.getHistoryList().getSelectedIndex();
            if (selectionIndex != -1) {
                SelectTemplateDialog.this.setPatternFromList(selectionIndex);
            }
        }
    }
}

