/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testIntegration;

import com.intellij.execution.TestStateStorage;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.testIntegration.DeadTestsCleaner;
import com.intellij.testIntegration.RecentTestRunnerImpl;
import com.intellij.testIntegration.RecentTestsListPopup;
import com.intellij.testIntegration.RecentTestsListProvider;
import com.intellij.testIntegration.RecentTestsPopupEntry;
import com.intellij.testIntegration.RunConfigurationByRecordProvider;
import com.intellij.testIntegration.SelectTestStep;
import com.intellij.testIntegration.TestLocator;
import com.intellij.testIntegration.UrlsCollector;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class ShowRecentTests
extends AnAction {
    private static final int TEST_LIMIT = Integer.MAX_VALUE;
    private static final String ID = "show.recent.tests.action";

    private static Date getSinceDate() {
        return new Date(System.currentTimeMillis() - 86400000L);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ShowRecentTests.$$$reportNull$$$0(0);
        }
        e.getPresentation().setEnabled(e.getProject() != null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project2;
        if (e == null) {
            ShowRecentTests.$$$reportNull$$$0(1);
        }
        if ((project2 = e.getProject()) == null) {
            return;
        }
        TestStateStorage testStorage = TestStateStorage.getInstance((Project)project2);
        TestLocator testLocator = new TestLocator(project2);
        RecentTestRunnerImpl testRunner = new RecentTestRunnerImpl(testLocator);
        Map records = testStorage.getRecentTests(Integer.MAX_VALUE, ShowRecentTests.getSinceDate());
        RunConfigurationByRecordProvider configurationProvider = new RunConfigurationByRecordProvider(project2);
        RecentTestsListProvider listProvider = new RecentTestsListProvider(configurationProvider, records);
        List<RecentTestsPopupEntry> entries = listProvider.getTestsToShow();
        SelectTestStep selectStepTest = new SelectTestStep("Debug Recent Tests", entries, testRunner);
        RecentTestsListPopup popup = new RecentTestsListPopup((ListPopupStep<RecentTestsPopupEntry>)selectStepTest, testRunner, testLocator);
        popup.showCenteredInCurrentWindow(project2);
        ShowRecentTests.cleanDeadTests(entries, testLocator, testStorage);
    }

    private static void cleanDeadTests(List<RecentTestsPopupEntry> entries, TestLocator testLocator, TestStateStorage testStorage) {
        UrlsCollector collector = new UrlsCollector();
        entries.forEach(e -> e.accept(collector));
        ApplicationManager.getApplication().executeOnPooledThread((Runnable)new DeadTestsCleaner(testStorage, collector.getUrls(), testLocator));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/testIntegration/ShowRecentTests";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

