/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.VirtualMachine;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.binding.CodegenBinding;
import org.jetbrains.kotlin.codegen.coroutines.CoroutineCodegenUtilKt;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.idea.codeInsight.CodeInsightUtils;
import org.jetbrains.kotlin.idea.debugger.DebuggerUtilKt;
import org.jetbrains.kotlin.idea.debugger.MockStackFrame;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinDebuggerCaches;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000|\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0018\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u001a\u0018\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\u0010\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u0001H\u0002\u001a\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016\u001a\u001e\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001a\u001a\u0014\u0010\u001b\u001a\u00020\u00142\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d\u001a\u000e\u0010\u001f\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016\u001a\u000e\u0010 \u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016\u001a\u000e\u0010!\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016\u001a\u0018\u0010\"\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\u0010\u0010#\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0001H\u0002\u001a\u0014\u0010$\u001a\u00020\u000b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d\u001a\u0015\u0010%\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\u0002\u0010&\u001a1\u0010'\u001a\u0004\u0018\u0001H(\"\b\b\u0000\u0010(*\u00020)*\u00020\u001a2\u0014\u0010*\u001a\u0010\u0012\u0004\u0012\u00020,\u0012\u0006\u0012\u0004\u0018\u0001H(0+\u00a2\u0006\u0002\u0010-\u001a\u0010\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00160\u001d*\u00020/\u001a\u0010\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00160\u001d*\u000200\u001a\u0012\u00101\u001a\n\u0012\u0004\u0012\u00020\u001e\u0018\u00010\u001d*\u00020/\u001a\n\u00102\u001a\u00020\u000b*\u00020\u0016\u001a\u0018\u00103\u001a\b\u0012\u0004\u0012\u00020\u00160\u001d*\u00020/2\u0006\u0010\n\u001a\u00020\u000b\u001a\f\u00104\u001a\u0004\u0018\u00010/*\u00020\u0016\u001a\f\u00105\u001a\u0004\u0018\u000106*\u00020/\u001a\n\u00107\u001a\u00020\u000b*\u00020\u0016\u001a\f\u00108\u001a\u0004\u0018\u00010\u0001*\u00020\u0016\u001a\f\u00109\u001a\u0004\u0018\u000106*\u00020\u001e\u001a\u0012\u0010:\u001a\n\u0012\u0004\u0012\u00020\u001e\u0018\u00010\u001d*\u00020/\u001a\u001a\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d*\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001aH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"DO_RESUME_SIGNATURE", "", "INVOKE_SUSPEND_SIGNATURE", "findCallByEndToken", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "element", "Lcom/intellij/psi/PsiElement;", "findElementAtLine", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "line", "", "functionNameByArgument", "elementAt", "Lorg/jetbrains/kotlin/psi/KtFunction;", "context", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "functionNameByLocalVariable", "name", "isInSuspendMethod", "", "location", "Lcom/sun/jdi/Location;", "isInsideInlineArgument", "inlineArgument", "debugProcess", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "isInsideInlineFunctionBody", "visibleVariables", "", "Lcom/sun/jdi/LocalVariable;", "isLastLineLocationInMethod", "isOnSuspendReturnOrReenter", "isOneLineMethod", "lambdaOrdinalByArgument", "lambdaOrdinalByLocalVariable", "numberOfInlinedFunctions", "suspendFunctionFirstLineLocation", "(Lcom/sun/jdi/Location;)Ljava/lang/Integer;", "invokeInManagerThread", "T", "", "f", "Lkotlin/Function1;", "Lcom/intellij/debugger/impl/DebuggerContextImpl;", "(Lcom/intellij/debugger/engine/DebugProcessImpl;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "safeAllLineLocations", "Lcom/sun/jdi/Method;", "Lcom/sun/jdi/ReferenceType;", "safeArguments", "safeLineNumber", "safeLocationsOfLine", "safeMethod", "safeReturnType", "Lcom/sun/jdi/Type;", "safeSourceLineNumber", "safeSourceName", "safeType", "safeVariables", "idea-jvm"})
public final class DebuggerUtilKt {
    private static final String DO_RESUME_SIGNATURE = "(Ljava/lang/Object;Ljava/lang/Throwable;)Ljava/lang/Object;";
    private static final String INVOKE_SUSPEND_SIGNATURE = "(Ljava/lang/Object;)Ljava/lang/Object;";

    @NotNull
    public static final List<Location> safeAllLineLocations(@NotNull Method $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        List list2 = DebuggerUtilsEx.allLineLocations((Method)$receiver);
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    @NotNull
    public static final List<Location> safeAllLineLocations(@NotNull ReferenceType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        List list2 = DebuggerUtilsEx.allLineLocations((ReferenceType)$receiver);
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    @NotNull
    public static final List<Location> safeLocationsOfLine(@NotNull Method $receiver, int line) {
        List<Location> list2;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        try {
            List<Location> list3 = $receiver.locationsOfLine(line);
            Intrinsics.checkExpressionValueIsNotNull(list3, (String)"locationsOfLine(line)");
            list2 = list3;
        }
        catch (AbsentInformationException e) {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    @Nullable
    public static final List<LocalVariable> safeVariables(@NotNull Method $receiver) {
        List<LocalVariable> list2;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        try {
            list2 = $receiver.variables();
        }
        catch (AbsentInformationException e) {
            list2 = null;
        }
        return list2;
    }

    @Nullable
    public static final List<LocalVariable> safeArguments(@NotNull Method $receiver) {
        List<LocalVariable> list2;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        try {
            list2 = $receiver.arguments();
        }
        catch (AbsentInformationException e) {
            list2 = null;
        }
        return list2;
    }

    @Nullable
    public static final com.sun.jdi.Type safeReturnType(@NotNull Method $receiver) {
        com.sun.jdi.Type type;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        try {
            type = $receiver.returnType();
        }
        catch (ClassNotLoadedException e) {
            type = null;
        }
        return type;
    }

    @Nullable
    public static final com.sun.jdi.Type safeType(@NotNull LocalVariable $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        try {
            return $receiver.type();
        }
        catch (ClassNotLoadedException e) {
            Object var1_2 = null;
            return var1_2;
        }
    }

    @Nullable
    public static final String safeSourceName(@NotNull Location $receiver) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        try {
            string = $receiver.sourceName();
        }
        catch (AbsentInformationException e) {
            string = null;
        }
        catch (InternalError e) {
            string = null;
        }
        return string;
    }

    public static final int safeLineNumber(@NotNull Location $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return DebuggerUtilsEx.getLineNumber((Location)$receiver, (boolean)false);
    }

    public static final int safeSourceLineNumber(@NotNull Location $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return DebuggerUtilsEx.getLineNumber((Location)$receiver, (boolean)true);
    }

    @Nullable
    public static final Method safeMethod(@NotNull Location $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return DebuggerUtilsEx.getMethod((Location)$receiver);
    }

    public static final boolean isInsideInlineFunctionBody(@NotNull List<? extends LocalVariable> visibleVariables) {
        boolean bl;
        block3: {
            Intrinsics.checkParameterIsNotNull(visibleVariables, (String)"visibleVariables");
            Iterable $receiver$iv = visibleVariables;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    LocalVariable it = (LocalVariable)element$iv;
                    String string = it.name();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.name()");
                    if (!StringsKt.startsWith$default((String)string, (String)"$i$f$", (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public static final int numberOfInlinedFunctions(@NotNull List<? extends LocalVariable> visibleVariables) {
        int n;
        Intrinsics.checkParameterIsNotNull(visibleVariables, (String)"visibleVariables");
        Iterable $receiver$iv = visibleVariables;
        if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
            n = 0;
        } else {
            void var2_2;
            int count$iv = 0;
            for (Object element$iv : $receiver$iv) {
                int n2;
                LocalVariable it = (LocalVariable)element$iv;
                String string = it.name();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.name()");
                if (!StringsKt.startsWith$default((String)string, (String)"$i$f$", (boolean)false, (int)2, null) || (n2 = ++count$iv) >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = var2_2;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean isInsideInlineArgument(@NotNull KtFunction inlineArgument, @NotNull Location location2, @NotNull DebugProcessImpl debugProcess) {
        boolean bl;
        block5: {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Object element$iv$iv2;
            void $receiver$iv$iv2;
            Iterable $receiver$iv2;
            Intrinsics.checkParameterIsNotNull((Object)inlineArgument, (String)"inlineArgument");
            Intrinsics.checkParameterIsNotNull((Object)location2, (String)"location");
            Intrinsics.checkParameterIsNotNull((Object)debugProcess, (String)"debugProcess");
            List<LocalVariable> visibleVariables = DebuggerUtilKt.visibleVariables(location2, debugProcess);
            Iterable iterable = $receiver$iv2 = (Iterable)visibleVariables;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv2 : $receiver$iv$iv2) {
                LocalVariable it = (LocalVariable)element$iv$iv2;
                String string = it.name();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.name()");
                if (!StringsKt.startsWith$default((String)string, (String)"$i$a$", (boolean)false, (int)2, null)) continue;
                destination$iv$iv.add(element$iv$iv2);
            }
            List markerLocalVariables = (List)destination$iv$iv;
            BindingContext bindingContext2 = KotlinDebuggerCaches.Companion.getOrCreateTypeMapper((PsiElement)inlineArgument).getBindingContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext2, (String)"KotlinDebuggerCaches.get\u2026eArgument).bindingContext");
            BindingContext context = bindingContext2;
            int lambdaOrdinal2 = ((Number)ApplicationUtilsKt.runReadAction((Function0)((Function0)new Function0<Integer>(inlineArgument, context){
                final /* synthetic */ KtFunction $inlineArgument;
                final /* synthetic */ BindingContext $context;

                public final int invoke() {
                    return DebuggerUtilKt.access$lambdaOrdinalByArgument(this.$inlineArgument, this.$context);
                }
                {
                    this.$inlineArgument = ktFunction;
                    this.$context = bindingContext2;
                    super(0);
                }
            }))).intValue();
            String functionName2 = (String)ApplicationUtilsKt.runReadAction((Function0)((Function0)new Function0<String>(inlineArgument, context){
                final /* synthetic */ KtFunction $inlineArgument;
                final /* synthetic */ BindingContext $context;

                @NotNull
                public final String invoke() {
                    return DebuggerUtilKt.access$functionNameByArgument(this.$inlineArgument, this.$context);
                }
                {
                    this.$inlineArgument = ktFunction;
                    this.$context = bindingContext2;
                    super(0);
                }
            }));
            Iterable iterable2 = markerLocalVariables;
            element$iv$iv2 = $receiver$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                LocalVariable $i$f$filter = (LocalVariable)item$iv$iv;
                Collection collection = destination$iv$iv2;
                String string = it.name();
                collection.add(string);
            }
            $receiver$iv = (List)destination$iv$iv2;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    String variableName;
                    String string = variableName = (String)element$iv;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"variableName");
                    if (!(DebuggerUtilKt.lambdaOrdinalByLocalVariable(string) == lambdaOrdinal2 && Intrinsics.areEqual((Object)DebuggerUtilKt.functionNameByLocalVariable(variableName), (Object)functionName2))) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final <T> T invokeInManagerThread(@NotNull DebugProcessImpl $receiver, @NotNull Function1<? super DebuggerContextImpl, ? extends T> f) {
        void result2;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull(f, (String)"f");
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        DebuggerCommandImpl command2 = new DebuggerCommandImpl($receiver, (Ref.ObjectRef)result2, f){
            final /* synthetic */ DebugProcessImpl $this_invokeInManagerThread;
            final /* synthetic */ Ref.ObjectRef $result;
            final /* synthetic */ Function1 $f;

            protected void action() {
                this.$result.element = ApplicationUtilsKt.runReadAction((Function0)((Function0)new Function0<T>(this){
                    final /* synthetic */ invokeInManagerThread.command.1 this$0;

                    @Nullable
                    public final T invoke() {
                        Function1 function1 = this.this$0.$f;
                        DebuggerContextImpl debuggerContextImpl = this.this$0.$this_invokeInManagerThread.getDebuggerContext();
                        Intrinsics.checkExpressionValueIsNotNull((Object)debuggerContextImpl, (String)"debuggerContext");
                        return (T)function1.invoke((Object)debuggerContextImpl);
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                }));
            }
            {
                this.$this_invokeInManagerThread = $receiver;
                this.$result = $captured_local_variable$1;
                this.$f = $captured_local_variable$2;
            }
        };
        if (DebuggerManagerThreadImpl.isManagerThread()) {
            $receiver.getManagerThread().invoke(command2);
        } else {
            $receiver.getManagerThread().invokeAndWait(command2);
        }
        return (T)result2.element;
    }

    private static final int lambdaOrdinalByArgument(KtFunction elementAt, BindingContext context) {
        Type type = CodegenBinding.asmTypeForAnonymousClass((BindingContext)context, (KtElement)((KtElement)elementAt));
        Intrinsics.checkExpressionValueIsNotNull((Object)type, (String)"CodegenBinding.asmTypeFo\u2026Class(context, elementAt)");
        Type type2 = type;
        String string = type2.getClassName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"type.className");
        String string2 = StringsKt.substringAfterLast$default((String)string, (String)"$", null, (int)2, null);
        return Integer.parseInt(string2);
    }

    private static final String functionNameByArgument(KtFunction elementAt, BindingContext context) {
        ValueParameterDescriptor inlineArgumentDescriptor = InlineUtil.getInlineArgumentDescriptor((KtFunction)elementAt, (BindingContext)context);
        Object object = inlineArgumentDescriptor;
        if (object == null || (object = object.getContainingDeclaration()) == null || (object = object.getName()) == null || (object = object.asString()) == null) {
            object = "unknown";
        }
        return object;
    }

    private static final List<LocalVariable> visibleVariables(@NotNull Location $receiver, DebugProcessImpl debugProcess) {
        VirtualMachineProxyImpl virtualMachineProxyImpl = debugProcess.getVirtualMachineProxy();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualMachineProxyImpl, (String)"debugProcess.virtualMachineProxy");
        VirtualMachine virtualMachine = virtualMachineProxyImpl.getVirtualMachine();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualMachine, (String)"debugProcess.virtualMachineProxy.virtualMachine");
        MockStackFrame stackFrame = new MockStackFrame($receiver, virtualMachine);
        return stackFrame.visibleVariables();
    }

    private static final int lambdaOrdinalByLocalVariable(String name) {
        try {
            String nameWithoutPrefix = StringsKt.removePrefix((String)name, (CharSequence)"$i$a$");
            return Integer.parseInt(StringsKt.substringBefore((String)nameWithoutPrefix, (String)"$", (String)nameWithoutPrefix));
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    private static final String functionNameByLocalVariable(String name) {
        String nameWithoutPrefix = StringsKt.removePrefix((String)name, (CharSequence)"$i$a$");
        return StringsKt.substringAfterLast((String)nameWithoutPrefix, (String)"$", (String)"unknown");
    }

    public static final boolean isInSuspendMethod(@NotNull Location location2) {
        Intrinsics.checkParameterIsNotNull((Object)location2, (String)"location");
        Method method = location2.method();
        String signature = method.signature();
        for (Type continuationAsmType : CoroutineCodegenUtilKt.continuationAsmTypes()) {
            String string = signature;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"signature");
            CharSequence charSequence = string;
            String string2 = continuationAsmType.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"continuationAsmType.toString()");
            if (!StringsKt.contains$default((CharSequence)charSequence, (CharSequence)string2, (boolean)false, (int)2, null) && (!Intrinsics.areEqual((Object)method.name(), (Object)"doResume") || !Intrinsics.areEqual((Object)signature, (Object)DO_RESUME_SIGNATURE)) && (!Intrinsics.areEqual((Object)method.name(), (Object)"invokeSuspend") || !Intrinsics.areEqual((Object)signature, (Object)INVOKE_SUSPEND_SIGNATURE))) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static final Integer suspendFunctionFirstLineLocation(@NotNull Location location2) {
        Integer lineNumber;
        Intrinsics.checkParameterIsNotNull((Object)location2, (String)"location");
        if (!DebuggerUtilKt.isInSuspendMethod(location2)) {
            return null;
        }
        Location location3 = location2.method().location();
        Integer n = lineNumber = location3 != null ? Integer.valueOf(location3.lineNumber()) : null;
        if (n != null && n == -1) {
            return null;
        }
        return lineNumber;
    }

    public static final boolean isOnSuspendReturnOrReenter(@NotNull Location location2) {
        Intrinsics.checkParameterIsNotNull((Object)location2, (String)"location");
        Integer n = DebuggerUtilKt.suspendFunctionFirstLineLocation(location2);
        if (n == null) {
            return false;
        }
        int suspendStartLineNumber = n;
        return suspendStartLineNumber == location2.lineNumber();
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean isLastLineLocationInMethod(@NotNull Location location2) {
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)location2, (String)"location");
        Method method = location2.method();
        Intrinsics.checkExpressionValueIsNotNull((Object)method, (String)"location.method()");
        Iterable iterable = $receiver$iv = (Iterable)DebuggerUtilKt.safeAllLineLocations(method);
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            Location location3 = (Location)item$iv$iv;
            Collection collection = destination$iv$iv;
            Integer n = it.lineNumber();
            collection.add(n);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            int it = ((Number)element$iv$iv).intValue();
            if (!(it != -1)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List knownLines = (List)destination$iv$iv;
        if (knownLines.isEmpty()) {
            return false;
        }
        Integer n = (Integer)CollectionsKt.max((Iterable)knownLines);
        int n2 = location2.lineNumber();
        return n != null && n == n2;
    }

    public static final boolean isOneLineMethod(@NotNull Location location2) {
        Intrinsics.checkParameterIsNotNull((Object)location2, (String)"location");
        Method method = location2.method();
        Intrinsics.checkExpressionValueIsNotNull((Object)method, (String)"location.method()");
        List<Location> allLineLocations = DebuggerUtilKt.safeAllLineLocations(method);
        Location location3 = (Location)CollectionsKt.firstOrNull(allLineLocations);
        Integer firstLine = location3 != null ? Integer.valueOf(location3.lineNumber()) : null;
        Location location4 = (Location)CollectionsKt.lastOrNull(allLineLocations);
        Integer lastLine = location4 != null ? Integer.valueOf(location4.lineNumber()) : null;
        return firstLine != null && Intrinsics.areEqual((Object)firstLine, (Object)lastLine);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final PsiElement findElementAtLine(@NotNull KtFile file2, int line) {
        void offset;
        PsiElement elementAt;
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Integer n = KotlinRefactoringUtilKt.getLineStartOffset((PsiFile)((PsiFile)file2), (int)line);
        if (n == null) {
            return null;
        }
        int lineStartOffset = n;
        Integer n2 = KotlinRefactoringUtilKt.getLineEndOffset((PsiFile)((PsiFile)file2), (int)line);
        if (n2 == null) {
            return null;
        }
        int lineEndOffset = n2;
        PsiElement topMostElement = null;
        int n3 = lineStartOffset;
        int n4 = lineEndOffset;
        while (!(n3 >= n4 || (elementAt = file2.findElementAt((int)offset)) != null && (topMostElement = CodeInsightUtils.getTopmostElementAtOffset((PsiElement)elementAt, (int)offset)) instanceof KtElement)) {
            ++offset;
        }
        return topMostElement;
    }

    @Nullable
    public static final KtCallExpression findCallByEndToken(@NotNull PsiElement element) {
        KtCallExpression ktCallExpression;
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        if (element instanceof KtElement) {
            return null;
        }
        ASTNode aSTNode = element.getNode();
        Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"element.node");
        IElementType iElementType = aSTNode.getElementType();
        if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.RPAR)) {
            PsiElement psiElement = element.getParent();
            if (!(psiElement instanceof KtValueArgumentList)) {
                psiElement = null;
            }
            KtValueArgumentList ktValueArgumentList = (KtValueArgumentList)psiElement;
            Object object = ktValueArgumentList != null ? ktValueArgumentList.getParent() : null;
            if (!(object instanceof KtCallExpression)) {
                object = null;
            }
            ktCallExpression = (KtCallExpression)object;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.RBRACE)) {
            PsiElement braceParent;
            PsiElement psiElement = CodeInsightUtils.getTopParentWithEndOffset((PsiElement)element, KtCallExpression.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"CodeInsightUtils.getTopP\u2026llExpression::class.java)");
            PsiElement psiElement2 = braceParent = psiElement;
            if (psiElement2 instanceof KtCallExpression) {
                ktCallExpression = (KtCallExpression)braceParent;
            } else if (psiElement2 instanceof KtLambdaArgument) {
                PsiElement psiElement3 = ((KtLambdaArgument)braceParent).getParent();
                if (!(psiElement3 instanceof KtCallExpression)) {
                    psiElement3 = null;
                }
                ktCallExpression = (KtCallExpression)psiElement3;
            } else if (psiElement2 instanceof KtValueArgument) {
                PsiElement psiElement4 = ((KtValueArgument)braceParent).getParent();
                if (!(psiElement4 instanceof KtValueArgumentList)) {
                    psiElement4 = null;
                }
                KtValueArgumentList ktValueArgumentList = (KtValueArgumentList)psiElement4;
                Object object = ktValueArgumentList != null ? ktValueArgumentList.getParent() : null;
                if (!(object instanceof KtCallExpression)) {
                    object = null;
                }
                ktCallExpression = (KtCallExpression)object;
            } else {
                ktCallExpression = null;
            }
        } else {
            ktCallExpression = null;
        }
        return ktCallExpression;
    }

    public static final /* synthetic */ int access$lambdaOrdinalByArgument(@NotNull KtFunction elementAt, @NotNull BindingContext context) {
        return DebuggerUtilKt.lambdaOrdinalByArgument(elementAt, context);
    }

    @NotNull
    public static final /* synthetic */ String access$functionNameByArgument(@NotNull KtFunction elementAt, @NotNull BindingContext context) {
        return DebuggerUtilKt.functionNameByArgument(elementAt, context);
    }
}

