/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.evaluate;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.jdi.LocalVariableProxyImpl;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StackFrame;
import com.sun.jdi.VirtualMachine;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.eval4j.ObjectValue;
import org.jetbrains.eval4j.Value;
import org.jetbrains.eval4j.ValuesKt;
import org.jetbrains.eval4j.jdi.JdiValuesKt;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.idea.debugger.DebuggerUtilKt;
import org.jetbrains.kotlin.idea.debugger.DebuggerUtils;
import org.jetbrains.kotlin.idea.debugger.evaluate.FrameVisitor;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinEvaluationBuilderKt;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.idea.util.attachment.AttachmentUtilsKt;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 12\u00020\u0001:\u00011B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J$\u0010\u0011\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0012\u001a\u00020\u000e2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0010H\u0002J$\u0010\u0016\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0012\u001a\u00020\u000e2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0010H\u0002J,\u0010\u0017\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0010H\u0002J$\u0010\u001a\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0012\u001a\u00020\u000e2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0010H\u0002J\u001c\u0010\u001b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0007\u001a\u00020\u001c2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002J\u001c\u0010\u001d\u001a\u0004\u0018\u00010\f2\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002J*\u0010 \u001a\u0004\u0018\u00010\f2\u0006\u0010\u0012\u001a\u00020\u000e2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010!\u001a\u00020\u0010J\u0016\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u000e0#2\u0006\u0010\u0012\u001a\u00020\u000eH\u0002J,\u0010$\u001a\u0004\u0018\u00010\f2\u0006\u0010%\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u000e2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0010H\u0002J\"\u0010&\u001a\u0004\u0018\u00010\f2\u0006\u0010'\u001a\u00020\f2\b\u0010(\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0010J\u0012\u0010)\u001a\u00020\u00102\b\u0010*\u001a\u0004\u0018\u00010\u0014H\u0002J\"\u0010+\u001a\u00020\u00102\u0006\u0010'\u001a\u00020\f2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010,\u001a\u00020\u0010H\u0002J\f\u0010-\u001a\u00020\u0010*\u00020\fH\u0002J\u0016\u0010.\u001a\u00020\u0010*\u0004\u0018\u00010/2\u0006\u00100\u001a\u00020\u000eH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/FrameVisitor;", "", "context", "Lcom/intellij/debugger/engine/evaluation/EvaluationContextImpl;", "(Lcom/intellij/debugger/engine/evaluation/EvaluationContextImpl;)V", "getContext", "()Lcom/intellij/debugger/engine/evaluation/EvaluationContextImpl;", "frame", "Lcom/intellij/debugger/jdi/StackFrameProxyImpl;", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "fail", "Lorg/jetbrains/eval4j/Value;", "message", "", "shouldFail", "", "findCapturedLocalVariable", "name", "asmType", "Lorg/jetbrains/org/objectweb/asm/Type;", "checkType", "findLocalVariable", "findLocalVariableForInlineArgument", "number", "", "findLocalVariableForLocalFun", "findThis", "Lcom/sun/jdi/StackFrame;", "findThisInCapturedThis", "capturedThis", "Lcom/sun/jdi/ObjectReference;", "findValue", "failIfNotFound", "getCapturedFieldNames", "", "getField", "owner", "getValueIfSharedVar", "value", "expectedType", "isFunctionType", "type", "isValueOfCorrectType", "shouldCheckType", "isSharedVar", "isSubclass", "Lcom/sun/jdi/Type;", "superClassName", "Companion", "idea-jvm"})
public final class FrameVisitor {
    private final GlobalSearchScope scope;
    private final StackFrameProxyImpl frame;
    @NotNull
    private final EvaluationContextImpl context;
    private static final Type OBJECT_TYPE;
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final Value findValue(@NotNull String name, @Nullable Type asmType, boolean checkType, boolean failIfNotFound) {
        Object frame;
        block8: {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            StackFrameProxyImpl stackFrameProxyImpl = this.frame;
            Object object = stackFrameProxyImpl;
            if (stackFrameProxyImpl == null) return null;
            StackFrame stackFrame = object.getStackFrame();
            object = stackFrame;
            if (stackFrame == null) return null;
            frame = object;
            String string = name;
            if (!Intrinsics.areEqual((Object)string, (Object)KotlinEvaluationBuilderKt.getTHIS_NAME())) break block8;
            Value thisValue = this.findThis((StackFrame)frame, asmType);
            if (thisValue == null) return this.fail("Cannot find local variable: name = " + name + (checkType ? ", type = " + String.valueOf(asmType) : ""), failIfNotFound);
            return thisValue;
        }
        try {
            Value variableForLocalFun;
            List<LocalVariable> list2 = frame.visibleVariables();
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"frame.visibleVariables()");
            if (DebuggerUtilKt.isInsideInlineFunctionBody(list2)) {
                int number;
                List<LocalVariable> list3 = frame.visibleVariables();
                Intrinsics.checkExpressionValueIsNotNull(list3, (String)"frame.visibleVariables()");
                int n = number = DebuggerUtilKt.numberOfInlinedFunctions(list3);
                int n2 = 1;
                while (n >= n2) {
                    void inlineFunctionIndex;
                    Value inlineFunVar = this.findLocalVariableForInlineArgument(name, (int)inlineFunctionIndex, asmType, true);
                    if (inlineFunVar != null) {
                        return inlineFunVar;
                    }
                    --inlineFunctionIndex;
                }
            }
            if (this.isFunctionType(asmType) && (variableForLocalFun = this.findLocalVariableForLocalFun(name, asmType, checkType)) != null) {
                return variableForLocalFun;
            }
            Value localVariable = this.findLocalVariable(name, asmType, checkType);
            if (localVariable != null) {
                return localVariable;
            }
            Value value = (Value)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)this.getCapturedFieldNames(name)), (Function1)((Function1)new Function1<String, Value>(this, asmType, checkType){
                final /* synthetic */ FrameVisitor this$0;
                final /* synthetic */ Type $asmType;
                final /* synthetic */ boolean $checkType;

                @Nullable
                public final Value invoke(@NotNull String it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return FrameVisitor.access$findCapturedLocalVariable(this.this$0, it, this.$asmType, this.$checkType);
                }
                {
                    this.this$0 = frameVisitor;
                    this.$asmType = type;
                    this.$checkType = bl;
                    super(1);
                }
            })));
            if (value == null) return this.fail("Cannot find local variable: name = " + name + (checkType ? ", type = " + String.valueOf(asmType) : ""), failIfNotFound);
            Value value2 = value;
            return value2;
        }
        catch (InvalidStackFrameException e) {
            EvaluateException evaluateException = EvaluateExceptionUtil.createEvaluateException((String)("Local variable " + name + " is unavailable in current frame"));
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)evaluateException), (String)"EvaluateExceptionUtil.cr\u2026ilable in current frame\")");
            throw (Throwable)evaluateException;
        }
    }

    private final Value fail(String message, boolean shouldFail) {
        KtFile ktFile;
        JvmClassName declaringTypeName;
        JvmClassName jvmClassName;
        Object object;
        Location location2;
        block10: {
            block9: {
                Location location3;
                if (!shouldFail) {
                    return null;
                }
                StackFrameProxyImpl stackFrameProxyImpl = this.frame;
                location2 = stackFrameProxyImpl != null ? stackFrameProxyImpl.location() : null;
                object = location2;
                if (object == null) break block9;
                Location $receiver = location3 = object;
                object = "Location: " + $receiver.sourceName() + ':' + $receiver.lineNumber();
                if (object != null) break block10;
            }
            object = "No location available";
        }
        Object locationText = object;
        Location location4 = location2;
        String sourceName = location4 != null ? location4.sourceName() : null;
        Object object2 = location2;
        if (object2 != null && (object2 = object2.declaringType()) != null && (object2 = object2.name()) != null && (object2 = StringsKt.replace$default((String)object2, (char)'.', (char)'/', (boolean)false, (int)4, null)) != null) {
            Object $i$a$1$run;
            Object it = $i$a$1$run = object2;
            jvmClassName = JvmClassName.byInternalName((String)it);
        } else {
            jvmClassName = declaringTypeName = null;
        }
        if (sourceName != null && declaringTypeName != null) {
            Project project = this.context.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"context.project");
            ktFile = DebuggerUtils.INSTANCE.findSourceFileForClassIncludeLibrarySources(project, this.scope, declaringTypeName, sourceName, location2);
        } else {
            ktFile = null;
        }
        KtFile sourceFile = ktFile;
        String sourceFileText2 = (String)ApplicationUtilsKt.runReadAction((Function0)((Function0)new Function0<String>(sourceFile){
            final /* synthetic */ KtFile $sourceFile;

            @Nullable
            public final String invoke() {
                KtFile ktFile = this.$sourceFile;
                return ktFile != null ? ktFile.getText() : null;
            }
            {
                this.$sourceFile = ktFile;
                super(0);
            }
        }));
        if (sourceName != null && sourceFileText2 != null) {
            Attachment attachments2 = AttachmentUtilsKt.mergeAttachments((Attachment[])new Attachment[]{new Attachment(sourceName, sourceFileText2), new Attachment("location.txt", (String)locationText)});
            KotlinEvaluationBuilderKt.getLOG().error(message, new Attachment[]{attachments2});
        }
        EvaluateException evaluateException = EvaluateExceptionUtil.createEvaluateException((String)message);
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)evaluateException), (String)"EvaluateExceptionUtil.cr\u2026valuateException(message)");
        throw (Throwable)evaluateException;
    }

    private final Value findThis(StackFrame frame, Type asmType) {
        Value receiver;
        Pair it;
        Object v3;
        List<LocalVariable> list2 = frame.visibleVariables();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"frame.visibleVariables()");
        if (DebuggerUtilKt.isInsideInlineFunctionBody(list2)) {
            List<LocalVariable> list3 = frame.visibleVariables();
            Intrinsics.checkExpressionValueIsNotNull(list3, (String)"frame.visibleVariables()");
            int number = DebuggerUtilKt.numberOfInlinedFunctions(list3);
            Value inlineFunVar = this.findLocalVariableForInlineArgument("this_", number, asmType, true);
            if (inlineFunVar != null) {
                return inlineFunVar;
            }
        }
        List<LocalVariable> list4 = frame.visibleVariables();
        Intrinsics.checkExpressionValueIsNotNull(list4, (String)"frame.visibleVariables()");
        Sequence $receiver$iv = SequencesKt.filter((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)list4), (Function1)findThis.1.INSTANCE), (Function1)((Function1)new Function1<LocalVariable, Pair<? extends LocalVariable, ? extends Value>>(frame){
            final /* synthetic */ StackFrame $frame;

            @NotNull
            public final Pair<LocalVariable, Value> invoke(LocalVariable it) {
                return TuplesKt.to((Object)it, (Object)JdiValuesKt.asValue((com.sun.jdi.Value)this.$frame.getValue(it)));
            }
            {
                this.$frame = stackFrame;
                super(1);
            }
        })), (Function1)((Function1)new Function1<Pair<? extends LocalVariable, ? extends Value>, Boolean>(this, asmType){
            final /* synthetic */ FrameVisitor this$0;
            final /* synthetic */ Type $asmType;

            public final boolean invoke(@NotNull Pair<? extends LocalVariable, ? extends Value> it) {
                Intrinsics.checkParameterIsNotNull(it, (String)"it");
                return FrameVisitor.access$isValueOfCorrectType(this.this$0, (Value)it.getSecond(), this.$asmType, true);
            }
            {
                this.this$0 = frameVisitor;
                this.$asmType = type;
                super(1);
            }
        }));
        Iterator iterator$iv = $receiver$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v3 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            it = (Pair)maxElem$iv;
            Comparable maxValue$iv = (LocalVariable)it.getFirst();
            while (iterator$iv.hasNext()) {
                Object e$iv = iterator$iv.next();
                Pair it2 = (Pair)e$iv;
                Comparable v$iv = (LocalVariable)it2.getFirst();
                if (maxValue$iv.compareTo(v$iv) >= 0) continue;
                maxElem$iv = e$iv;
                maxValue$iv = v$iv;
            }
            v3 = maxElem$iv;
        }
        Pair pair = v3;
        if (pair != null) {
            Sequence it3 = $receiver$iv = pair;
            return JdiValuesKt.asValue((com.sun.jdi.Value)frame.getValue((LocalVariable)it3.getFirst()));
        }
        ObjectReference thisObject = frame.thisObject();
        if (thisObject != null) {
            ObjectValue eval4jValue = JdiValuesKt.asValue((ObjectReference)thisObject);
            if (this.isValueOfCorrectType((Value)eval4jValue, asmType, true)) {
                return (Value)eval4jValue;
            }
            Value value = this.findThisInCapturedThis(thisObject, asmType);
            if (value != null) {
                Value $i$a$5$let = value;
                it = $i$a$5$let;
                return it;
            }
        }
        if ((receiver = this.findValue(KotlinEvaluationBuilderKt.getRECEIVER_NAME(), asmType, true, false)) != null) {
            return receiver;
        }
        Value this0 = this.findValue("this$0", asmType, true, false);
        if (this0 != null) {
            return this0;
        }
        Value $this = this.findValue("$this", asmType, false, false);
        if ($this != null) {
            return $this;
        }
        return null;
    }

    private final Value findLocalVariableForLocalFun(String name, Type asmType, boolean checkType) {
        return this.findLocalVariable(name + "$", asmType, checkType);
    }

    private final Value findLocalVariableForInlineArgument(String name, int number, Type asmType, boolean checkType) {
        return this.findLocalVariable(name + StringsKt.repeat((CharSequence)"$iv", (int)number), asmType, checkType);
    }

    private final Value findThisInCapturedThis(ObjectReference capturedThis, Type asmType) {
        for (Field field : capturedThis.referenceType().fields()) {
            Value evalValue;
            com.sun.jdi.Value value;
            String name = field.name();
            if (Intrinsics.areEqual((Object)name, (Object)"this$0") && (value = capturedThis.getValue(field)) instanceof ObjectReference) {
                Value value2 = this.findThisInCapturedThis((ObjectReference)value, asmType);
                if (value2 != null) {
                    Value value3;
                    Value it = value3 = value2;
                    return it;
                }
            }
            String string = name;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name");
            if (!StringsKt.startsWith$default((String)string, (String)"$this_", (boolean)false, (int)2, null) && !Intrinsics.areEqual((Object)name, (Object)"receiver$0") && !Intrinsics.areEqual((Object)name, (Object)"this$0") || !this.isValueOfCorrectType(evalValue = JdiValuesKt.asValue((com.sun.jdi.Value)(value = capturedThis.getValue(field))), asmType, true)) continue;
            return evalValue;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isFunctionType(Type type) {
        Type type2 = type;
        if (type2 == null) return false;
        if (type2.getSort() != 10) return false;
        String string = type.getInternalName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"type.internalName");
        if (!StringsKt.startsWith$default((String)string, (String)"kotlin/jvm/functions/Function", (boolean)false, (int)2, null)) return false;
        return true;
    }

    private final Value findLocalVariable(String name, Type asmType, boolean checkType) {
        StackFrameProxyImpl stackFrameProxyImpl = this.frame;
        if (stackFrameProxyImpl == null) {
            Intrinsics.throwNpe();
        }
        LocalVariableProxyImpl localVariableProxyImpl = stackFrameProxyImpl.visibleVariableByName(name);
        if (localVariableProxyImpl == null) {
            return null;
        }
        LocalVariableProxyImpl localVariable = localVariableProxyImpl;
        Value eval4jValue = JdiValuesKt.asValue((com.sun.jdi.Value)this.frame.getValue(localVariable));
        Value sharedVarValue = this.getValueIfSharedVar(eval4jValue, asmType, checkType);
        if (sharedVarValue != null) {
            return sharedVarValue;
        }
        if (this.isValueOfCorrectType(eval4jValue, asmType, checkType)) {
            return eval4jValue;
        }
        return null;
    }

    private final Value findCapturedLocalVariable(String name, Type asmType, boolean checkType) {
        Object object = this.frame;
        if (object == null || (object = object.thisObject()) == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"frame?.thisObject() ?: return null");
        Object thisObject = object;
        Value thisObj = (Value)JdiValuesKt.asValue((ObjectReference)thisObject);
        Value capturedVal = null;
        while (capturedVal == null && thisObj != null) {
            capturedVal = this.getField(thisObj, name, asmType, checkType);
            if (capturedVal != null) continue;
            thisObj = this.getField(thisObj, "this$0", null, false);
        }
        if (capturedVal != null) {
            Value sharedVarValue = this.getValueIfSharedVar(capturedVal, asmType, checkType);
            if (sharedVarValue != null) {
                return sharedVarValue;
            }
            return capturedVal;
        }
        return null;
    }

    private final boolean isValueOfCorrectType(Value value, Type asmType, boolean shouldCheckType) {
        if (!shouldCheckType || asmType == null || Intrinsics.areEqual((Object)value.getAsmType(), (Object)asmType)) {
            return true;
        }
        if (Intrinsics.areEqual((Object)asmType, (Object)OBJECT_TYPE)) {
            return true;
        }
        Object object = ValuesKt.obj$default((Value)value, null, (int)1, null);
        if (!(object instanceof ObjectReference)) {
            object = null;
        }
        ObjectReference objectReference = (ObjectReference)object;
        com.sun.jdi.Type type = objectReference != null ? objectReference.referenceType() : null;
        String string = asmType.getClassName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"asmType.className");
        if (this.isSubclass(type, string)) {
            return true;
        }
        ClassDescriptor thisDesc = KotlinEvaluationBuilderKt.getClassDescriptor(value.getAsmType(), this.scope);
        ClassDescriptor expDesc = KotlinEvaluationBuilderKt.getClassDescriptor(asmType, this.scope);
        return thisDesc != null && expDesc != null && (Boolean)ApplicationUtilsKt.runReadAction((Function0)((Function0)new Function0<Boolean>(thisDesc, expDesc){
            final /* synthetic */ ClassDescriptor $thisDesc;
            final /* synthetic */ ClassDescriptor $expDesc;

            public final boolean invoke() {
                return DescriptorUtils.isSubclass((ClassDescriptor)this.$thisDesc, (ClassDescriptor)this.$expDesc);
            }
            {
                this.$thisDesc = classDescriptor;
                this.$expDesc = classDescriptor2;
                super(0);
            }
        })) != false;
    }

    private final Value getField(Value owner, String name, Type asmType, boolean checkType) {
        try {
            StackFrameProxyImpl stackFrameProxyImpl = this.frame;
            if (stackFrameProxyImpl == null) {
                Intrinsics.throwNpe();
            }
            VirtualMachineProxyImpl virtualMachineProxyImpl = stackFrameProxyImpl.getVirtualMachine();
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualMachineProxyImpl, (String)"frame!!.virtualMachine");
            VirtualMachine virtualMachine = virtualMachineProxyImpl.getVirtualMachine();
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualMachine, (String)"frame!!.virtualMachine.virtualMachine");
            com.sun.jdi.Value obj = JdiValuesKt.asJdiValue((Value)owner, (VirtualMachine)virtualMachine, (Type)owner.getAsmType());
            if (!(obj instanceof ObjectReference)) {
                return null;
            }
            ReferenceType _class = ((ObjectReference)obj).referenceType();
            Field field = _class.fieldByName(name);
            if (field == null) {
                return null;
            }
            Field field2 = field;
            Value fieldValue = JdiValuesKt.asValue((com.sun.jdi.Value)((ObjectReference)obj).getValue(field2));
            if (this.isValueOfCorrectType(fieldValue, asmType, checkType)) {
                return fieldValue;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isSharedVar(@NotNull Value $receiver) {
        if ($receiver.getAsmType().getSort() != 10) return false;
        String string = $receiver.getAsmType().getInternalName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"this.asmType.internalName");
        if (!StringsKt.startsWith$default((String)string, (String)"kotlin/jvm/internal/Ref$", (boolean)false, (int)2, null)) return false;
        return true;
    }

    @Nullable
    public final Value getValueIfSharedVar(@NotNull Value value, @Nullable Type expectedType, boolean checkType) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        if (!this.isSharedVar(value)) {
            return null;
        }
        Value sharedVarValue = this.getField(value, "element", expectedType, checkType);
        if (sharedVarValue != null && this.isValueOfCorrectType(sharedVarValue, expectedType, checkType)) {
            return sharedVarValue;
        }
        return null;
    }

    private final List<String> getCapturedFieldNames(String name) {
        List list2;
        String string = name;
        if (Intrinsics.areEqual((Object)string, (Object)KotlinEvaluationBuilderKt.getRECEIVER_NAME())) {
            list2 = CollectionsKt.listOf((Object)"receiver$0");
        } else if (Intrinsics.areEqual((Object)string, (Object)KotlinEvaluationBuilderKt.getTHIS_NAME())) {
            list2 = CollectionsKt.listOf((Object)"this$0");
        } else if (Intrinsics.areEqual((Object)string, (Object)"receiver$0")) {
            list2 = CollectionsKt.listOf((Object)name);
        } else if (Intrinsics.areEqual((Object)string, (Object)"this$0")) {
            list2 = CollectionsKt.listOf((Object)name);
        } else {
            String simpleName = '$' + name;
            list2 = CollectionsKt.listOf((Object[])new String[]{simpleName, simpleName + "$inlined"});
        }
        return list2;
    }

    private final boolean isSubclass(@Nullable com.sun.jdi.Type $receiver, String superClassName) {
        boolean bl;
        block6: {
            if (!($receiver instanceof ClassType)) {
                return false;
            }
            List<InterfaceType> list2 = ((ClassType)$receiver).allInterfaces();
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"allInterfaces()");
            Iterable $receiver$iv = list2;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    InterfaceType it = (InterfaceType)element$iv;
                    if (!Intrinsics.areEqual((Object)it.name(), (Object)superClassName)) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        if (bl) {
            return true;
        }
        for (ClassType superClass = ((ClassType)$receiver).superclass(); superClass != null; superClass = superClass.superclass()) {
            if (!Intrinsics.areEqual((Object)superClass.name(), (Object)superClassName)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public final EvaluationContextImpl getContext() {
        return this.context;
    }

    public FrameVisitor(@NotNull EvaluationContextImpl context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
        DebugProcessImpl debugProcessImpl = this.context.getDebugProcess();
        Intrinsics.checkExpressionValueIsNotNull((Object)debugProcessImpl, (String)"context.debugProcess");
        GlobalSearchScope globalSearchScope = debugProcessImpl.getSearchScope();
        Intrinsics.checkExpressionValueIsNotNull((Object)globalSearchScope, (String)"context.debugProcess.searchScope");
        this.scope = globalSearchScope;
        this.frame = this.context.getFrameProxy();
    }

    static {
        Companion = new Companion(null);
        OBJECT_TYPE = Type.getType(Object.class);
    }

    @Nullable
    public static final /* synthetic */ Value access$findCapturedLocalVariable(FrameVisitor $this, @NotNull String name, @Nullable Type asmType, boolean checkType) {
        return $this.findCapturedLocalVariable(name, asmType, checkType);
    }

    public static final /* synthetic */ boolean access$isValueOfCorrectType(FrameVisitor $this, @NotNull Value value, @Nullable Type asmType, boolean shouldCheckType) {
        return $this.isValueOfCorrectType(value, asmType, shouldCheckType);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0019\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/FrameVisitor$Companion;", "", "()V", "OBJECT_TYPE", "Lorg/jetbrains/org/objectweb/asm/Type;", "kotlin.jvm.PlatformType", "getOBJECT_TYPE", "()Lorg/jetbrains/org/objectweb/asm/Type;", "idea-jvm"})
    public static final class Companion {
        public final Type getOBJECT_TYPE() {
            return OBJECT_TYPE;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

