/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.stepping;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.BreakpointStepMethodFilter;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Range;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.coroutines.CoroutineCodegenUtilKt;
import org.jetbrains.kotlin.idea.debugger.DebuggerUtilKt;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\nJ\n\u0010\u000e\u001a\u0004\u0018\u00010\fH\u0016J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J\b\u0010\u0010\u001a\u00020\u0006H\u0016J\u0012\u0010\u0011\u001a\u00020\b2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/stepping/KotlinLambdaMethodFilter;", "Lcom/intellij/debugger/engine/BreakpointStepMethodFilter;", "lambda", "Lorg/jetbrains/kotlin/psi/KtFunction;", "myCallingExpressionLines", "Lcom/intellij/util/Range;", "", "isInline", "", "isSuspend", "(Lorg/jetbrains/kotlin/psi/KtFunction;Lcom/intellij/util/Range;ZZ)V", "myFirstStatementPosition", "Lcom/intellij/debugger/SourcePosition;", "myLastStatementLine", "getBreakpointPosition", "getCallingExpressionLines", "getLastStatementLine", "isLambdaName", "name", "", "locationMatches", "process", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "location", "Lcom/sun/jdi/Location;", "idea-jvm"})
public final class KotlinLambdaMethodFilter
implements BreakpointStepMethodFilter {
    private final SourcePosition myFirstStatementPosition;
    private final int myLastStatementLine;
    private final KtFunction lambda;
    private final Range<Integer> myCallingExpressionLines;
    private final boolean isInline;
    private final boolean isSuspend;

    @Nullable
    public SourcePosition getBreakpointPosition() {
        return this.myFirstStatementPosition;
    }

    public int getLastStatementLine() {
        return this.myLastStatementLine;
    }

    public boolean locationMatches(@NotNull DebugProcessImpl process2, @NotNull Location location2) {
        Intrinsics.checkParameterIsNotNull((Object)process2, (String)"process");
        Intrinsics.checkParameterIsNotNull((Object)location2, (String)"location");
        Method method = location2.method();
        if (this.isInline) {
            return DebuggerUtilKt.isInsideInlineArgument(this.lambda, location2, process2);
        }
        return this.isLambdaName(method.name());
    }

    @NotNull
    public Range<Integer> getCallingExpressionLines() {
        return this.isInline ? new Range((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(999)) : this.myCallingExpressionLines;
    }

    private final boolean isLambdaName(String name) {
        if (this.isSuspend && name != null) {
            return CoroutineCodegenUtilKt.isResumeImplMethodNameFromAnyLanguageSettings((String)name);
        }
        return Intrinsics.areEqual((Object)name, (Object)OperatorNameConventions.INVOKE.asString());
    }

    public KotlinLambdaMethodFilter(@NotNull KtFunction lambda2, @NotNull Range<Integer> myCallingExpressionLines, boolean isInline, boolean isSuspend) {
        Intrinsics.checkParameterIsNotNull((Object)lambda2, (String)"lambda");
        Intrinsics.checkParameterIsNotNull(myCallingExpressionLines, (String)"myCallingExpressionLines");
        this.lambda = lambda2;
        this.myCallingExpressionLines = myCallingExpressionLines;
        this.isInline = isInline;
        this.isSuspend = isSuspend;
        KtExpression body = this.lambda.getBodyExpression();
        if (body != null && KotlinRefactoringUtilKt.isMultiLine((PsiElement)((PsiElement)this.lambda))) {
            Object object;
            SourcePosition firstStatementPosition = null;
            SourcePosition lastStatementPosition = null;
            KtExpression ktExpression = body;
            if (!(ktExpression instanceof KtBlockExpression)) {
                ktExpression = null;
            }
            if ((object = (KtBlockExpression)ktExpression) == null || (object = object.getStatements()) == null) {
                object = CollectionsKt.listOf((Object)body);
            }
            Object statements = object;
            Collection collection = (Collection)statements;
            if (!collection.isEmpty() && (firstStatementPosition = SourcePosition.createFromElement((PsiElement)((PsiElement)CollectionsKt.first((List)statements)))) != null) {
                KtExpression lastStatement = (KtExpression)CollectionsKt.last((List)statements);
                PsiFile psiFile = firstStatementPosition.getFile();
                KtExpression ktExpression2 = lastStatement;
                Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression2, (String)"lastStatement");
                TextRange textRange = ktExpression2.getTextRange();
                Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"lastStatement.textRange");
                lastStatementPosition = SourcePosition.createFromOffset((PsiFile)psiFile, (int)textRange.getEndOffset());
            }
            this.myFirstStatementPosition = firstStatementPosition;
            this.myLastStatementLine = lastStatementPosition != null ? lastStatementPosition.getLine() : -1;
        } else {
            SourcePosition sourcePosition = this.myFirstStatementPosition = SourcePosition.createFromElement((PsiElement)((PsiElement)this.lambda));
            if (sourcePosition == null) {
                Intrinsics.throwNpe();
            }
            this.myLastStatementLine = sourcePosition.getLine();
        }
    }
}

