/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal.reflect;

import com.google.gson.internal.reflect.ReflectionAccessor;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import sun.misc.Unsafe;

final class UnsafeReflectionAccessor
extends ReflectionAccessor {
    private final Unsafe theUnsafe = UnsafeReflectionAccessor.getUnsafeInstance();
    private final Field overrideField = UnsafeReflectionAccessor.getOverrideField();

    UnsafeReflectionAccessor() {
    }

    @Override
    public void makeAccessible(AccessibleObject ao) {
        if (this.theUnsafe != null && this.overrideField != null) {
            long overrideOffset = this.theUnsafe.objectFieldOffset(this.overrideField);
            this.theUnsafe.putBoolean(ao, overrideOffset, true);
        }
    }

    private static Unsafe getUnsafeInstance() {
        try {
            Field unsafeField = Unsafe.class.getDeclaredField("theUnsafe");
            unsafeField.setAccessible(true);
            return (Unsafe)unsafeField.get(null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Field getOverrideField() {
        try {
            return AccessibleObject.class.getDeclaredField("override");
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
            return null;
        }
    }
}

