/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.instrument.witness.pipeline;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import org.logstash.instrument.metrics.Metric;
import org.logstash.instrument.metrics.gauge.NumberGauge;
import org.logstash.instrument.witness.MetricSerializer;
import org.logstash.instrument.witness.SerializableWitness;

@JsonSerialize(using=Serializer.class)
public class DeadLetterQueueWitness
implements SerializableWitness {
    private static final String KEY = "dead_letter_queue";
    private final Snitch snitch;
    private final NumberGauge queueSizeInBytes = new NumberGauge("queue_size_in_bytes");

    public DeadLetterQueueWitness() {
        this.snitch = new Snitch(this);
    }

    public void queueSizeInBytes(long size) {
        this.queueSizeInBytes.set(size);
    }

    public Snitch snitch() {
        return this.snitch;
    }

    @Override
    public void genJson(JsonGenerator gen, SerializerProvider provider) throws IOException {
        Serializer.innerSerialize(this, gen);
    }

    public static class Snitch {
        private final DeadLetterQueueWitness witness;

        private Snitch(DeadLetterQueueWitness witness) {
            this.witness = witness;
        }

        public Number queueSizeInBytes() {
            return (Number)this.witness.queueSizeInBytes.getValue();
        }
    }

    public static final class Serializer
    extends StdSerializer<DeadLetterQueueWitness> {
        private static final long serialVersionUID = 1L;

        public Serializer() {
            this(DeadLetterQueueWitness.class);
        }

        protected Serializer(Class<DeadLetterQueueWitness> t) {
            super(t);
        }

        public void serialize(DeadLetterQueueWitness witness, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeStartObject();
            Serializer.innerSerialize(witness, gen);
            gen.writeEndObject();
        }

        static void innerSerialize(DeadLetterQueueWitness witness, JsonGenerator gen) throws IOException {
            gen.writeObjectFieldStart(DeadLetterQueueWitness.KEY);
            MetricSerializer<Metric<Number>> numberSerializer = MetricSerializer.Get.numberSerializer(gen);
            numberSerializer.serialize(witness.queueSizeInBytes);
            gen.writeEndObject();
        }
    }
}

