/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.instrument.witness.pipeline;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.logstash.instrument.witness.SerializableWitness;
import org.logstash.instrument.witness.pipeline.PluginWitness;

@JsonSerialize(using=Serializer.class)
public class PluginsWitness
implements SerializableWitness {
    private final Map<String, PluginWitness> inputs = new ConcurrentHashMap<String, PluginWitness>();
    private final Map<String, PluginWitness> outputs = new ConcurrentHashMap<String, PluginWitness>();
    private final Map<String, PluginWitness> filters = new ConcurrentHashMap<String, PluginWitness>();
    private final Map<String, PluginWitness> codecs = new ConcurrentHashMap<String, PluginWitness>();
    private static final String KEY = "plugins";

    public PluginWitness inputs(String id) {
        return PluginsWitness.getPlugin(this.inputs, id);
    }

    public PluginWitness outputs(String id) {
        return PluginsWitness.getPlugin(this.outputs, id);
    }

    public PluginWitness filters(String id) {
        return PluginsWitness.getPlugin(this.filters, id);
    }

    public PluginWitness codecs(String id) {
        return PluginsWitness.getPlugin(this.codecs, id);
    }

    public void forgetAll() {
        this.inputs.clear();
        this.outputs.clear();
        this.filters.clear();
        this.codecs.clear();
    }

    private static PluginWitness getPlugin(Map<String, PluginWitness> plugin, String id) {
        return plugin.computeIfAbsent(id, PluginWitness::new);
    }

    @Override
    public void genJson(JsonGenerator gen, SerializerProvider provider) throws IOException {
        Serializer.innerSerialize(this, gen, provider);
    }

    public static final class Serializer
    extends StdSerializer<PluginsWitness> {
        private static final long serialVersionUID = 1L;

        public Serializer() {
            this(PluginsWitness.class);
        }

        private Serializer(Class<PluginsWitness> t) {
            super(t);
        }

        public void serialize(PluginsWitness witness, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeStartObject();
            Serializer.innerSerialize(witness, gen, provider);
            gen.writeEndObject();
        }

        static void innerSerialize(PluginsWitness witness, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeObjectFieldStart(PluginsWitness.KEY);
            Serializer.serializePlugins("inputs", witness.inputs, gen, provider);
            Serializer.serializePlugins("filters", witness.filters, gen, provider);
            Serializer.serializePlugins("outputs", witness.outputs, gen, provider);
            gen.writeEndObject();
        }

        private static void serializePlugins(String key, Map<String, PluginWitness> plugin, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeArrayFieldStart(key);
            for (Map.Entry<String, PluginWitness> entry : plugin.entrySet()) {
                gen.writeStartObject();
                entry.getValue().genJson(gen, provider);
                gen.writeEndObject();
            }
            gen.writeEndArray();
        }
    }
}

