/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.eventhubs.impl;

import com.microsoft.azure.eventhubs.ErrorContext;
import com.microsoft.azure.eventhubs.EventHubException;
import com.microsoft.azure.eventhubs.TimeoutException;
import com.microsoft.azure.eventhubs.impl.ActiveClientTokenManager;
import com.microsoft.azure.eventhubs.impl.AmqpException;
import com.microsoft.azure.eventhubs.impl.AmqpReceiver;
import com.microsoft.azure.eventhubs.impl.ClientConstants;
import com.microsoft.azure.eventhubs.impl.ClientEntity;
import com.microsoft.azure.eventhubs.impl.DispatchHandler;
import com.microsoft.azure.eventhubs.impl.ErrorContextProvider;
import com.microsoft.azure.eventhubs.impl.ExceptionUtil;
import com.microsoft.azure.eventhubs.impl.MessagingFactory;
import com.microsoft.azure.eventhubs.impl.OperationResult;
import com.microsoft.azure.eventhubs.impl.ReceiveLinkHandler;
import com.microsoft.azure.eventhubs.impl.ReceiverContext;
import com.microsoft.azure.eventhubs.impl.ReceiverSettingsProvider;
import com.microsoft.azure.eventhubs.impl.TimeoutTracker;
import com.microsoft.azure.eventhubs.impl.Timer;
import com.microsoft.azure.eventhubs.impl.TrackingUtil;
import com.microsoft.azure.eventhubs.impl.WorkItem;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.qpid.proton.Proton;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.UnknownDescribedType;
import org.apache.qpid.proton.amqp.messaging.Source;
import org.apache.qpid.proton.amqp.messaging.Target;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.amqp.transport.ReceiverSettleMode;
import org.apache.qpid.proton.amqp.transport.SenderSettleMode;
import org.apache.qpid.proton.engine.BaseHandler;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.EndpointState;
import org.apache.qpid.proton.engine.Extendable;
import org.apache.qpid.proton.engine.Handler;
import org.apache.qpid.proton.engine.Link;
import org.apache.qpid.proton.engine.Receiver;
import org.apache.qpid.proton.engine.Session;
import org.apache.qpid.proton.message.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MessageReceiver
extends ClientEntity
implements AmqpReceiver,
ErrorContextProvider {
    private static final Logger TRACE_LOGGER = LoggerFactory.getLogger(MessageReceiver.class);
    private static final int MIN_TIMEOUT_DURATION_MILLIS = 20;
    private final ConcurrentLinkedQueue<ReceiveWorkItem> pendingReceives;
    private final MessagingFactory underlyingFactory;
    private final String receivePath;
    private final Runnable onOperationTimedout;
    private final Duration operationTimeout;
    private final CompletableFuture<Void> linkClose;
    private final Object prefetchCountSync;
    private final ReceiverSettingsProvider settingsProvider;
    private final String tokenAudience;
    private final ActiveClientTokenManager activeClientTokenManager;
    private final WorkItem<MessageReceiver> linkOpen;
    private final ConcurrentLinkedQueue<Message> prefetchedMessages;
    private final ReceiveWork receiveWork;
    private final CreateAndReceive createAndReceive;
    private final Object errorConditionLock;
    private final Timer timer;
    private volatile int nextCreditToFlow;
    private volatile Receiver receiveLink;
    private volatile Duration receiveTimeout;
    private volatile Message lastReceivedMessage;
    private volatile boolean creatingLink;
    private volatile CompletableFuture<?> openTimer;
    private volatile CompletableFuture<?> closeTimer;
    private int prefetchCount;
    private Exception lastKnownLinkError;

    private MessageReceiver(MessagingFactory factory, String name, String recvPath, int prefetchCount, ReceiverSettingsProvider settingsProvider) {
        super(name, factory, factory.executor);
        this.underlyingFactory = factory;
        this.operationTimeout = factory.getOperationTimeout();
        this.receivePath = recvPath;
        this.prefetchCount = prefetchCount;
        this.prefetchedMessages = new ConcurrentLinkedQueue();
        this.linkClose = new CompletableFuture();
        this.lastKnownLinkError = null;
        this.receiveTimeout = factory.getOperationTimeout();
        this.prefetchCountSync = new Object();
        this.settingsProvider = settingsProvider;
        this.linkOpen = new WorkItem(new CompletableFuture(), factory.getOperationTimeout());
        this.timer = new Timer(factory);
        this.pendingReceives = new ConcurrentLinkedQueue();
        this.errorConditionLock = new Object();
        this.onOperationTimedout = new Runnable(){

            @Override
            public void run() {
                WorkItem topWorkItem = null;
                while ((topWorkItem = (WorkItem)MessageReceiver.this.pendingReceives.peek()) != null) {
                    if (topWorkItem.getTimeoutTracker().remaining().toMillis() <= 20L) {
                        WorkItem dequedWorkItem = (WorkItem)MessageReceiver.this.pendingReceives.poll();
                        if (dequedWorkItem == null || dequedWorkItem.getWork() == null || dequedWorkItem.getWork().isDone()) break;
                        dequedWorkItem.getWork().complete(null);
                        continue;
                    }
                    MessageReceiver.this.scheduleOperationTimer(topWorkItem.getTimeoutTracker());
                    break;
                }
            }
        };
        this.receiveWork = new ReceiveWork();
        this.createAndReceive = new CreateAndReceive();
        this.tokenAudience = String.format("amqp://%s/%s", this.underlyingFactory.getHostName(), this.receivePath);
        this.activeClientTokenManager = new ActiveClientTokenManager(this, new Runnable(){

            @Override
            public void run() {
                block2: {
                    try {
                        MessageReceiver.this.underlyingFactory.getCBSChannel().sendToken(MessageReceiver.this.underlyingFactory.getReactorScheduler(), MessageReceiver.this.underlyingFactory.getTokenProvider().getToken(MessageReceiver.this.tokenAudience, ClientConstants.TOKEN_VALIDITY), MessageReceiver.this.tokenAudience, new OperationResult<Void, Exception>(){

                            @Override
                            public void onComplete(Void result) {
                                if (TRACE_LOGGER.isDebugEnabled()) {
                                    TRACE_LOGGER.debug(String.format(Locale.US, "path[%s], linkName[%s] - token renewed", MessageReceiver.this.receivePath, MessageReceiver.this.receiveLink.getName()));
                                }
                            }

                            @Override
                            public void onError(Exception error) {
                                if (TRACE_LOGGER.isInfoEnabled()) {
                                    TRACE_LOGGER.info(String.format(Locale.US, "path[%s], linkName[%s], tokenRenewalFailure[%s]", MessageReceiver.this.receivePath, MessageReceiver.this.receiveLink.getName(), error.getMessage()));
                                }
                            }
                        });
                    }
                    catch (IOException | RuntimeException | InvalidKeyException | NoSuchAlgorithmException exception) {
                        if (!TRACE_LOGGER.isInfoEnabled()) break block2;
                        TRACE_LOGGER.info(String.format(Locale.US, "path[%s], linkName[%s], tokenRenewalScheduleFailure[%s]", MessageReceiver.this.receivePath, MessageReceiver.this.receiveLink.getName(), exception.getMessage()));
                    }
                }
            }
        }, ClientConstants.TOKEN_REFRESH_INTERVAL, this.underlyingFactory);
    }

    public static CompletableFuture<MessageReceiver> create(MessagingFactory factory, String name, String recvPath, int prefetchCount, ReceiverSettingsProvider settingsProvider) {
        MessageReceiver msgReceiver = new MessageReceiver(factory, name, recvPath, prefetchCount, settingsProvider);
        return msgReceiver.createLink();
    }

    public String getReceivePath() {
        return this.receivePath;
    }

    private CompletableFuture<MessageReceiver> createLink() {
        this.scheduleLinkOpenTimeout(this.linkOpen.getTimeoutTracker());
        try {
            this.underlyingFactory.scheduleOnReactorThread(new DispatchHandler(){

                @Override
                public void onEvent() {
                    MessageReceiver.this.createReceiveLink();
                }
            });
        }
        catch (IOException | RejectedExecutionException schedulerException) {
            this.linkOpen.getWork().completeExceptionally(schedulerException);
        }
        return this.linkOpen.getWork();
    }

    private List<Message> receiveCore(int messageCount) {
        Message currentMessage;
        LinkedList<Message> returnMessages = null;
        while ((currentMessage = this.pollPrefetchQueue()) != null) {
            if (returnMessages == null) {
                returnMessages = new LinkedList<Message>();
            }
            returnMessages.add(currentMessage);
            if (returnMessages.size() < messageCount) continue;
            break;
        }
        return returnMessages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPrefetchCount() {
        Object object = this.prefetchCountSync;
        synchronized (object) {
            return this.prefetchCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPrefetchCount(int value) throws EventHubException {
        int deltaPrefetchCount;
        Object object = this.prefetchCountSync;
        synchronized (object) {
            deltaPrefetchCount = value - this.prefetchCount;
            this.prefetchCount = value;
        }
        try {
            this.underlyingFactory.scheduleOnReactorThread(new DispatchHandler(){

                @Override
                public void onEvent() {
                    MessageReceiver.this.sendFlow(deltaPrefetchCount);
                }
            });
        }
        catch (IOException | RejectedExecutionException schedulerException) {
            throw new EventHubException(false, "Setting prefetch count failed, see cause for more details", schedulerException);
        }
    }

    public Duration getReceiveTimeout() {
        return this.receiveTimeout;
    }

    public void setReceiveTimeout(Duration value) {
        this.receiveTimeout = value;
    }

    public CompletableFuture<Collection<Message>> receive(int maxMessageCount) {
        this.throwIfClosed();
        if (maxMessageCount <= 0 || maxMessageCount > this.prefetchCount) {
            throw new IllegalArgumentException(String.format(Locale.US, "parameter 'maxMessageCount' should be a positive number and should be less than prefetchCount(%s)", this.prefetchCount));
        }
        if (this.pendingReceives.isEmpty()) {
            this.timer.schedule(this.onOperationTimedout, this.receiveTimeout);
        }
        CompletableFuture<Collection<Message>> onReceive = new CompletableFuture<Collection<Message>>();
        this.pendingReceives.offer(new ReceiveWorkItem(onReceive, this.receiveTimeout, maxMessageCount));
        try {
            this.underlyingFactory.scheduleOnReactorThread(this.createAndReceive);
        }
        catch (IOException | RejectedExecutionException schedulerException) {
            onReceive.completeExceptionally(schedulerException);
        }
        return onReceive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onOpenComplete(Exception exception) {
        this.creatingLink = false;
        if (exception == null) {
            if (this.getIsClosingOrClosed()) {
                this.receiveLink.close();
                return;
            }
            if (this.linkOpen != null && !this.linkOpen.getWork().isDone()) {
                this.linkOpen.getWork().complete(this);
                if (this.openTimer != null) {
                    this.openTimer.cancel(false);
                }
            }
            Object object = this.errorConditionLock;
            synchronized (object) {
                this.lastKnownLinkError = null;
            }
            this.underlyingFactory.getRetryPolicy().resetRetryCount(this.underlyingFactory.getClientId());
            this.nextCreditToFlow = 0;
            this.sendFlow(this.prefetchCount - this.prefetchedMessages.size());
            if (TRACE_LOGGER.isInfoEnabled()) {
                TRACE_LOGGER.info(String.format("receiverPath[%s], linkname[%s], updated-link-credit[%s], sentCredits[%s]", this.receivePath, this.receiveLink.getName(), this.receiveLink.getCredit(), this.prefetchCount));
            }
        } else {
            if (this.linkOpen != null && !this.linkOpen.getWork().isDone()) {
                this.setClosed();
                ExceptionUtil.completeExceptionally(this.linkOpen.getWork(), exception, this);
                if (this.openTimer != null) {
                    this.openTimer.cancel(false);
                }
            }
            Object object = this.errorConditionLock;
            synchronized (object) {
                this.lastKnownLinkError = exception;
            }
        }
    }

    @Override
    public void onReceiveComplete(Delivery delivery) {
        int msgSize = delivery.pending();
        byte[] buffer = new byte[msgSize];
        int read = this.receiveLink.recv(buffer, 0, msgSize);
        Message message = Proton.message();
        message.decode(buffer, 0, read);
        delivery.settle();
        this.prefetchedMessages.add(message);
        this.underlyingFactory.getRetryPolicy().resetRetryCount(this.getClientId());
        this.receiveWork.onEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onError(Exception exception) {
        this.prefetchedMessages.clear();
        this.underlyingFactory.deregisterForConnectionError((Link)this.receiveLink);
        if (this.getIsClosingOrClosed()) {
            boolean isTransientException;
            if (this.closeTimer != null) {
                this.closeTimer.cancel(false);
            }
            WorkItem workItem = null;
            boolean bl = isTransientException = exception == null || exception instanceof EventHubException && ((EventHubException)exception).getIsTransient();
            while ((workItem = (WorkItem)this.pendingReceives.poll()) != null) {
                CompletableFuture<Object> future = workItem.getWork();
                if (isTransientException) {
                    future.complete(null);
                    continue;
                }
                ExceptionUtil.completeExceptionally(future, exception, this);
            }
            this.linkClose.complete(null);
        } else {
            Object workItem = this.errorConditionLock;
            synchronized (workItem) {
                this.lastKnownLinkError = exception == null ? this.lastKnownLinkError : exception;
            }
            Exception completionException = exception == null ? new EventHubException(true, "Client encountered transient error for unknown reasons, please retry the operation.") : exception;
            this.onOpenComplete(completionException);
            WorkItem workItem2 = this.pendingReceives.peek();
            Duration nextRetryInterval = workItem2 != null && workItem2.getTimeoutTracker() != null ? this.underlyingFactory.getRetryPolicy().getNextRetryInterval(this.getClientId(), completionException, workItem2.getTimeoutTracker().remaining()) : null;
            boolean recreateScheduled = true;
            if (nextRetryInterval != null) {
                try {
                    this.underlyingFactory.scheduleOnReactorThread((int)nextRetryInterval.toMillis(), new DispatchHandler(){

                        @Override
                        public void onEvent() {
                            if (!(MessageReceiver.this.getIsClosingOrClosed() || MessageReceiver.this.receiveLink.getLocalState() != EndpointState.CLOSED && MessageReceiver.this.receiveLink.getRemoteState() != EndpointState.CLOSED)) {
                                MessageReceiver.this.createReceiveLink();
                                MessageReceiver.this.underlyingFactory.getRetryPolicy().incrementRetryCount(MessageReceiver.this.getClientId());
                            }
                        }
                    });
                }
                catch (IOException | RejectedExecutionException ignore) {
                    recreateScheduled = false;
                }
            }
            if (nextRetryInterval == null || !recreateScheduled) {
                WorkItem pendingReceive = null;
                while ((pendingReceive = (WorkItem)this.pendingReceives.poll()) != null) {
                    ExceptionUtil.completeExceptionally(pendingReceive.getWork(), completionException, this);
                }
            }
        }
    }

    private void scheduleOperationTimer(TimeoutTracker tracker) {
        if (tracker != null) {
            this.timer.schedule(this.onOperationTimedout, tracker.remaining());
        }
    }

    private void createReceiveLink() {
        if (this.creatingLink) {
            return;
        }
        this.creatingLink = true;
        final Consumer<Session> onSessionOpen = new Consumer<Session>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void accept(Session session) {
                Symbol[] desiredCapabilities;
                if (MessageReceiver.this.getIsClosingOrClosed()) {
                    session.close();
                    return;
                }
                Source source = new Source();
                source.setAddress(MessageReceiver.this.receivePath);
                Map<Symbol, UnknownDescribedType> filterMap = MessageReceiver.this.settingsProvider.getFilter(MessageReceiver.this.lastReceivedMessage);
                if (filterMap != null) {
                    source.setFilter(filterMap);
                }
                Receiver receiver = session.receiver(TrackingUtil.getLinkName(session));
                receiver.setSource((org.apache.qpid.proton.amqp.transport.Source)source);
                Target target = new Target();
                receiver.setTarget((org.apache.qpid.proton.amqp.transport.Target)target);
                receiver.setSenderSettleMode(SenderSettleMode.UNSETTLED);
                receiver.setReceiverSettleMode(ReceiverSettleMode.SECOND);
                Map<Symbol, Object> linkProperties = MessageReceiver.this.settingsProvider.getProperties();
                if (linkProperties != null) {
                    receiver.setProperties(linkProperties);
                }
                if ((desiredCapabilities = MessageReceiver.this.settingsProvider.getDesiredCapabilities()) != null) {
                    receiver.setDesiredCapabilities(desiredCapabilities);
                }
                ReceiveLinkHandler handler = new ReceiveLinkHandler(MessageReceiver.this);
                BaseHandler.setHandler((Extendable)receiver, (Handler)handler);
                MessageReceiver.this.underlyingFactory.registerForConnectionError((Link)receiver);
                receiver.open();
                Object object = MessageReceiver.this.errorConditionLock;
                synchronized (object) {
                    MessageReceiver.this.receiveLink = receiver;
                }
            }
        };
        final BiConsumer<ErrorCondition, Exception> onSessionOpenFailed = new BiConsumer<ErrorCondition, Exception>(){

            @Override
            public void accept(ErrorCondition t, Exception u) {
                if (t != null) {
                    MessageReceiver.this.onError(t.getCondition() != null ? ExceptionUtil.toException(t) : null);
                } else if (u != null) {
                    MessageReceiver.this.onError(u);
                }
            }
        };
        try {
            this.underlyingFactory.getCBSChannel().sendToken(this.underlyingFactory.getReactorScheduler(), this.underlyingFactory.getTokenProvider().getToken(this.tokenAudience, ClientConstants.TOKEN_VALIDITY), this.tokenAudience, new OperationResult<Void, Exception>(){

                @Override
                public void onComplete(Void result) {
                    if (MessageReceiver.this.getIsClosingOrClosed()) {
                        return;
                    }
                    MessageReceiver.this.underlyingFactory.getSession(MessageReceiver.this.receivePath, onSessionOpen, onSessionOpenFailed);
                }

                @Override
                public void onError(Exception error) {
                    Exception completionException;
                    if (error != null && error instanceof AmqpException) {
                        completionException = ExceptionUtil.toException(((AmqpException)error).getError());
                        if (completionException != error && completionException.getCause() == null) {
                            completionException.initCause(error);
                        }
                    } else {
                        completionException = error;
                    }
                    MessageReceiver.this.onError(completionException);
                }
            });
        }
        catch (IOException | RuntimeException | InvalidKeyException | NoSuchAlgorithmException exception) {
            this.onError(exception);
        }
    }

    private Message pollPrefetchQueue() {
        Message message = this.prefetchedMessages.poll();
        if (message != null) {
            this.lastReceivedMessage = message;
            this.sendFlow(1);
        }
        return message;
    }

    private void sendFlow(int credits) {
        this.nextCreditToFlow += credits;
        if (this.nextCreditToFlow >= this.prefetchCount || this.nextCreditToFlow >= 100) {
            int tempFlow = this.nextCreditToFlow;
            this.receiveLink.flow(tempFlow);
            this.nextCreditToFlow = 0;
            if (TRACE_LOGGER.isDebugEnabled()) {
                TRACE_LOGGER.debug(String.format("receiverPath[%s], linkname[%s], updated-link-credit[%s], sentCredits[%s], ThreadId[%s]", this.receivePath, this.receiveLink.getName(), this.receiveLink.getCredit(), tempFlow, Thread.currentThread().getId()));
            }
        }
    }

    private void scheduleLinkOpenTimeout(TimeoutTracker timeout) {
        this.openTimer = this.timer.schedule(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (!MessageReceiver.this.linkOpen.getWork().isDone()) {
                    Exception lastReportedLinkError;
                    Receiver link;
                    Object object = MessageReceiver.this.errorConditionLock;
                    synchronized (object) {
                        link = MessageReceiver.this.receiveLink;
                        lastReportedLinkError = MessageReceiver.this.lastKnownLinkError;
                    }
                    TimeoutException operationTimedout = new TimeoutException(String.format(Locale.US, "%s operation on ReceiveLink(%s) to path(%s) timed out at %s.", "Open", link.getName(), MessageReceiver.this.receivePath, ZonedDateTime.now()), (Throwable)lastReportedLinkError);
                    if (TRACE_LOGGER.isWarnEnabled()) {
                        TRACE_LOGGER.warn(String.format(Locale.US, "receiverPath[%s], linkName[%s], %s call timedout", MessageReceiver.this.receivePath, link.getName(), "Open"), (Throwable)operationTimedout);
                    }
                    ExceptionUtil.completeExceptionally(MessageReceiver.this.linkOpen.getWork(), operationTimedout, MessageReceiver.this);
                }
            }
        }, timeout.remaining());
        this.openTimer.whenCompleteAsync((unUsed, exception) -> {
            if (exception != null && exception instanceof Exception && !(exception instanceof CancellationException)) {
                ExceptionUtil.completeExceptionally(this.linkOpen.getWork(), (Exception)exception, this);
            }
        }, this.executor);
    }

    private void scheduleLinkCloseTimeout(TimeoutTracker timeout) {
        this.closeTimer = this.timer.schedule(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (!MessageReceiver.this.linkClose.isDone()) {
                    Receiver link;
                    Object object = MessageReceiver.this.errorConditionLock;
                    synchronized (object) {
                        link = MessageReceiver.this.receiveLink;
                    }
                    TimeoutException operationTimedout = new TimeoutException(String.format(Locale.US, "%s operation on Receive Link(%s) timed out at %s", "Close", link.getName(), ZonedDateTime.now()));
                    if (TRACE_LOGGER.isInfoEnabled()) {
                        TRACE_LOGGER.info(String.format(Locale.US, "receiverPath[%s], linkName[%s], %s call timedout", MessageReceiver.this.receivePath, link.getName(), "Close"), (Throwable)operationTimedout);
                    }
                    ExceptionUtil.completeExceptionally(MessageReceiver.this.linkClose, operationTimedout, MessageReceiver.this);
                    MessageReceiver.this.onError(null);
                }
            }
        }, timeout.remaining());
        this.closeTimer.whenCompleteAsync((unUsed, exception) -> {
            if (exception != null && exception instanceof Exception && !(exception instanceof CancellationException)) {
                ExceptionUtil.completeExceptionally(this.linkClose, (Exception)exception, this);
            }
        }, this.executor);
    }

    @Override
    public void onClose(ErrorCondition condition) {
        Exception completionException = condition != null && condition.getCondition() != null ? ExceptionUtil.toException(condition) : null;
        this.onError(completionException);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ErrorContext getContext() {
        boolean isLinkOpened;
        Receiver link;
        Object object = this.errorConditionLock;
        synchronized (object) {
            link = this.receiveLink;
        }
        boolean bl = isLinkOpened = this.linkOpen != null && this.linkOpen.getWork().isDone();
        String referenceId = link != null && link.getRemoteProperties() != null && link.getRemoteProperties().containsKey(ClientConstants.TRACKING_ID_PROPERTY) ? link.getRemoteProperties().get(ClientConstants.TRACKING_ID_PROPERTY).toString() : (link != null ? link.getName() : null);
        ReceiverContext errorContext = new ReceiverContext(this.underlyingFactory != null ? this.underlyingFactory.getHostName() : null, this.receivePath, referenceId, isLinkOpened ? Integer.valueOf(this.prefetchCount) : null, isLinkOpened && link != null ? Integer.valueOf(link.getCredit()) : null, isLinkOpened && this.prefetchedMessages != null ? Integer.valueOf(this.prefetchedMessages.size()) : null);
        return errorContext;
    }

    @Override
    protected CompletableFuture<Void> onClose() {
        if (!this.getIsClosed()) {
            try {
                this.activeClientTokenManager.cancel();
                this.scheduleLinkCloseTimeout(TimeoutTracker.create(this.operationTimeout));
                this.underlyingFactory.scheduleOnReactorThread(new DispatchHandler(){

                    @Override
                    public void onEvent() {
                        if (MessageReceiver.this.receiveLink != null && MessageReceiver.this.receiveLink.getLocalState() != EndpointState.CLOSED) {
                            MessageReceiver.this.receiveLink.close();
                        } else if (MessageReceiver.this.receiveLink == null || MessageReceiver.this.receiveLink.getRemoteState() == EndpointState.CLOSED) {
                            if (MessageReceiver.this.closeTimer != null) {
                                MessageReceiver.this.closeTimer.cancel(false);
                            }
                            MessageReceiver.this.linkClose.complete(null);
                        }
                    }
                });
            }
            catch (IOException | RejectedExecutionException schedulerException) {
                this.linkClose.completeExceptionally(schedulerException);
            }
        }
        return this.linkClose;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Exception getLastKnownError() {
        Object object = this.errorConditionLock;
        synchronized (object) {
            return this.lastKnownLinkError;
        }
    }

    private final class CreateAndReceive
    extends DispatchHandler {
        private CreateAndReceive() {
        }

        @Override
        public void onEvent() {
            MessageReceiver.this.receiveWork.onEvent();
            if (!(MessageReceiver.this.getIsClosingOrClosed() || MessageReceiver.this.receiveLink.getLocalState() != EndpointState.CLOSED && MessageReceiver.this.receiveLink.getRemoteState() != EndpointState.CLOSED)) {
                MessageReceiver.this.createReceiveLink();
            }
        }
    }

    private final class ReceiveWork
    extends DispatchHandler {
        private ReceiveWork() {
        }

        @Override
        public void onEvent() {
            ReceiveWorkItem pendingReceive;
            while (!MessageReceiver.this.prefetchedMessages.isEmpty() && (pendingReceive = (ReceiveWorkItem)MessageReceiver.this.pendingReceives.poll()) != null) {
                if (pendingReceive.getWork() == null || pendingReceive.getWork().isDone()) continue;
                List receivedMessages = MessageReceiver.this.receiveCore(pendingReceive.maxMessageCount);
                pendingReceive.getWork().complete(receivedMessages);
            }
        }
    }

    private static class ReceiveWorkItem
    extends WorkItem<Collection<Message>> {
        private final int maxMessageCount;

        public ReceiveWorkItem(CompletableFuture<Collection<Message>> completableFuture, Duration timeout, int maxMessageCount) {
            super(completableFuture, timeout);
            this.maxMessageCount = maxMessageCount;
        }
    }
}

