/*
 * Decompiled with CFR 0.152.
 */
package net.jradius.packet.attribute;

import net.jradius.packet.attribute.RadiusAttribute;

public abstract class VSAttribute
extends RadiusAttribute {
    private static final long serialVersionUID = 0L;
    protected long vendorId;
    protected long vsaAttributeType;
    protected short typeLength = 1;
    protected short lengthLength = 1;
    protected short extraLength = 0;
    protected boolean hasContinuationByte;
    protected short continuation;
    protected boolean grouped = false;

    public void setFormat(String format) {
        String[] s = format.split(",");
        if (s != null && s.length > 0) {
            this.typeLength = Short.parseShort(s[0]);
            if (s.length > 1) {
                this.lengthLength = Short.parseShort(s[1]);
            }
            if (s.length > 2 && s[2].equals("c")) {
                this.hasContinuationByte = true;
            }
        }
    }

    public long getFormattedType() {
        return this.vsaAttributeType | this.vendorId << 16;
    }

    public long getVendorId() {
        return this.vendorId;
    }

    public void setVendorId(long vendorId) {
        this.vendorId = vendorId;
    }

    public long getVsaAttributeType() {
        return this.vsaAttributeType;
    }

    public void setVsaAttributeType(long vsaAttributeType) {
        this.vsaAttributeType = vsaAttributeType;
    }

    public short getTypeLength() {
        return this.typeLength;
    }

    public short getLengthLength() {
        return this.lengthLength;
    }

    public short getExtraLength() {
        return this.extraLength;
    }

    public boolean hasContinuationByte() {
        return this.hasContinuationByte;
    }

    public int getContinuation() {
        return this.continuation;
    }

    public void setContinuation(short cont) {
        this.continuation = cont;
    }

    public void setContinuation() {
        this.setContinuation((short)128);
    }

    public void unsetContinuation() {
        this.setContinuation((short)0);
    }

    public boolean isGrouped() {
        return this.grouped;
    }

    public void setGrouped(boolean grouped) {
        this.grouped = grouped;
    }
}

