/*
 * Decompiled with CFR 0.152.
 */
package onl.netfishers.netshot.compliance.rules;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.script.Bindings;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.xml.bind.annotation.XmlElement;
import onl.netfishers.netshot.compliance.CheckResult;
import onl.netfishers.netshot.compliance.Policy;
import onl.netfishers.netshot.compliance.Rule;
import onl.netfishers.netshot.device.Device;
import onl.netfishers.netshot.device.DeviceDataProvider;
import onl.netfishers.netshot.device.DeviceDriver;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MarkerFactory;

@Entity
public class JavaScriptRule
extends Rule {
    private static Logger logger = LoggerFactory.getLogger(JavaScriptRule.class);
    private String script = "/*\n * Script template - to be customized.\n */\nfunction check(device) {\n    //var config = device.get('runningConfig');\n    //var name = device.get('name');\n    return CONFORMING;\n    //return NONCONFORMING;\n    //return NOTAPPLICABLE;\n}\n";
    private static String JSLOADER;
    private ScriptEngine engine;
    private static CheckResult.ResultOption[] ALLOWED_RESULTS;
    private boolean prepared = false;
    private boolean jsValid = false;

    protected JavaScriptRule() {
    }

    public JavaScriptRule(String name, Policy policy) {
        super(name, policy);
    }

    @XmlElement
    @Column(length=10000000)
    public String getScript() {
        return this.script;
    }

    public void setScript(String script) {
        this.script = script;
    }

    private void prepare() {
        if (this.prepared) {
            return;
        }
        this.prepared = true;
        try {
            this.engine = new ScriptEngineManager().getEngineByName("nashorn");
            this.engine.eval("delete load, com, edu, java, javafx, javax, org, JavaImporter, Java, loadWithNewGlobal;");
            this.engine.eval(this.script);
            this.engine.eval(JSLOADER);
            try {
                ((Invocable)((Object)this.engine)).invokeFunction("check", new Object[0]);
                this.jsValid = true;
            }
            catch (NoSuchMethodException e) {
                logger.warn("The check function wasn't found in the script");
                this.logIt("The 'check' function couldn't be found in the script.", 2);
            }
            catch (Exception e) {
                this.jsValid = true;
            }
        }
        catch (ScriptException e) {
            this.logIt("Error while evaluating the Javascript script.", 2);
            logger.warn("Error while evaluating the Javascript script.", e);
            this.jsValid = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void check(Device device, Session session) {
        if (!this.isEnabled()) {
            this.setCheckResult(device, CheckResult.ResultOption.DISABLED, "", session);
            return;
        }
        this.prepare();
        if (!this.jsValid) {
            this.setCheckResult(device, CheckResult.ResultOption.INVALIDRULE, "", session);
            return;
        }
        if (device.isExempted(this)) {
            this.setCheckResult(device, CheckResult.ResultOption.EXEMPTED, "", session);
            return;
        }
        DeviceDataProvider dataProvider = new DeviceDataProvider(session, device);
        try {
            Object result = ((Invocable)((Object)this.engine)).invokeFunction("_check", dataProvider);
            if (result != null && result instanceof Bindings) {
                String comment = "";
                Object jsComment = ((Bindings)result).get("comment");
                if (jsComment != null && jsComment instanceof String) {
                    comment = (String)jsComment;
                }
                Object jsResult = ((Bindings)result).get("result");
                for (CheckResult.ResultOption allowedResult : ALLOWED_RESULTS) {
                    if (!allowedResult.toString().equals(jsResult)) continue;
                    this.logIt(String.format("The script returned %s (%d), comment '%s'.", allowedResult.toString(), allowedResult.getValue(), comment), 2);
                    this.setCheckResult(device, allowedResult, comment, session);
                    return;
                }
            }
        }
        catch (Exception e) {
            this.logIt("Error while running the script: " + e.getMessage(), 2);
            logger.error("Error while running the script on device {}.", (Object)device.getId(), (Object)e);
        }
        finally {
            this.logIt(dataProvider.getLog());
        }
        this.setCheckResult(device, CheckResult.ResultOption.INVALIDRULE, "", session);
    }

    static {
        try {
            logger.info("Reading the JavaScript rule loader code from the resource JS file.");
            String path = "interfaces/rule-loader.js";
            InputStream in = DeviceDriver.class.getResourceAsStream("/" + path);
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            StringBuffer buffer = new StringBuffer();
            String line = null;
            while ((line = reader.readLine()) != null) {
                buffer.append(line + "\n");
            }
            JSLOADER = buffer.toString();
            reader.close();
            in.close();
            logger.debug("The JavaScript rule loader code has been read from the resource JS file.");
        }
        catch (Exception e) {
            logger.error(MarkerFactory.getMarker("FATAL"), "Unable to read the Javascript rule loader.", e);
            System.err.println("NETSHOT FATAL ERROR");
            e.printStackTrace();
            System.exit(1);
        }
        ALLOWED_RESULTS = new CheckResult.ResultOption[]{CheckResult.ResultOption.CONFORMING, CheckResult.ResultOption.NONCONFORMING, CheckResult.ResultOption.NOTAPPLICABLE};
    }
}

