/*
 * Decompiled with CFR 0.152.
 */
package onl.netfishers.netshot.device;

import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Version;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import onl.netfishers.netshot.device.Network4Address;
import onl.netfishers.netshot.device.Network6Address;
import onl.netfishers.netshot.device.credentials.DeviceCredentialSet;
import onl.netfishers.netshot.work.tasks.DiscoverDeviceTypeTask;
import onl.netfishers.netshot.work.tasks.ScanSubnetsTask;
import org.hibernate.annotations.NaturalId;

@Entity
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.NONE)
public class Domain {
    private long id;
    private Date changeDate;
    private int version;
    private String name;
    private String description;
    private Set<DeviceCredentialSet> credentialSets = new HashSet<DeviceCredentialSet>();
    private Network4Address server4Address;
    private Network6Address server6Address;
    private Set<DiscoverDeviceTypeTask> discoverDeviceTypeTasks;
    private Set<ScanSubnetsTask> scanSubnetsTasks;

    protected Domain() {
    }

    public Domain(String name, String description, Network4Address server4Address, Network6Address server6Address) {
        this.name = name;
        this.description = description;
        this.server4Address = server4Address;
        this.server6Address = server6Address;
    }

    @XmlAttribute
    @Id
    @GeneratedValue
    public long getId() {
        return this.id;
    }

    @XmlElement
    @NaturalId(mutable=true)
    public String getName() {
        return this.name;
    }

    @XmlElement
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @XmlElement
    @AttributeOverrides(value={@AttributeOverride(name="address", column=@Column(name="ipv4_address")), @AttributeOverride(name="prefixLength", column=@Column(name="ipv4_pfxlen")), @AttributeOverride(name="addressUsage", column=@Column(name="ipv4_usage"))})
    public Network4Address getServer4Address() {
        return this.server4Address;
    }

    @AttributeOverrides(value={@AttributeOverride(name="address1", column=@Column(name="ipv6_address1")), @AttributeOverride(name="address2", column=@Column(name="ipv6_address2")), @AttributeOverride(name="prefixLength", column=@Column(name="ipv6_pfxlen")), @AttributeOverride(name="addressUsage", column=@Column(name="ipv6_usage"))})
    public Network6Address getServer6Address() {
        return this.server6Address;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setServer4Address(Network4Address server4Address) {
        this.server4Address = server4Address;
    }

    public void setServer6Address(Network6Address server6Address) {
        this.server6Address = server6Address;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Domain)) {
            return false;
        }
        Domain other = (Domain)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    @OneToMany(mappedBy="mgmtDomain", cascade={CascadeType.ALL})
    public Set<DeviceCredentialSet> getCredentialSets() {
        return this.credentialSets;
    }

    public void setCredentialSets(Set<DeviceCredentialSet> credentialSets) {
        this.credentialSets = credentialSets;
    }

    @XmlElement
    public Date getChangeDate() {
        return this.changeDate;
    }

    public void setChangeDate(Date changeDate) {
        this.changeDate = changeDate;
    }

    @Version
    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    protected void setId(long id) {
        this.id = id;
    }

    @OneToMany(mappedBy="domain", cascade={CascadeType.ALL})
    public Set<DiscoverDeviceTypeTask> getDiscoverDeviceTypeTasks() {
        return this.discoverDeviceTypeTasks;
    }

    public void setDiscoverDeviceTypeTasks(Set<DiscoverDeviceTypeTask> discoverDeviceTypeTasks) {
        this.discoverDeviceTypeTasks = discoverDeviceTypeTasks;
    }

    @OneToMany(mappedBy="domain", cascade={CascadeType.ALL})
    public Set<ScanSubnetsTask> getScanSubnetsTasks() {
        return this.scanSubnetsTasks;
    }

    public void setScanSubnetsTasks(Set<ScanSubnetsTask> scanSubnetsTasks) {
        this.scanSubnetsTasks = scanSubnetsTasks;
    }
}

