/*
 * Decompiled with CFR 0.152.
 */
package onl.netfishers.netshot.device.access;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.Identity;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.KeyPair;
import com.jcraft.jsch.Session;
import java.io.IOException;
import java.io.PrintStream;
import onl.netfishers.netshot.device.NetworkAddress;
import onl.netfishers.netshot.device.access.Cli;

public class Ssh
extends Cli {
    private int port = 22;
    private JSch jsch;
    private Session session;
    private Channel channel;
    private String username;
    private String password;
    private String publicKey = null;
    private String privateKey = null;

    public Ssh(NetworkAddress host, int port, String username, String password) {
        super(host);
        if (port != 0) {
            this.port = port;
        }
        this.username = username;
        this.password = password;
        this.privateKey = null;
    }

    public Ssh(NetworkAddress host, int port, String username, String publicKey, String privateKey, String passphrase) {
        super(host);
        if (port != 0) {
            this.port = port;
        }
        this.username = username;
        this.publicKey = publicKey;
        this.privateKey = privateKey;
        this.password = passphrase;
    }

    public Ssh(NetworkAddress host, String username, String publicKey, String privateKey, String passphrase) {
        super(host);
        this.username = username;
        this.publicKey = publicKey;
        this.privateKey = privateKey;
        this.password = passphrase;
    }

    public Ssh(NetworkAddress host, String username, String password) {
        super(host);
        this.username = username;
        this.password = password;
        this.privateKey = null;
    }

    @Override
    public void connect() throws IOException {
        this.jsch = new JSch();
        try {
            if (this.privateKey != null && this.publicKey != null) {
                final KeyPair kpair = KeyPair.load(this.jsch, this.privateKey.getBytes(), this.publicKey.getBytes());
                this.jsch.addIdentity(new Identity(){

                    @Override
                    public boolean setPassphrase(byte[] passphrase) throws JSchException {
                        return kpair.decrypt(passphrase);
                    }

                    @Override
                    public boolean isEncrypted() {
                        return kpair.isEncrypted();
                    }

                    @Override
                    public byte[] getSignature(byte[] data) {
                        return kpair.getSignature(data);
                    }

                    @Override
                    public byte[] getPublicKeyBlob() {
                        return kpair.getPublicKeyBlob();
                    }

                    @Override
                    public String getName() {
                        return "Key";
                    }

                    @Override
                    public String getAlgName() {
                        switch (kpair.getKeyType()) {
                            case 2: {
                                return "ssh-rsa";
                            }
                            case 1: {
                                return "ssh-dss";
                            }
                            case 0: {
                                return "ERROR";
                            }
                        }
                        return "UNKNOWN";
                    }

                    @Override
                    public boolean decrypt() {
                        throw new RuntimeException("Not implemented");
                    }

                    @Override
                    public void clear() {
                        kpair.dispose();
                    }
                }, this.password == null ? null : this.password.getBytes());
            }
            this.session = this.jsch.getSession(this.username, this.host.getIp(), this.port);
            if (this.privateKey == null || this.publicKey == null) {
                this.session.setPassword(this.password);
            }
            this.session.setConfig("StrictHostKeyChecking", "no");
            this.session.setTimeout(this.receiveTimeout);
            this.session.connect(this.connectionTimeout);
            this.channel = this.session.openChannel("shell");
            this.inStream = this.channel.getInputStream();
            this.outStream = new PrintStream(this.channel.getOutputStream());
            this.channel.connect(this.connectionTimeout);
        }
        catch (JSchException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    @Override
    public void disconnect() {
        try {
            this.channel.disconnect();
            this.session.disconnect();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

