/*
 * Decompiled with CFR 0.152.
 */
package onl.netfishers.netshot.work.tasks;

import java.util.Calendar;
import java.util.Date;
import javax.persistence.Entity;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlElement;
import onl.netfishers.netshot.Database;
import onl.netfishers.netshot.device.Config;
import onl.netfishers.netshot.work.Task;
import org.hibernate.CacheMode;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
public class PurgeDatabaseTask
extends Task {
    private static Logger logger = LoggerFactory.getLogger(PurgeDatabaseTask.class);
    private int days;
    private int configDays = -1;
    private int configSize = 0;
    private int configKeepDays = 0;

    protected PurgeDatabaseTask() {
    }

    public PurgeDatabaseTask(String comments, String author, int days, int configDays, int configSize, int configKeepDays) {
        super(comments, "Global", author);
        this.days = days;
        this.configDays = configDays;
        this.configSize = configSize;
        this.configKeepDays = configKeepDays;
    }

    @Override
    @XmlElement
    @Transient
    public String getTaskDescription() {
        return "Database purge";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Calendar when;
        logger.debug("Starting cleanup process.");
        try (Session session = Database.getSession();){
            session.beginTransaction();
            logger.trace("Cleaning up tasks finished more than {} days ago...", (Object)this.days);
            this.logIt(String.format("Cleaning up tasks more than %d days ago...", this.days), 5);
            when = Calendar.getInstance();
            when.add(5, -1 * this.days);
            ScrollableResults tasks = session.createQuery("from Task t where (t.status = :cancelled or t.status = :failure or t.status = :success) and (t.executionDate < :when)").setParameter("cancelled", (Object)Task.Status.CANCELLED).setParameter("failure", (Object)Task.Status.FAILURE).setParameter("success", (Object)Task.Status.SUCCESS).setDate("when", when.getTime()).setCacheMode(CacheMode.IGNORE).scroll(ScrollMode.FORWARD_ONLY);
            int count = 0;
            while (tasks.next()) {
                Task task = (Task)tasks.get(0);
                session.delete(task);
                if (++count % 50 != 0) continue;
                session.flush();
                session.clear();
            }
            session.getTransaction().commit();
            logger.trace("Cleaning up done on tasks, {} entries affected.", (Object)count);
            this.logIt(String.format("Cleaning up done on tasks, %d entries affected.", count), 5);
        }
        if (this.configDays > 0) {
            session = Database.getSession();
            try {
                session.beginTransaction();
                logger.trace("Cleaning up configurations taken more than {} days ago...", (Object)this.configDays);
                this.logIt(String.format("Cleaning up configurations older than %d days...", this.configDays), 5);
                when = Calendar.getInstance();
                when.add(5, -1 * this.configDays);
                Query query = this.configSize > 0 ? session.createQuery("select c from Config c join c.attributes a where (a.class = ConfigLongTextAttribute) group by c.id having (max(length(a.longText.text)) > :size) and (c.changeDate < :when) order by c.device asc, c.changeDate desc").setInteger("size", this.configSize * 1024) : session.createQuery("from Config c where (c.changeDate < :when) order by c.device asc, c.changeDate desc");
                ScrollableResults configs = query.setCalendar("when", when).setCacheMode(CacheMode.IGNORE).scroll(ScrollMode.FORWARD_ONLY);
                long dontDeleteDevice = -1L;
                Date dontDeleteBefore = null;
                int count = 0;
                while (configs.next()) {
                    try {
                        Config config = (Config)configs.get(0);
                        if (config.getDevice().getLastConfig() != null && config.getDevice().getLastConfig().getId() == config.getId() || dontDeleteBefore != null && config.getChangeDate().before(dontDeleteBefore) || this.configKeepDays > 0 && dontDeleteDevice != config.getDevice().getId()) {
                            if (this.configKeepDays > 0) {
                                Calendar limitCalendar = Calendar.getInstance();
                                limitCalendar.setTime(config.getChangeDate());
                                limitCalendar.add(5, -1 * this.configKeepDays);
                                dontDeleteBefore = limitCalendar.getTime();
                            }
                        } else {
                            session.delete(config);
                            if (++count % 30 == 0) {
                                session.flush();
                                session.clear();
                            }
                        }
                        dontDeleteDevice = config.getDevice().getId();
                    }
                    catch (NullPointerException nullPointerException) {}
                }
                session.getTransaction().commit();
                logger.trace("Cleaning up done on configurations, {} entries affected.", (Object)count);
                this.logIt(String.format("Cleaning up done on configurations, %d entries affected.", count), 5);
            }
            catch (HibernateException e) {
                try {
                    session.getTransaction().rollback();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                logger.error("Database error while purging the old configurations from the database.", e);
                this.logIt("Database error during the configuration purge.", 1);
                this.status = Task.Status.FAILURE;
                return;
            }
            catch (Exception e) {
                try {
                    session.getTransaction().rollback();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                logger.error("Error while purging the old configurations from the database.", e);
                this.logIt("Error during the configuration purge.", 1);
                this.status = Task.Status.FAILURE;
                return;
            }
            finally {
                session.close();
            }
        }
        this.status = Task.Status.SUCCESS;
        logger.trace("Cleaning up process finished.");
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        PurgeDatabaseTask task = (PurgeDatabaseTask)super.clone();
        return task;
    }

    @XmlElement
    public int getDays() {
        return this.days;
    }

    public void setDays(int days) {
        this.days = days;
    }

    @XmlElement
    public int getConfigDays() {
        return this.configDays;
    }

    public void setConfigDays(int configDays) {
        this.configDays = configDays;
    }

    @XmlElement
    public int getConfigSize() {
        return this.configSize;
    }

    public void setConfigSize(int configSize) {
        this.configSize = configSize;
    }

    @XmlElement
    public int getConfigKeepDays() {
        return this.configKeepDays;
    }

    public void setConfigKeepDays(int configKeepDays) {
        this.configKeepDays = configKeepDays;
    }
}

