/*
 * Decompiled with CFR 0.152.
 */
package onl.netfishers.netshot.work.tasks;

import java.util.Calendar;
import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlElement;
import onl.netfishers.netshot.TaskManager;
import onl.netfishers.netshot.device.Device;
import onl.netfishers.netshot.device.DeviceGroup;
import onl.netfishers.netshot.work.Task;
import onl.netfishers.netshot.work.tasks.TakeSnapshotTask;
import org.hibernate.Hibernate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
public class TakeGroupSnapshotTask
extends Task {
    private static Logger logger = LoggerFactory.getLogger(TakeGroupSnapshotTask.class);
    private DeviceGroup deviceGroup;
    private int limitToOutofdateDeviceHours = -1;

    public TakeGroupSnapshotTask() {
    }

    public TakeGroupSnapshotTask(DeviceGroup group, String comments, String author, int limitToOutofdateDeviceHours) {
        super(comments, group.getName(), author);
        this.deviceGroup = group;
        this.limitToOutofdateDeviceHours = limitToOutofdateDeviceHours;
    }

    @Override
    @XmlElement
    @Transient
    public String getTaskDescription() {
        return "Group snapshot";
    }

    @Override
    public void prepare() {
        Hibernate.initialize(this.getDeviceGroup());
        Hibernate.initialize(this.getDeviceGroup().getCachedDevices());
    }

    @Override
    public void run() {
        logger.debug("Starting snapshot task for group {}.", (Object)this.getDeviceGroup().getId());
        Set<Device> devices = this.getDeviceGroup().getCachedDevices();
        logger.debug("{} devices in the group.", (Object)devices.size());
        String comment = String.format("Started due to group %s snapshot", this.getDeviceGroup().getName());
        Calendar referenceDate = Calendar.getInstance();
        referenceDate.add(10, -this.getLimitToOutofdateDeviceHours());
        for (Device device : devices) {
            if (referenceDate.getTime().before(device.getChangeDate())) {
                this.logIt(String.format("Ignoring device %s because it changed less than %d hours ago", device.getName(), this.getLimitToOutofdateDeviceHours()), 5);
                continue;
            }
            this.logIt(String.format("Starting snapshot task for device %s.", device.getName()), 5);
            TakeSnapshotTask task = new TakeSnapshotTask(device, comment, this.author);
            try {
                TaskManager.addTask(task);
            }
            catch (Exception e) {
                logger.error("Error while scheduling the individual snapshot task.", e);
                this.logIt("Error while scheduling the task.", 1);
            }
        }
        logger.debug("Everything went fine.");
        this.status = Task.Status.SUCCESS;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    public DeviceGroup getDeviceGroup() {
        return this.deviceGroup;
    }

    public void setDeviceGroup(DeviceGroup deviceGroup) {
        this.deviceGroup = deviceGroup;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        TakeGroupSnapshotTask task = (TakeGroupSnapshotTask)super.clone();
        task.setDeviceGroup(this.deviceGroup);
        return task;
    }

    public int getLimitToOutofdateDeviceHours() {
        return this.limitToOutofdateDeviceHours;
    }

    public void setLimitToOutofdateDeviceHours(int limitToOutofdateDeviceHours) {
        this.limitToOutofdateDeviceHours = limitToOutofdateDeviceHours;
    }
}

