/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import org.hibernate.AssertionFailure;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.cfg.AnnotationBinder;
import org.hibernate.cfg.Mappings;
import org.hibernate.cfg.PropertyData;

public class ToOneBinder {
    public static String getReferenceEntityName(PropertyData propertyData, XClass targetEntity, Mappings mappings) {
        if (AnnotationBinder.isDefault(targetEntity, mappings)) {
            return propertyData.getClassOrElementName();
        }
        return targetEntity.getName();
    }

    public static String getReferenceEntityName(PropertyData propertyData, Mappings mappings) {
        XClass targetEntity = ToOneBinder.getTargetEntity(propertyData, mappings);
        if (AnnotationBinder.isDefault(targetEntity, mappings)) {
            return propertyData.getClassOrElementName();
        }
        return targetEntity.getName();
    }

    public static XClass getTargetEntity(PropertyData propertyData, Mappings mappings) {
        XProperty property = propertyData.getProperty();
        return mappings.getReflectionManager().toXClass(ToOneBinder.getTargetEntityClass(property));
    }

    private static Class<?> getTargetEntityClass(XProperty property) {
        ManyToOne mTo = property.getAnnotation(ManyToOne.class);
        if (mTo != null) {
            return mTo.targetEntity();
        }
        OneToOne oTo = property.getAnnotation(OneToOne.class);
        if (oTo != null) {
            return oTo.targetEntity();
        }
        throw new AssertionFailure("Unexpected discovery of a targetEntity: " + property.getName());
    }
}

