/*
 * Decompiled with CFR 0.152.
 */
package org.jasypt.hibernate4.type;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.usertype.ParameterizedType;
import org.hibernate.usertype.UserType;
import org.jasypt.encryption.pbe.PBEBigDecimalEncryptor;
import org.jasypt.encryption.pbe.StandardPBEBigDecimalEncryptor;
import org.jasypt.exceptions.EncryptionInitializationException;
import org.jasypt.hibernate4.encryptor.HibernatePBEEncryptorRegistry;

public final class EncryptedBigDecimalType
implements UserType,
ParameterizedType {
    private static final int sqlType = 2;
    private static final int[] sqlTypes = new int[]{2};
    private boolean initialized = false;
    private boolean useEncryptorName = false;
    private String encryptorName = null;
    private String algorithm = null;
    private String password = null;
    private Integer keyObtentionIterations = null;
    private Integer decimalScale = null;
    private PBEBigDecimalEncryptor encryptor = null;

    public int[] sqlTypes() {
        return (int[])sqlTypes.clone();
    }

    public Class returnedClass() {
        return BigDecimal.class;
    }

    public boolean equals(Object x, Object y) throws HibernateException {
        return x == y || x != null && y != null && x.equals(y);
    }

    public Object deepCopy(Object value) throws HibernateException {
        return value;
    }

    public Object assemble(Serializable cached, Object owner) throws HibernateException {
        if (cached == null) {
            return null;
        }
        return this.deepCopy(cached);
    }

    public Serializable disassemble(Object value) throws HibernateException {
        if (value == null) {
            return null;
        }
        return (Serializable)this.deepCopy(value);
    }

    public boolean isMutable() {
        return false;
    }

    public int hashCode(Object x) throws HibernateException {
        return x.hashCode();
    }

    public Object replace(Object original, Object target, Object owner) throws HibernateException {
        return original;
    }

    public Object nullSafeGet(ResultSet rs, String[] names, SessionImplementor session, Object owner) throws HibernateException, SQLException {
        this.checkInitialization();
        BigDecimal storedEncryptedMessage = rs.getBigDecimal(names[0]);
        if (rs.wasNull()) {
            return null;
        }
        BigDecimal scaledEncryptedMessage = storedEncryptedMessage.setScale((int)this.decimalScale, 7);
        return this.encryptor.decrypt(scaledEncryptedMessage);
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index, SessionImplementor session) throws HibernateException, SQLException {
        this.checkInitialization();
        if (value == null) {
            st.setNull(index, 2);
        } else {
            BigDecimal scaledValue = ((BigDecimal)value).setScale((int)this.decimalScale, 1);
            BigDecimal encryptedMessage = this.encryptor.encrypt(scaledValue);
            st.setBigDecimal(index, encryptedMessage);
        }
    }

    public synchronized void setParameterValues(Properties parameters) {
        String paramEncryptorName = parameters.getProperty("encryptorRegisteredName");
        String paramAlgorithm = parameters.getProperty("algorithm");
        String paramPassword = parameters.getProperty("password");
        String paramKeyObtentionIterations = parameters.getProperty("keyObtentionIterations");
        String paramDecimalScale = parameters.getProperty("decimalScale");
        this.useEncryptorName = false;
        if (paramEncryptorName != null) {
            if (paramAlgorithm != null || paramPassword != null || paramKeyObtentionIterations != null) {
                throw new EncryptionInitializationException("If \"encryptorRegisteredName\" is specified, none of \"algorithm\", \"password\" or \"keyObtentionIterations\" can be specified");
            }
            this.encryptorName = paramEncryptorName;
            this.useEncryptorName = true;
        } else if (paramPassword != null) {
            this.password = paramPassword;
            if (paramAlgorithm != null) {
                this.algorithm = paramAlgorithm;
            }
            if (paramKeyObtentionIterations != null) {
                try {
                    this.keyObtentionIterations = new Integer(Integer.parseInt(paramKeyObtentionIterations));
                }
                catch (NumberFormatException e) {
                    throw new EncryptionInitializationException("Value specified for \"keyObtentionIterations\" is not a valid integer");
                }
            }
        } else {
            throw new EncryptionInitializationException("If \"encryptorRegisteredName\" is not specified, then \"password\" (and optionally \"algorithm\" and \"keyObtentionIterations\") must be specified");
        }
        if (paramDecimalScale != null) {
            try {
                this.decimalScale = new Integer(Integer.parseInt(paramDecimalScale));
            }
            catch (NumberFormatException e) {
                throw new EncryptionInitializationException("Value specified for \"decimalScale\" is not a valid integer");
            }
        } else {
            throw new EncryptionInitializationException("decimalScale must be specified");
        }
    }

    private synchronized void checkInitialization() {
        if (!this.initialized) {
            if (this.useEncryptorName) {
                HibernatePBEEncryptorRegistry registry = HibernatePBEEncryptorRegistry.getInstance();
                PBEBigDecimalEncryptor pbeEncryptor = registry.getPBEBigDecimalEncryptor(this.encryptorName);
                if (pbeEncryptor == null) {
                    throw new EncryptionInitializationException("No big decimal encryptor registered for hibernate with name \"" + this.encryptorName + "\"");
                }
                this.encryptor = pbeEncryptor;
            } else {
                StandardPBEBigDecimalEncryptor newEncryptor = new StandardPBEBigDecimalEncryptor();
                newEncryptor.setPassword(this.password);
                if (this.algorithm != null) {
                    newEncryptor.setAlgorithm(this.algorithm);
                }
                if (this.keyObtentionIterations != null) {
                    newEncryptor.setKeyObtentionIterations(this.keyObtentionIterations);
                }
                newEncryptor.initialize();
                this.encryptor = newEncryptor;
            }
            this.initialized = true;
        }
    }
}

