/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.config.annotation;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.core.convert.ConversionService;
import org.springframework.format.FormatterRegistry;
import org.springframework.format.support.DefaultFormattingConversionService;
import org.springframework.format.support.FormattingConversionService;
import org.springframework.http.MediaType;
import org.springframework.http.converter.ByteArrayHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.ResourceHttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.feed.AtomFeedHttpMessageConverter;
import org.springframework.http.converter.feed.RssChannelHttpMessageConverter;
import org.springframework.http.converter.json.GsonHttpMessageConverter;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.http.converter.support.AllEncompassingFormHttpMessageConverter;
import org.springframework.http.converter.xml.Jaxb2RootElementHttpMessageConverter;
import org.springframework.http.converter.xml.MappingJackson2XmlHttpMessageConverter;
import org.springframework.http.converter.xml.SourceHttpMessageConverter;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.ClassUtils;
import org.springframework.util.PathMatcher;
import org.springframework.validation.Errors;
import org.springframework.validation.MessageCodesResolver;
import org.springframework.validation.Validator;
import org.springframework.web.accept.ContentNegotiationManager;
import org.springframework.web.bind.support.ConfigurableWebBindingInitializer;
import org.springframework.web.bind.support.WebBindingInitializer;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.method.support.CompositeUriComponentsContributor;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.HandlerMethodReturnValueHandler;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.ViewResolver;
import org.springframework.web.servlet.config.annotation.AsyncSupportConfigurer;
import org.springframework.web.servlet.config.annotation.ContentNegotiationConfigurer;
import org.springframework.web.servlet.config.annotation.DefaultServletHandlerConfigurer;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.PathMatchConfigurer;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.ViewControllerRegistry;
import org.springframework.web.servlet.config.annotation.ViewResolverRegistry;
import org.springframework.web.servlet.handler.AbstractHandlerMapping;
import org.springframework.web.servlet.handler.BeanNameUrlHandlerMapping;
import org.springframework.web.servlet.handler.ConversionServiceExposingInterceptor;
import org.springframework.web.servlet.handler.HandlerExceptionResolverComposite;
import org.springframework.web.servlet.mvc.HttpRequestHandlerAdapter;
import org.springframework.web.servlet.mvc.SimpleControllerHandlerAdapter;
import org.springframework.web.servlet.mvc.annotation.ResponseStatusExceptionResolver;
import org.springframework.web.servlet.mvc.method.annotation.ExceptionHandlerExceptionResolver;
import org.springframework.web.servlet.mvc.method.annotation.JsonViewResponseBodyAdvice;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;
import org.springframework.web.servlet.mvc.support.DefaultHandlerExceptionResolver;
import org.springframework.web.servlet.resource.ResourceUrlProvider;
import org.springframework.web.servlet.resource.ResourceUrlProviderExposingInterceptor;
import org.springframework.web.servlet.view.InternalResourceViewResolver;
import org.springframework.web.servlet.view.ViewResolverComposite;
import org.springframework.web.util.UrlPathHelper;

public class WebMvcConfigurationSupport
implements ApplicationContextAware,
ServletContextAware {
    private static boolean romePresent = ClassUtils.isPresent((String)"com.rometools.rome.feed.WireFeed", (ClassLoader)WebMvcConfigurationSupport.class.getClassLoader());
    private static final boolean jaxb2Present = ClassUtils.isPresent((String)"javax.xml.bind.Binder", (ClassLoader)WebMvcConfigurationSupport.class.getClassLoader());
    private static final boolean jackson2Present = ClassUtils.isPresent((String)"com.fasterxml.jackson.databind.ObjectMapper", (ClassLoader)WebMvcConfigurationSupport.class.getClassLoader()) && ClassUtils.isPresent((String)"com.fasterxml.jackson.core.JsonGenerator", (ClassLoader)WebMvcConfigurationSupport.class.getClassLoader());
    private static final boolean jackson2XmlPresent = ClassUtils.isPresent((String)"com.fasterxml.jackson.dataformat.xml.XmlMapper", (ClassLoader)WebMvcConfigurationSupport.class.getClassLoader());
    private static final boolean gsonPresent = ClassUtils.isPresent((String)"com.google.gson.Gson", (ClassLoader)WebMvcConfigurationSupport.class.getClassLoader());
    private ApplicationContext applicationContext;
    private ServletContext servletContext;
    private List<Object> interceptors;
    private PathMatchConfigurer pathMatchConfigurer;
    private ContentNegotiationManager contentNegotiationManager;
    private List<HttpMessageConverter<?>> messageConverters;

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    @Bean
    public RequestMappingHandlerMapping requestMappingHandlerMapping() {
        RequestMappingHandlerMapping handlerMapping = new RequestMappingHandlerMapping();
        handlerMapping.setOrder(0);
        handlerMapping.setInterceptors(this.getInterceptors());
        handlerMapping.setContentNegotiationManager(this.mvcContentNegotiationManager());
        PathMatchConfigurer configurer = this.getPathMatchConfigurer();
        if (configurer.isUseSuffixPatternMatch() != null) {
            handlerMapping.setUseSuffixPatternMatch(configurer.isUseSuffixPatternMatch());
        }
        if (configurer.isUseRegisteredSuffixPatternMatch() != null) {
            handlerMapping.setUseRegisteredSuffixPatternMatch(configurer.isUseRegisteredSuffixPatternMatch());
        }
        if (configurer.isUseTrailingSlashMatch() != null) {
            handlerMapping.setUseTrailingSlashMatch(configurer.isUseTrailingSlashMatch());
        }
        if (configurer.getPathMatcher() != null) {
            handlerMapping.setPathMatcher(configurer.getPathMatcher());
        }
        if (configurer.getUrlPathHelper() != null) {
            handlerMapping.setUrlPathHelper(configurer.getUrlPathHelper());
        }
        return handlerMapping;
    }

    protected final Object[] getInterceptors() {
        if (this.interceptors == null) {
            InterceptorRegistry registry = new InterceptorRegistry();
            this.addInterceptors(registry);
            registry.addInterceptor(new ConversionServiceExposingInterceptor((ConversionService)this.mvcConversionService()));
            registry.addInterceptor(new ResourceUrlProviderExposingInterceptor(this.mvcResourceUrlProvider()));
            this.interceptors = registry.getInterceptors();
        }
        return this.interceptors.toArray();
    }

    protected void addInterceptors(InterceptorRegistry registry) {
    }

    protected PathMatchConfigurer getPathMatchConfigurer() {
        if (this.pathMatchConfigurer == null) {
            this.pathMatchConfigurer = new PathMatchConfigurer();
            this.configurePathMatch(this.pathMatchConfigurer);
        }
        return this.pathMatchConfigurer;
    }

    public void configurePathMatch(PathMatchConfigurer configurer) {
    }

    @Bean
    public ContentNegotiationManager mvcContentNegotiationManager() {
        if (this.contentNegotiationManager == null) {
            ContentNegotiationConfigurer configurer = new ContentNegotiationConfigurer(this.servletContext);
            configurer.mediaTypes(this.getDefaultMediaTypes());
            this.configureContentNegotiation(configurer);
            try {
                this.contentNegotiationManager = configurer.getContentNegotiationManager();
            }
            catch (Exception ex) {
                throw new BeanInitializationException("Could not create ContentNegotiationManager", (Throwable)ex);
            }
        }
        return this.contentNegotiationManager;
    }

    protected Map<String, MediaType> getDefaultMediaTypes() {
        HashMap<String, MediaType> map = new HashMap<String, MediaType>();
        if (romePresent) {
            map.put("atom", MediaType.APPLICATION_ATOM_XML);
            map.put("rss", MediaType.valueOf((String)"application/rss+xml"));
        }
        if (jaxb2Present || jackson2XmlPresent) {
            map.put("xml", MediaType.APPLICATION_XML);
        }
        if (jackson2Present || gsonPresent) {
            map.put("json", MediaType.APPLICATION_JSON);
        }
        return map;
    }

    protected void configureContentNegotiation(ContentNegotiationConfigurer configurer) {
    }

    @Bean
    public HandlerMapping viewControllerHandlerMapping() {
        ViewControllerRegistry registry = new ViewControllerRegistry();
        registry.setApplicationContext(this.applicationContext);
        this.addViewControllers(registry);
        AbstractHandlerMapping handlerMapping = registry.getHandlerMapping();
        handlerMapping = handlerMapping != null ? handlerMapping : new EmptyHandlerMapping();
        handlerMapping.setPathMatcher(this.mvcPathMatcher());
        handlerMapping.setUrlPathHelper(this.mvcUrlPathHelper());
        handlerMapping.setInterceptors(this.getInterceptors());
        return handlerMapping;
    }

    protected void addViewControllers(ViewControllerRegistry registry) {
    }

    @Bean
    public BeanNameUrlHandlerMapping beanNameHandlerMapping() {
        BeanNameUrlHandlerMapping mapping = new BeanNameUrlHandlerMapping();
        mapping.setOrder(2);
        mapping.setInterceptors(this.getInterceptors());
        return mapping;
    }

    @Bean
    public HandlerMapping resourceHandlerMapping() {
        ResourceHandlerRegistry registry = new ResourceHandlerRegistry(this.applicationContext, this.servletContext);
        this.addResourceHandlers(registry);
        AbstractHandlerMapping handlerMapping = registry.getHandlerMapping();
        if (handlerMapping != null) {
            handlerMapping.setPathMatcher(this.mvcPathMatcher());
            handlerMapping.setUrlPathHelper(this.mvcUrlPathHelper());
            handlerMapping.setInterceptors(new HandlerInterceptor[]{new ResourceUrlProviderExposingInterceptor(this.mvcResourceUrlProvider())});
        } else {
            handlerMapping = new EmptyHandlerMapping();
        }
        return handlerMapping;
    }

    protected void addResourceHandlers(ResourceHandlerRegistry registry) {
    }

    @Bean
    public ResourceUrlProvider mvcResourceUrlProvider() {
        PathMatcher pathMatcher;
        ResourceUrlProvider urlProvider = new ResourceUrlProvider();
        UrlPathHelper pathHelper = this.getPathMatchConfigurer().getUrlPathHelper();
        if (pathHelper != null) {
            urlProvider.setUrlPathHelper(pathHelper);
        }
        if ((pathMatcher = this.getPathMatchConfigurer().getPathMatcher()) != null) {
            urlProvider.setPathMatcher(pathMatcher);
        }
        return urlProvider;
    }

    @Bean
    public HandlerMapping defaultServletHandlerMapping() {
        DefaultServletHandlerConfigurer configurer = new DefaultServletHandlerConfigurer(this.servletContext);
        this.configureDefaultServletHandling(configurer);
        AbstractHandlerMapping handlerMapping = configurer.getHandlerMapping();
        handlerMapping = handlerMapping != null ? handlerMapping : new EmptyHandlerMapping();
        return handlerMapping;
    }

    protected void configureDefaultServletHandling(DefaultServletHandlerConfigurer configurer) {
    }

    @Bean
    public RequestMappingHandlerAdapter requestMappingHandlerAdapter() {
        ArrayList<HandlerMethodArgumentResolver> argumentResolvers = new ArrayList<HandlerMethodArgumentResolver>();
        this.addArgumentResolvers(argumentResolvers);
        ArrayList<HandlerMethodReturnValueHandler> returnValueHandlers = new ArrayList<HandlerMethodReturnValueHandler>();
        this.addReturnValueHandlers(returnValueHandlers);
        RequestMappingHandlerAdapter adapter = new RequestMappingHandlerAdapter();
        adapter.setContentNegotiationManager(this.mvcContentNegotiationManager());
        adapter.setMessageConverters(this.getMessageConverters());
        adapter.setWebBindingInitializer((WebBindingInitializer)this.getConfigurableWebBindingInitializer());
        adapter.setCustomArgumentResolvers(argumentResolvers);
        adapter.setCustomReturnValueHandlers(returnValueHandlers);
        if (jackson2Present) {
            ArrayList interceptors = new ArrayList();
            interceptors.add(new JsonViewResponseBodyAdvice());
            adapter.setResponseBodyAdvice(interceptors);
        }
        AsyncSupportConfigurer configurer = new AsyncSupportConfigurer();
        this.configureAsyncSupport(configurer);
        if (configurer.getTaskExecutor() != null) {
            adapter.setTaskExecutor(configurer.getTaskExecutor());
        }
        if (configurer.getTimeout() != null) {
            adapter.setAsyncRequestTimeout(configurer.getTimeout());
        }
        adapter.setCallableInterceptors(configurer.getCallableInterceptors());
        adapter.setDeferredResultInterceptors(configurer.getDeferredResultInterceptors());
        return adapter;
    }

    protected ConfigurableWebBindingInitializer getConfigurableWebBindingInitializer() {
        ConfigurableWebBindingInitializer initializer = new ConfigurableWebBindingInitializer();
        initializer.setConversionService((ConversionService)this.mvcConversionService());
        initializer.setValidator(this.mvcValidator());
        initializer.setMessageCodesResolver(this.getMessageCodesResolver());
        return initializer;
    }

    @Bean
    public FormattingConversionService mvcConversionService() {
        DefaultFormattingConversionService conversionService = new DefaultFormattingConversionService();
        this.addFormatters((FormatterRegistry)conversionService);
        return conversionService;
    }

    @Bean
    public Validator mvcValidator() {
        Validator validator = this.getValidator();
        if (validator == null) {
            if (ClassUtils.isPresent((String)"javax.validation.Validator", (ClassLoader)this.getClass().getClassLoader())) {
                Class clazz;
                try {
                    String className = "org.springframework.validation.beanvalidation.OptionalValidatorFactoryBean";
                    clazz = ClassUtils.forName((String)className, (ClassLoader)WebMvcConfigurationSupport.class.getClassLoader());
                }
                catch (ClassNotFoundException ex) {
                    throw new BeanInitializationException("Could not find default validator class", (Throwable)ex);
                }
                catch (LinkageError ex) {
                    throw new BeanInitializationException("Could not load default validator class", (Throwable)ex);
                }
                validator = (Validator)BeanUtils.instantiate((Class)clazz);
            } else {
                validator = new NoOpValidator();
            }
        }
        return validator;
    }

    @Bean
    public PathMatcher mvcPathMatcher() {
        if (this.getPathMatchConfigurer().getPathMatcher() != null) {
            return this.getPathMatchConfigurer().getPathMatcher();
        }
        return new AntPathMatcher();
    }

    @Bean
    public UrlPathHelper mvcUrlPathHelper() {
        if (this.getPathMatchConfigurer().getUrlPathHelper() != null) {
            return this.getPathMatchConfigurer().getUrlPathHelper();
        }
        return new UrlPathHelper();
    }

    protected Validator getValidator() {
        return null;
    }

    protected MessageCodesResolver getMessageCodesResolver() {
        return null;
    }

    protected void addArgumentResolvers(List<HandlerMethodArgumentResolver> argumentResolvers) {
    }

    protected void addReturnValueHandlers(List<HandlerMethodReturnValueHandler> returnValueHandlers) {
    }

    protected final List<HttpMessageConverter<?>> getMessageConverters() {
        if (this.messageConverters == null) {
            this.messageConverters = new ArrayList();
            this.configureMessageConverters(this.messageConverters);
            if (this.messageConverters.isEmpty()) {
                this.addDefaultHttpMessageConverters(this.messageConverters);
            }
            this.extendMessageConverters(this.messageConverters);
        }
        return this.messageConverters;
    }

    protected void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
    }

    protected void extendMessageConverters(List<HttpMessageConverter<?>> converters) {
    }

    protected final void addDefaultHttpMessageConverters(List<HttpMessageConverter<?>> messageConverters) {
        ObjectMapper objectMapper;
        StringHttpMessageConverter stringConverter = new StringHttpMessageConverter();
        stringConverter.setWriteAcceptCharset(false);
        messageConverters.add((HttpMessageConverter<?>)new ByteArrayHttpMessageConverter());
        messageConverters.add((HttpMessageConverter<?>)stringConverter);
        messageConverters.add((HttpMessageConverter<?>)new ResourceHttpMessageConverter());
        messageConverters.add((HttpMessageConverter<?>)new SourceHttpMessageConverter());
        messageConverters.add((HttpMessageConverter<?>)new AllEncompassingFormHttpMessageConverter());
        if (romePresent) {
            messageConverters.add((HttpMessageConverter<?>)new AtomFeedHttpMessageConverter());
            messageConverters.add((HttpMessageConverter<?>)new RssChannelHttpMessageConverter());
        }
        if (jackson2XmlPresent) {
            objectMapper = Jackson2ObjectMapperBuilder.xml().applicationContext(this.applicationContext).build();
            messageConverters.add((HttpMessageConverter<?>)new MappingJackson2XmlHttpMessageConverter(objectMapper));
        } else if (jaxb2Present) {
            messageConverters.add((HttpMessageConverter<?>)new Jaxb2RootElementHttpMessageConverter());
        }
        if (jackson2Present) {
            objectMapper = Jackson2ObjectMapperBuilder.json().applicationContext(this.applicationContext).build();
            messageConverters.add((HttpMessageConverter<?>)new MappingJackson2HttpMessageConverter(objectMapper));
        } else if (gsonPresent) {
            messageConverters.add((HttpMessageConverter<?>)new GsonHttpMessageConverter());
        }
    }

    protected void addFormatters(FormatterRegistry registry) {
    }

    public void configureAsyncSupport(AsyncSupportConfigurer configurer) {
    }

    @Bean
    public CompositeUriComponentsContributor mvcUriComponentsContributor() {
        return new CompositeUriComponentsContributor(this.requestMappingHandlerAdapter().getArgumentResolvers(), (ConversionService)this.mvcConversionService());
    }

    @Bean
    public HttpRequestHandlerAdapter httpRequestHandlerAdapter() {
        return new HttpRequestHandlerAdapter();
    }

    @Bean
    public SimpleControllerHandlerAdapter simpleControllerHandlerAdapter() {
        return new SimpleControllerHandlerAdapter();
    }

    @Bean
    public HandlerExceptionResolver handlerExceptionResolver() {
        ArrayList<HandlerExceptionResolver> exceptionResolvers = new ArrayList<HandlerExceptionResolver>();
        this.configureHandlerExceptionResolvers(exceptionResolvers);
        if (exceptionResolvers.isEmpty()) {
            this.addDefaultHandlerExceptionResolvers(exceptionResolvers);
        }
        HandlerExceptionResolverComposite composite = new HandlerExceptionResolverComposite();
        composite.setOrder(0);
        composite.setExceptionResolvers(exceptionResolvers);
        return composite;
    }

    protected void configureHandlerExceptionResolvers(List<HandlerExceptionResolver> exceptionResolvers) {
    }

    protected final void addDefaultHandlerExceptionResolvers(List<HandlerExceptionResolver> exceptionResolvers) {
        ExceptionHandlerExceptionResolver exceptionHandlerExceptionResolver = new ExceptionHandlerExceptionResolver();
        exceptionHandlerExceptionResolver.setContentNegotiationManager(this.mvcContentNegotiationManager());
        exceptionHandlerExceptionResolver.setMessageConverters(this.getMessageConverters());
        if (jackson2Present) {
            ArrayList interceptors = new ArrayList();
            interceptors.add(new JsonViewResponseBodyAdvice());
            exceptionHandlerExceptionResolver.setResponseBodyAdvice(interceptors);
        }
        exceptionHandlerExceptionResolver.setApplicationContext(this.applicationContext);
        exceptionHandlerExceptionResolver.afterPropertiesSet();
        exceptionResolvers.add(exceptionHandlerExceptionResolver);
        ResponseStatusExceptionResolver responseStatusExceptionResolver = new ResponseStatusExceptionResolver();
        responseStatusExceptionResolver.setMessageSource((MessageSource)this.applicationContext);
        exceptionResolvers.add(responseStatusExceptionResolver);
        exceptionResolvers.add(new DefaultHandlerExceptionResolver());
    }

    @Bean
    public ViewResolver mvcViewResolver() {
        String[] names;
        ViewResolverRegistry registry = new ViewResolverRegistry();
        registry.setContentNegotiationManager(this.mvcContentNegotiationManager());
        registry.setApplicationContext(this.applicationContext);
        this.configureViewResolvers(registry);
        if (registry.getViewResolvers().isEmpty() && (names = BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)this.applicationContext, ViewResolver.class, (boolean)true, (boolean)false)).length == 1) {
            registry.getViewResolvers().add(new InternalResourceViewResolver());
        }
        ViewResolverComposite composite = new ViewResolverComposite();
        composite.setOrder(registry.getOrder());
        composite.setViewResolvers(registry.getViewResolvers());
        composite.setApplicationContext(this.applicationContext);
        composite.setServletContext(this.servletContext);
        return composite;
    }

    protected void configureViewResolvers(ViewResolverRegistry registry) {
    }

    private static final class NoOpValidator
    implements Validator {
        private NoOpValidator() {
        }

        public boolean supports(Class<?> clazz) {
            return false;
        }

        public void validate(Object target, Errors errors) {
        }
    }

    private static final class EmptyHandlerMapping
    extends AbstractHandlerMapping {
        private EmptyHandlerMapping() {
        }

        @Override
        protected Object getHandlerInternal(HttpServletRequest request) {
            return null;
        }
    }
}

