/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.spdy.parser;

import java.nio.ByteBuffer;
import org.eclipse.jetty.spdy.frames.PingFrame;
import org.eclipse.jetty.spdy.parser.ControlFrameBodyParser;
import org.eclipse.jetty.spdy.parser.ControlFrameParser;

public class PingBodyParser
extends ControlFrameBodyParser {
    private final ControlFrameParser controlFrameParser;
    private State state = State.PING_ID;
    private int cursor;
    private int pingId;

    public PingBodyParser(ControlFrameParser controlFrameParser) {
        this.controlFrameParser = controlFrameParser;
    }

    @Override
    public boolean parse(ByteBuffer buffer) {
        block4: while (buffer.hasRemaining()) {
            switch (this.state) {
                case PING_ID: {
                    if (buffer.remaining() >= 4) {
                        this.pingId = buffer.getInt() & Integer.MAX_VALUE;
                        this.onPing();
                        return true;
                    }
                    this.state = State.PING_ID_BYTES;
                    this.cursor = 4;
                    continue block4;
                }
                case PING_ID_BYTES: {
                    byte currByte = buffer.get();
                    --this.cursor;
                    this.pingId += (currByte & 0xFF) << 8 * this.cursor;
                    if (this.cursor != 0) continue block4;
                    this.onPing();
                    return true;
                }
            }
            throw new IllegalStateException();
        }
        return false;
    }

    private void onPing() {
        PingFrame frame = new PingFrame(this.controlFrameParser.getVersion(), this.pingId);
        this.controlFrameParser.onControlFrame(frame);
        this.reset();
    }

    private void reset() {
        this.state = State.PING_ID;
        this.cursor = 0;
        this.pingId = 0;
    }

    private static enum State {
        PING_ID,
        PING_ID_BYTES;

    }
}

