/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.StringTokenizer;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import sunlabs.brazil.server.Handler;
import sunlabs.brazil.server.Request;
import sunlabs.brazil.server.Server;

public class TransformHandler
implements Handler {
    private TransformerFactory m_tf = null;
    private final String PARAM_TRANSLET = "translet=";
    private final String PARAM_DOCUMENT = "document=";
    private final String PARAM_STATS = "stats=";
    private PrintWriter m_out = null;

    public void errorMessage(String message, Exception e) {
        if (this.m_out == null) {
            return;
        }
        this.m_out.println("<h1>XSL transformation error</h1>" + message);
        this.m_out.println("<br>Exception:</br>" + e.toString());
    }

    public void errorMessage(String message) {
        if (this.m_out == null) {
            return;
        }
        this.m_out.println("<h1>XSL transformation error</h1>" + message);
    }

    public boolean init(Server server, String prefix) {
        return true;
    }

    public boolean respond(Request request) throws IOException {
        StringWriter sout;
        block9: {
            sout = new StringWriter();
            this.m_out = new PrintWriter(sout);
            String transletName = null;
            String document = null;
            String stats = null;
            StringTokenizer params = new StringTokenizer(request.query, "&");
            while (params.hasMoreElements()) {
                String param = params.nextToken();
                if (param.startsWith("translet=")) {
                    transletName = param.substring("translet=".length());
                    continue;
                }
                if (param.startsWith("document=")) {
                    document = param.substring("document=".length());
                    continue;
                }
                if (!param.startsWith("stats=")) continue;
                stats = param.substring("stats=".length());
            }
            try {
                if (transletName == null || document == null) {
                    this.errorMessage("Parameters <b><tt>translet</tt></b> and/or <b><tt>document</tt></b> not specified.");
                    break block9;
                }
                if (this.m_tf == null) {
                    this.m_tf = TransformerFactory.newInstance();
                    try {
                        this.m_tf.setAttribute("use-classpath", Boolean.TRUE);
                    }
                    catch (IllegalArgumentException iae) {
                        System.err.println("Could not set XSLTC-specific TransformerFactory attributes.  Transformation failed.");
                    }
                }
                Transformer t = this.m_tf.newTransformer(new StreamSource(transletName));
                long start = System.currentTimeMillis();
                t.transform(new StreamSource(document), new StreamResult(this.m_out));
                long done = System.currentTimeMillis() - start;
                this.m_out.println("<!-- transformed by XSLTC in " + done + "ms -->");
            }
            catch (Exception e) {
                this.errorMessage("Internal error.", e);
            }
        }
        request.sendResponse(sout.toString());
        return true;
    }
}

